/* ***************************************************************************************
* FILE:          FDefaultInputMsgProcessor.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultInputMsgProcessor.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_INPUT_MSG_PROCESSOR_H__
#define __FOCUS_DEFAULT_INPUT_MSG_PROCESSOR_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FTask.h"

namespace Focus {

//////////////////////////////////////////////////////////////////////////////////////////////
class FSession;
class FManager;
class FMsgQueue;
class FDefaultInputMsgProcessor : public FSessionUpdater
{
      typedef FSessionUpdater Base;

   public:
      FDefaultInputMsgProcessor(FManager& manager) : Base(manager) {}
      virtual ~FDefaultInputMsgProcessor() {};

      virtual FTask::Result update(FSession& session);

   protected:
      bool dispatchMessage(FSession& session, const FMessage& msg);

   private:
      FDefaultInputMsgProcessor(const FDefaultInputMsgProcessor&);
      FDefaultInputMsgProcessor& operator=(const FDefaultInputMsgProcessor&);
};


}

#endif
