/* ***************************************************************************************
* FILE:          FDefaultEnterKeyController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultEnterKeyController.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_ENTER_KEY_CONTROLLER_H__
#define __FOCUS_DEFAULT_ENTER_KEY_CONTROLLER_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FController.h"

namespace Focus {
/**************************************************************************/
/* FORWARD DECLARATIONS                                                   */
/**************************************************************************/
class FManager;
class FGroup;
class FSession;


/**************************************************************************/
/* ENTER KEY CONTROLLER                                                   */
/* Handles the enter key related messages.                                */
/**************************************************************************/
class FDefaultEnterKeyController : public FController
{
   public:
      FDefaultEnterKeyController(FManager& manager) : _manager(manager) {}
      virtual ~FDefaultEnterKeyController() {}

      virtual bool onMessage(FSession& session, FGroup& group, const FMessage& msg);

   protected:
      FManager& _manager;

   private:
      FDefaultEnterKeyController(const FDefaultEnterKeyController&);
      FDefaultEnterKeyController& operator=(const FDefaultEnterKeyController&);
};


}
#endif
