/* ***************************************************************************************
* FILE:          FDefaultEnterKeyController.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultEnterKeyController.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FDefaultEnterKeyController.h"
#include "Focus/FManager.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FDefaultEnterKeyController.cpp.trc.h"
#endif

namespace Focus {

bool FDefaultEnterKeyController::onMessage(FSession& session, FGroup& group, const FMessage& msg)
{
   (void)session;
   (void)group;

   if (msg.GetId() == EnterKeyStatusChangedUpdMsg::ID)
   {
      ETG_TRACE_USR1_THR(("FDefaultEnterKeyController::onMessage(EnterKeyStatusChangedUpdMsg) app=%d", _manager.getCurrentAppId()));
      if (_manager.getActivityTimer() != NULL)
      {
         _manager.getActivityTimer()->restart();
      }
      if (_manager.getOutputMsgHandler() != NULL)
      {
         return _manager.getOutputMsgHandler()->dispatchToViews(msg);
      }
   }
   return false;
}


}
