/* ***************************************************************************************
* FILE:          FDefaultDisplayCoordinateController.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultDisplayCoordinateController.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FDefaultDisplayCoordinateController.h"
#include <Focus/FData.h>
#include <Focus/FManager.h>
#include <View/CGI/CgiExtensions/SurfaceUtils.h>

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FDefaultDisplayCoordinateController.cpp.trc.h"
#endif

namespace Focus {

bool FDefaultDisplayCoordinateController::configureWidget(FSession& session, FWidgetConfig& handle, FFrameworkWidget& widget)
{
   (void)session;

   if ((widget.GetParentView() != NULL) && widget.GetParentView()->Is2D())
   {
      //get camera vector from the view scene
      const Courier::ViewScene2D::CameraPtrVector& cameras = widget.GetParentView()->ToViewScene2D()->GetCameraPtrVector();
      for (FeatStd::SizeType i = 0; i < cameras.Size(); ++i)
      {
         Candera::Camera2D* camera = cameras[i];
         //check if camera is rendered and if it is linked to a render target
         if ((camera != NULL) && (camera->GetRenderTarget() != NULL) && camera->IsEffectiveRenderingEnabled())
         {
            //create only if necessary
            FCameraDataVector* cameraDataVector = handle.View.getOrCreateData<FCameraDataVector>();

            FCameraData cameraData;
            if ((cameraDataVector != NULL) && hmibase::view::util::SurfaceUtils::transformSceneToDisplay(*camera, cameraData.DisplayOffset))
            {
               cameraData.DisplayId = hmibase::view::util::SurfaceUtils::getDisplayId(*(camera->GetRenderTarget()));
               cameraDataVector->push_back(cameraData);
            }
         }
      }
   }

   return true;
}


}
