/* ***************************************************************************************
* FILE:          FDefaultCrtAppExchange.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultCrtAppExchange.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_CRT_APP_EXCHANGE_H__
#define __FOCUS_DEFAULT_CRT_APP_EXCHANGE_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FTask.h"

namespace Focus {
//////////////////////////////////////////////////////////////////////////////////////////////
class FSession;
class FManager;
class FViewConfig;

//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultCourierInfoCollector : public FTask
{
      typedef FTask Base;

   public:
      FDefaultCourierInfoCollector(FManager& manager) : Base(manager) {}
      virtual ~FDefaultCourierInfoCollector() {};

      virtual FTask::Result execute();

   private:
      FDefaultCourierInfoCollector(const FDefaultCourierInfoCollector&);
      FDefaultCourierInfoCollector& operator=(const FDefaultCourierInfoCollector&);
};


//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultCourierInfoPublisher : public FTask
{
      typedef FTask Base;

   public:
      FDefaultCourierInfoPublisher(FManager& manager) : Base(manager) {}
      virtual ~FDefaultCourierInfoPublisher() {};

      virtual FTask::Result execute();

   private:
      FDefaultCourierInfoPublisher(const FDefaultCourierInfoPublisher&);
      FDefaultCourierInfoPublisher& operator=(const FDefaultCourierInfoPublisher&);
};


//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultCrtAppState2SessionUpdater : public FSessionUpdater
{
      typedef FSessionUpdater Base;

   public:
      FDefaultCrtAppState2SessionUpdater(FManager& manager) : Base(manager) {}
      virtual ~FDefaultCrtAppState2SessionUpdater() {};

      virtual FTask::Result update(FSession& session);

   private:
      FDefaultCrtAppState2SessionUpdater(const FDefaultCrtAppState2SessionUpdater&);
      FDefaultCrtAppState2SessionUpdater& operator=(const FDefaultCrtAppState2SessionUpdater&);
};


//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultSession2CrtAppStateUpdater : public FSessionUpdater
{
      typedef FSessionUpdater Base;

   public:
      FDefaultSession2CrtAppStateUpdater(FManager& manager) : Base(manager) {}
      virtual ~FDefaultSession2CrtAppStateUpdater() {};

      virtual FTask::Result update(FSession& session);

   private:
      FDefaultSession2CrtAppStateUpdater(const FDefaultSession2CrtAppStateUpdater&);
      FDefaultSession2CrtAppStateUpdater& operator=(const FDefaultSession2CrtAppStateUpdater&);
};


}

#endif
