/* ***************************************************************************************
* FILE:          FDefaultCrtAppExchange.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultCrtAppExchange.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FDefaultCrtAppExchange.h"
#include "Focus/FData.h"
#include "Focus/FManager.h"
#include "Focus/FSession.h"
#include "Focus/FStateInfo.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FDefaultCrtAppExchange.cpp.trc.h"
#endif

namespace Focus {

FTask::Result FDefaultCourierInfoCollector::execute()
{
   ETG_TRACE_USR1_THR(("FDefaultCourierInfoCollector::execute app=%d", _manager.getCurrentAppId()));

   FSession* session = _manager.getSession();
   if (session != NULL)
   {
      session->ActiveViewGroup.reset();
      session->resetCurrentAppConfig();
   }

   if (_manager.getOutputMsgHandler() != NULL)
   {
      RegisterFocusableWidgetsReqMsg msg(session);
      _manager.getOutputMsgHandler()->dispatchToViews(msg);

      //if (!_manager.getCurrentAppState().PointsToNull())
      //{
      //   for (size_t i = 0; i < _manager.getCurrentAppState()->getChildCount(); ++i)
      //   {
      //      FViewState* viewState = _manager.getCurrentAppState()->getChild(i);
      //      if ((viewState != NULL) && (viewState->isActive()))
      //      {
      //         RegisterFocusableWidgetsReqMsg msg(_manager.getSession());
      //         _manager.getOutputMsgHandler()->dispatchToView(viewState->getId(), msg);
      //      }
      //   }
      //}
   }
   return FTask::Completed;
}


FTask::Result FDefaultCourierInfoPublisher::execute()
{
   ETG_TRACE_USR1_THR(("FDefaultCourierInfoPublisher::execute app=%d", _manager.getCurrentAppId()));

   _manager.publishCurrentFocus();

   return FTask::Completed;
}


FTask::Result FDefaultCrtAppState2SessionUpdater::update(FSession& session)
{
   ETG_TRACE_USR1_THR(("FDefaultCrtAppState2SessionUpdater::update app=%d", _manager.getCurrentAppId()));

   FAppStateSharedPtr appState = _manager.getCurrentAppState();
   if (!appState.PointsToNull())
   {
      session.StateInfo.add(_manager.getCurrentAppId(), appState);
   }

   return FTask::Completed;
}


FTask::Result FDefaultSession2CrtAppStateUpdater::update(FSession& session)
{
   ETG_TRACE_USR1_THR(("FDefaultSession2CrtAppStateUpdater::update app=%d", _manager.getCurrentAppId()));

   FAppStateSharedPtr appState = session.StateInfo.get(_manager.getCurrentAppId());
   if (!appState.PointsToNull())
   {
      _manager.setCurrentAppState(appState);
   }

   return FTask::Completed;
}


}
