/* ***************************************************************************************
* FILE:          FDefaultConsistencyChecker.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultConsistencyChecker.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_CONSISTENCY_CHECKER_H__
#define __FOCUS_DEFAULT_CONSISTENCY_CHECKER_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FManagerConfig.h"

namespace Focus {
//////////////////////////////////////////////////////////////////////////////////////////////
class FManager;

//////////////////////////////////////////////////////////////////////////////////////////////
class FDefaultConsistencyChecker : public FConsistencyChecker, public FMsgReceiver
{
   public:
      FDefaultConsistencyChecker(FManager& manager, AppViewHandler& viewhandler);
      virtual ~FDefaultConsistencyChecker();

      virtual bool checkFocus();
      virtual bool onMessage(const Focus::FMessage& msg);

   protected:
      void registerMsgReceiver();
      void unregisterMsgReceiver();

      FManager& _manager;
      AppViewHandler& _viewHandler;

   private:
      FDefaultConsistencyChecker(const FDefaultConsistencyChecker&);
      FDefaultConsistencyChecker& operator=(const FDefaultConsistencyChecker&);
};


}

#endif
