/* ***************************************************************************************
* FILE:          FDefaultConsistencyChecker.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultConsistencyChecker.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "View/CGI/CgiExtensions/AppViewHandler.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FDefaultConsistencyChecker.h"
#include "Focus/FData.h"
#include "Focus/FManager.h"
#include "Focus/FSession.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FDefaultConsistencyChecker.cpp.trc.h"
#endif

namespace Focus {

FDefaultConsistencyChecker::FDefaultConsistencyChecker(FManager& manager, AppViewHandler& viewhandler) :
   _manager(manager), _viewHandler(viewhandler)
{
   static bool viewSubscribed = false;
   if (!viewSubscribed)
   {
      viewSubscribed = true;
      //this message receiver receives the messages through the focus manager which belongs to the view component
      Courier::ActivationResMsg::Subscribe(Courier::ComponentType::View);      //lint !e641
      Courier::ViewResMsg::Subscribe(Courier::ComponentType::View);            //lint !e641
   }

   registerMsgReceiver();
}


FDefaultConsistencyChecker::~FDefaultConsistencyChecker()
{
   unregisterMsgReceiver();
}


void FDefaultConsistencyChecker::registerMsgReceiver()
{
   _manager.addMsgReceiver(*this);
}


void FDefaultConsistencyChecker::unregisterMsgReceiver()
{
   _manager.removeMsgReceiver(*this);
}


bool FDefaultConsistencyChecker::checkFocus()
{
   bool valid = false;
   const FViewId& viewId = _manager.getCurrentFocus().ViewId;

   //fastest way to check if focus is visible
   if ((viewId != Constants::InvalidViewId) && _manager.isFocusVisible())
   {
      const FId& widgetId = _manager.getCurrentFocus().WidgetId;
      valid = (widgetId != Constants::InvalidId)
              && _manager.isViewActive(viewId)
              && (_viewHandler.FindWidget(viewId,

                                          Courier::CompositePath(),

                                          Courier::ItemId(widgetId.c_str())) != NULL);

      if (!valid)
      {
         ETG_TRACE_USR1_THR(("FDefaultConsistencyChecker::checkFocus Focused widget %s is not available anymore, hiding focus...", FID_STR(widgetId)));

         _manager.hideFocus();
      }
   }

   return valid;
}


bool FDefaultConsistencyChecker::onMessage(const Focus::FMessage& msg)
{
   switch (msg.GetId())
   {
      case Courier::ViewResMsg::ID:
      {
         const Courier::ViewResMsg* resMsg = Courier::message_cast<const Courier::ViewResMsg*>(&msg);
         if ((resMsg != NULL) && (resMsg->GetViewId() != Constants::InvalidViewId) && (resMsg->GetViewId() == _manager.getCurrentFocus().ViewId))
         {
            checkFocus();
         }
         break;
      }

      case Courier::ActivationResMsg::ID:
      {
         const Courier::ActivationResMsg* resMsg = Courier::message_cast<const Courier::ActivationResMsg*>(&msg);
         if ((resMsg != NULL) && (resMsg->GetViewId() != Constants::InvalidViewId) && (resMsg->GetViewId() == _manager.getCurrentFocus().ViewId))
         {
            checkFocus();
         }
         break;
      }

      default:
         break;
   }
   return false;
}


}
