/* ***************************************************************************************
* FILE:          FDefaultAvgManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultAvgManager.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_DEFAULT_AVG_MANAGER_H__
#define __FOCUS_DEFAULT_AVG_MANAGER_H__

/*****************************************************************************/
/* FOCUS MANAGER INCLUDES                                                    */
/*****************************************************************************/
#include "Focus/FCommon.h"
#include "Focus/FActiveViewGroup.h"
#include "Focus/FManagerConfig.h"

namespace Focus {
//////////////////////////////////////////////////////////////////////////////////////////////
class FManager;

class FDefaultAvgManager : public FAvgManager
{
   public:
      FDefaultAvgManager(FManager& manager) : _manager(manager) {}

      virtual bool isCurrentFocusAvailable(FSession& session, FGroup* group = NULL);
      virtual Focusable* getCurrentFocusChild(FSession& session, FGroup& group);
      virtual Focusable* getDefaultFocusChild(FSession& session, FGroup& group);

      virtual Focusable* getFocus(FSession& session, FGroup* group = NULL);
      virtual void setFocus(FSession& session, Focusable* f);

      virtual int moveFocus(FSession& session, FGroup& group, int steps);

   protected:
      Focusable* getFocusImpl(FSession& session, FGroup& group);
      void setFocusImpl(FSession& session, FGroup& group, const Focusable* f);

      FManager& _manager;

   private:
      FDefaultAvgManager(const FDefaultAvgManager&);
      FDefaultAvgManager& operator=(const FDefaultAvgManager&);
};


}
#endif
