/* ***************************************************************************************
* FILE:          FDefaultAnimationManager.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FDefaultAvgManager.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "View/CGI/CgiExtensions/AppViewHandler.h"
#include "View/CGI/CgiExtensions/AnimationWrapper.h"
#include "CanderaAssetLoader/AssetLoaderBase/AnimationPropertySetterFactory.h"

///////////////////////////////////////////////////////////////////////////////
//focus manager includes
#include "FDefaultAnimationManager.h"
#include "Focus/FData.h"
#include "Focus/FManager.h"
#include "Focus/FUtils.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FDefaultAnimationManager.cpp.trc.h"
#endif

namespace Focus {

///////////////////////////////////////////////////////////////////////////////
FDefaultAnimationManager::FDefaultAnimationManager(FManager& manager, AppViewHandler& viewhandler)
   : _manager(manager), _viewHandler(viewhandler), _markerAnimatedProperty(NULL), _markerAnimation(NULL)
{
   _markerAnimatedProperty = CANDERA_NEW(::hmibase::view::AnimatedPropertyWrapper);
   _markerAnimation = CANDERA_NEW(::hmibase::view::AnimationWrapper)(viewhandler);
   registerListener();
}


///////////////////////////////////////////////////////////////////////////////
FDefaultAnimationManager::~FDefaultAnimationManager()
{
   unregisterListener();
   if (_markerAnimation != NULL)
   {
      CANDERA_DELETE(_markerAnimation);
      _markerAnimation = NULL;
   }
   if (_markerAnimatedProperty != NULL)
   {
      CANDERA_DELETE(_markerAnimatedProperty);
      _markerAnimatedProperty = NULL;
   }
}


///////////////////////////////////////////////////////////////////////////////
void FDefaultAnimationManager::registerListener()
{
   _manager.addListener(*this);
}


///////////////////////////////////////////////////////////////////////////////
void FDefaultAnimationManager::unregisterListener() const
{
   _manager.removeListener(*this);
}


///////////////////////////////////////////////////////////////////////////////
void FDefaultAnimationManager::initAnimation()
{
   if ((_markerAnimation != NULL) && _markerAnimation->getPlayer().PointsToNull())
   {
      _markerAnimation->init();
      _markerAnimation->addListener(this);

      //2 keyframes (at 0ms and 1000ms), 2 channels (X,Y)
      _markerAnimatedProperty->init(2, 2, Candera::Animation::LinearInterpolationStrategy::Create());
      _markerAnimatedProperty->setSequenceTime(0, 0);
      _markerAnimatedProperty->setSequenceTime(1, 1000);

      _markerAnimatedProperty->addToPlayer(_markerAnimation->getPlayer());
   }
}


//FocusGroupWidget2D* FDefaultAnimationManager::getFocusGroupWidget(const FViewWidgetId& widgetId) const
//{
//   FocusGroupWidget2D* groupWidget = NULL;
//   if (widgetId.ViewId != Constants::InvalidViewId)
//   {
//      groupWidget = dynamic_cast<FocusGroupWidget2D*>(_viewHandler.FindWidget(widgetId.ViewId, Courier::CompositePath(), Courier::ItemId(widgetId.WidgetId.c_str())));
//   }
//   return groupWidget;
//}


FViewWidgetId FDefaultAnimationManager::getMarkerGroupId(const FWidget& widget) const
{
   for (FGroup* parent = widget.getParent(); parent != NULL; parent = parent->getParent())
   {
      if (parent->getData<FMarkerNodeData>() != NULL)
      {
         return FViewWidgetId(widget.Config.View.getId(), parent->getId());
      }
   }
   return FViewWidgetId();
}


///////////////////////////////////////////////////////////////////////////////
void FDefaultAnimationManager::onInternalSetFocus(FSession& session, Focusable* newFocus)
{
   (void)session;
   (void)newFocus;

   if ((_manager.getAvgManager() == NULL) || (_markerAnimation == NULL) || (_markerAnimatedProperty == NULL) || (!_manager.isFocusVisible()))
   {
      return;
   }

   ////one time initialization
   //initAnimation();

   ////hide the focus marker for the previous focus change animation
   //FocusGroupWidget2D* markerGroupWidget = getFocusGroupWidget(_markerGroupId);
   //if ((markerGroupWidget != NULL) && (markerGroupWidget->getFocusMarkerNode() != NULL))
   //{
   //   markerGroupWidget->getFocusMarkerNode()->SetRenderingEnabled(false);
   //}

   //FWidget* crtFocusWidget = dynamic_cast<FWidget*>(_manager.getAvgManager()->getFocus(session));
   //FWidget* newFocusWidget = dynamic_cast<FWidget*>(newFocus);
   ////if a focus change occurred
   //if ((crtFocusWidget != NULL) && (newFocusWidget != NULL) && (crtFocusWidget != newFocusWidget))
   //{
   //   //get the rectangle and the associated focus group id (with a marker) for the old focus
   //   FRectangle* crtFocusRectangle = crtFocusWidget->Config.getData<FRectangle>();
   //   FViewWidgetId crtFocusMarkerGroupId = getMarkerGroupId(*crtFocusWidget);

   //   //get the rectangle and the associated focus group id (with a marker) for the new focus
   //   FRectangle* newFocusRectangle = newFocusWidget->Config.getData<FRectangle>();
   //   FViewWidgetId newFocusMarkerGroupId = getMarkerGroupId(*newFocusWidget);

   //   //if old and new focus share the same marker node and a different rectangles
   //   if ((crtFocusMarkerGroupId == newFocusMarkerGroupId)
   //         && (newFocusRectangle != NULL) && (crtFocusRectangle != NULL)
   //         && (newFocusRectangle->GetPosition() != crtFocusRectangle->GetPosition())
   //      )
   //   {
   //      if (_markerGroupId != newFocusMarkerGroupId)
   //      {
   //         _markerGroupId = newFocusMarkerGroupId;
   //         markerGroupWidget = getFocusGroupWidget(_markerGroupId);
   //      }

   //      if ((markerGroupWidget != NULL) && (markerGroupWidget->getFocusMarkerNode() != NULL))
   //      {
   //         //first keyframe
   //         _markerAnimatedProperty->setKeyframeValue(0, 0, crtFocusRectangle->GetLeft());
   //         _markerAnimatedProperty->setKeyframeValue(0, 1, crtFocusRectangle->GetTop());

   //         //second keyframe
   //         _markerAnimatedProperty->setKeyframeValue(1, 0, newFocusRectangle->GetLeft());
   //         _markerAnimatedProperty->setKeyframeValue(1, 1, newFocusRectangle->GetTop());

   //         //transformable
   //         Candera::Animation::AnimationPropertySetter::SharedPointer propertySetter = AnimationPropertySetterUtils::createNodePropertySetter<Candera::Animation::Transformable2DTranslatePropertySetter>(markerGroupWidget->getFocusMarkerNode());
   //         _markerAnimatedProperty->setPropertySetter(propertySetter);

   //         //start animation and show the marker node
   //         if (_markerAnimation->start())
   //         {
   //            markerGroupWidget->getFocusMarkerNode()->SetRenderingEnabled(true);
   //         }
   //      }
   //   }
   //}
}


///////////////////////////////////////////////////////////////////////////////
bool FDefaultAnimationManager::isAnimationRunning(FFrameworkWidget* /*widget*/)
{
   return (_markerAnimation != NULL) && !_markerAnimation->getPlayer().PointsToNull() && _markerAnimation->getPlayer()->IsEnabled();
}


///////////////////////////////////////////////////////////////////////////////
void FDefaultAnimationManager::OnStartAnimation(Candera::Animation::AnimationPlayerBase* /*animationPlayer*/)
{
}


///////////////////////////////////////////////////////////////////////////////
void FDefaultAnimationManager::OnStopAnimation(Candera::Animation::AnimationPlayerBase* /*animationPlayer*/)
{
   //FocusGroupWidget2D* markerGroupWidget = getFocusGroupWidget(_markerGroupId);
   //if ((markerGroupWidget != NULL) && (markerGroupWidget->getFocusMarkerNode() != NULL))
   //{
   //   markerGroupWidget->getFocusMarkerNode()->SetRenderingEnabled(false);
   //}
}


///////////////////////////////////////////////////////////////////////////////
void FDefaultAnimationManager::OnFinishAnimation(Candera::Animation::AnimationPlayerBase* /*animationPlayer*/)
{
   //FocusGroupWidget2D* markerGroupWidget = getFocusGroupWidget(_markerGroupId);
   //if ((markerGroupWidget != NULL) && (markerGroupWidget->getFocusMarkerNode() != NULL))
   //{
   //   markerGroupWidget->getFocusMarkerNode()->SetRenderingEnabled(false);
   //}
}


///////////////////////////////////////////////////////////////////////////////
void FDefaultAnimationManager::OnPastEnd(Candera::Animation::AnimationPlayerBase* /*animationPlayer*/, Candera::Int32 /*completedIterationsCount*/)
{
   //FocusGroupWidget2D* markerGroupWidget = getFocusGroupWidget(_markerGroupId);
   //if ((markerGroupWidget != NULL) && (markerGroupWidget->getFocusMarkerNode() != NULL))
   //{
   //   markerGroupWidget->getFocusMarkerNode()->SetRenderingEnabled(false);
   //}
}


}
