/* ***************************************************************************************
* FILE:          SceneInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SceneInfo is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_UTIL_SCENEINFO
#define HMIBASE_UTIL_SCENEINFO

namespace hmibase {
namespace util {

class SceneInfo
{
   public:
      struct Data
      {
         unsigned int mId;
         const char* mName;
      };

      const char* GetStaticSceneName(unsigned int id) const;
      const char* GetStaticSceneName(const char* name) const ;

      static const Data* _scenes;
      static const unsigned int _sceneCount;
};


}
}


#endif
