/* ***************************************************************************************
* FILE:          SceneInfo.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SceneInfo is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include <hmibase/sys_std_if.h>
#include "SceneInfo.h"
#include <algorithm>

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SceneInfo.cpp.trc.h"
#endif

namespace hmibase {
namespace util {
const char* SceneInfo::GetStaticSceneName(unsigned int id) const
{
   static const char* empty = "";
   for (unsigned int i = 0; i < _sceneCount; ++i)
   {
      if (_scenes != 0 && id == _scenes[i].mId)
      {
         return _scenes[i].mName;
      }
   }

   ETG_TRACE_ERR_THR(("Id 0x%x can't be resolved to known scene name", id));
   return empty;
}


const char* SceneInfo::GetStaticSceneName(const char* name) const
{
   static const char* empty = "";
   for (unsigned int i = 0; i < _sceneCount; ++i)
   {
      if (_scenes != 0 && (strcmp(name, _scenes[i].mName) == 0))
      {
         return _scenes[i].mName;
      }
   }

   ETG_TRACE_ERR_THR(("'%s' is not defined in HMIContract", name));
   return empty;
}


}
}
