/* ***************************************************************************************
* FILE:          DataSet.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DataSet.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __DATA_SET_H__
#define __DATA_SET_H__


namespace hmibase {
namespace util {


class DataSet
{
   public:
      DataSet() : _first(NULL) {}

      ~DataSet()
      {
         if (_first != NULL)
         {
            FEATSTD_DELETE(_first);
            _first = NULL;
         }
      }

      void reset()
      {
         if (_first != NULL)
         {
            FEATSTD_DELETE(_first);
            _first = NULL;
         }
      }

      template<typename TData>
      void set(const TData& data)
      {
         DataTypeId typeId = DataWrapper<TData>::getDataTypeId();
         for (DataWrapperBase* it = _first; it != NULL; it = it->getNext())
         {
            if (it->isType(typeId))
            {
               ((static_cast<DataWrapper<TData>*>(it))->Data) = data;
               return;
            }
         }

         DataWrapper<TData>* newWrapper = FEATSTD_NEW(DataWrapper<TData>)(_first);
         if (newWrapper != NULL)
         {
            newWrapper->Data = data;
            _first = newWrapper;
         }
      }

      template<typename TData>
      bool has()
      {
         DataTypeId typeId = DataWrapper<TData>::getDataTypeId();
         for (DataWrapperBase* it = _first; it != NULL; it = it->getNext())
         {
            if (it->isType(typeId))
            {
               return true;
            }
         }

         return false;
      }

      template<typename TData>
      TData* get()
      {
         DataTypeId typeId = DataWrapper<TData>::getDataTypeId();
         for (DataWrapperBase* it = _first; it != NULL; it = it->getNext())
         {
            if (it->isType(typeId))
            {
               return &((static_cast<DataWrapper<TData>*>(it))->Data);
            }
         }

         return NULL;
      }

      template<typename TData>
      TData* getOrCreate()
      {
         TData* data = get<TData>();

         if (data == NULL)
         {
            DataWrapper<TData>* newWrapper = FEATSTD_NEW(DataWrapper<TData>)(_first);
            if (newWrapper != NULL)
            {
               data = &(newWrapper->Data);
               _first = newWrapper;
            }
         }

         return data;
      }

   private:
      DataSet(const DataSet&);
      DataSet& operator=(const DataSet&);

      typedef const char* DataTypeId;

      class DataWrapperBase
      {
         public:
            DataWrapperBase(DataWrapperBase* next) : _next(next) {}

            virtual ~DataWrapperBase()
            {
               if (_next != NULL)
               {
                  FEATSTD_DELETE(_next);
                  _next = NULL;
               }
            }

            DataWrapperBase* getNext() const
            {
               return _next;
            }

            virtual bool isType(DataTypeId id) const = 0;

         private:
            DataWrapperBase* _next;
      };

      template<typename TData>
      class DataWrapper : public DataWrapperBase
      {
         public:
            DataWrapper(DataWrapperBase* next) : DataWrapperBase(next) {}
            TData Data;

            virtual bool isType(DataTypeId id) const
            {
               return id == getDataTypeId();
            }

            static DataTypeId getDataTypeId()
            {
               static char c = '\0';
               return &c;
            }
      };

      DataWrapperBase* _first;
};


}//namespace util
}//namespace hmibase


#endif
