/* ***************************************************************************************
* FILE:          Source.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Source.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"
#include "AppHmi_MasterBase/AudioInterface/Source.h"

namespace hmibase {
namespace apphmi_master {
namespace audio {

SrcMap* SrcMap::m_pSrcMap = NULL;

Source::Source(std::string sName): Resource(sName), m_AvaialabilityReason(0)
{
   SrcMap* pSrcMap = SrcMap::getSrcMapInstance();
   size_t nSeparator = sName.rfind("#");
   m_DeviceId = -1;
   if (nSeparator != std::string::npos)
   {
      std::string sDevId = sName.substr(nSeparator + 1);
      sName = sName.substr(0, nSeparator);
      m_DeviceId = atoi(sDevId.c_str());
   }
   m_Index = pSrcMap->getSourceId(sName);
   m_ConnResponseState = pSrcMap->getResponseState(m_Index);
   m_Type = pSrcMap->getSourceType(m_Index);
}


Source::~Source()
{
}


SrcMap* SrcMap::getSrcMapInstance()
{
   if (m_pSrcMap == NULL)
   {
      m_pSrcMap = new SrcMap();
   }
   return m_pSrcMap;
}


}
}


}
