/* ***************************************************************************************
* FILE:          SoundPropertiesSenderClient.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SoundPropertiesSenderClient.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef SoundPropertiesSenderClient_h
#define SoundPropertiesSenderClient_h

#include "org/genivi/audiomanager/CommandInterfaceProxy.h"
#include "AppBase/StartupSync/StartupSync.h"
namespace hmibase {
namespace apphmi_master {
namespace audio {

class SoundPropertiesSenderClient :
   public asf::core::ServiceAvailableIF,
   public StartupSync::PropertyRegistrationIF,
   public org::genivi::audiomanager::CommandInterface::SetSystemPropertyCallbackIF,
   public org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyCallbackIF,
   public org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyCallbackIF,
   public org::genivi::audiomanager::CommandInterface::SetVolumeCallbackIF,
   public org::genivi::audiomanager::CommandInterface::SetSinkMuteStateCallbackIF,
   public org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesCallbackIF,
   public org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesCallbackIF
{
   public:
      SoundPropertiesSenderClient();
      virtual ~SoundPropertiesSenderClient();

      // initialize after constructor
      void initialize();

      // asf::core::ServiceAvailableIF
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // StartupSync::PropertyRegisterIF
      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // SetSystemPropertyCallbackIF
      virtual void onSetSystemPropertyError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SetSystemPropertyError >& error);
      virtual void onSetSystemPropertyResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SetSystemPropertyResponse >& reply);

      // SetMainSourceSoundPropertyCallbackIF
      virtual void onSetMainSourceSoundPropertyError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyError >& error);
      virtual void onSetMainSourceSoundPropertyResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyResponse >& reply);

      // SetMainSinkSoundPropertyCallbackIF
      virtual void onSetMainSinkSoundPropertyError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyError >& error);
      virtual void onSetMainSinkSoundPropertyResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyResponse >& reply);

      // SetVolumeCallbackIF
      virtual void onSetVolumeError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SetVolumeError >& error);
      virtual void onSetVolumeResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SetVolumeResponse >& reply);

      // SetSinkMuteStateCallbackIF
      virtual void onSetSinkMuteStateError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SetSinkMuteStateError >& error);
      virtual void onSetSinkMuteStateResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SetSinkMuteStateResponse >& reply);

      // GetListSystemPropertiesCallbackIF
      virtual void onGetListSystemPropertiesError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesError >& error);
      virtual void onGetListSystemPropertiesResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponse >& reply);

      //GetListMainSinkSoundPropertiesCallbackIF
      virtual void onGetListMainSinkSoundPropertiesError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesError >& error);
      virtual void onGetListMainSinkSoundPropertiesResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponse >& reply);

      void sendSetVolumeRequest(uint16 sinkID, uint16 mode, int16 value);
      void sendSetSinkMuteStateRequest(uint16 sinkID, uint16 muteState);
      void sendSetSystemMuteRequest(uint16 sinkID, bool value);
      void sendSetMainSinkSoundProperty(uint16 sinkID, uint16 SoundProperty, uint16 value);
      void sendSetSystemProperty(uint16 propertyType, int16 value);
      void sendgetListMainSinkSoundProperty(uint16 sinkID);
      void sendgetListSystemProperty();

   private:
      ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy > _commandIFProxy;
      std::map<int, int> _actMap;
};


} //namespace audio
} //namespace apphmi_master
} //namespace hmibase
#endif //SoundPropertiesSenderClient_h
