/* ***************************************************************************************
* FILE:          SoundPropertiesReceiverClient.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SoundPropertiesReceiverClient.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef SoundPropertiesReceiverClient_h
#define SoundPropertiesReceiverClient_h

#include "org/genivi/audiomanager/CommandInterfaceProxy.h"
#include "AppBase/StartupSync/StartupSync.h"

namespace hmibase {
namespace apphmi_master {
namespace audio {

class SoundPropertiesReceiverClient :
   public asf::core::ServiceAvailableIF,
   public StartupSync::PropertyRegistrationIF,
   public org::genivi::audiomanager::CommandInterface::SystemPropertyChangedCallbackIF,
   public org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesCallbackIF,
   public org::genivi::audiomanager::CommandInterface::MainSourceSoundPropertyChangedCallbackIF,
   public org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedCallbackIF,
   public org::genivi::audiomanager::CommandInterface::VolumeChangedCallbackIF,
   public org::genivi::audiomanager::CommandInterface::SinkMuteStateChangedCallbackIF
{
   public:
      SoundPropertiesReceiverClient();
      virtual ~SoundPropertiesReceiverClient();

      // initialize after constructor
      void initialize();

      // asf::core::ServiceAvailableIF
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // StartupSync::PropertyRegistrationIF
      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // SystemPropertyChangedCallbackIF
      virtual void onSystemPropertyChangedSignal(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SystemPropertyChangedSignal >& signal);
      virtual void onSystemPropertyChangedError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SystemPropertyChangedError >& error);

      // GetListMainSourceSoundPropertiesCallbackIF
      virtual void onGetListMainSourceSoundPropertiesError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesError >& error);
      virtual void onGetListMainSourceSoundPropertiesResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponse >& reply);

      // MainSourceSoundPropertyChangedCallbackIF
      virtual void onMainSourceSoundPropertyChangedSignal(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::MainSourceSoundPropertyChangedSignal >& signal);
      virtual void onMainSourceSoundPropertyChangedError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::MainSourceSoundPropertyChangedError >& error);

      // MainSinkSoundPropertyChangedCallbackIF
      virtual void onMainSinkSoundPropertyChangedSignal(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedSignal >& signal);
      virtual void onMainSinkSoundPropertyChangedError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedError >& error);

      // VolumeChangedCallbackIF
      virtual void onVolumeChangedSignal(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::VolumeChangedSignal >& signal);
      virtual void onVolumeChangedError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::VolumeChangedError >& error);

      // SinkMuteStateChangedCallbackIF
      virtual void onSinkMuteStateChangedSignal(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SinkMuteStateChangedSignal >& signal);
      virtual void onSinkMuteStateChangedError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::SinkMuteStateChangedError >& error);

   private:
      ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy > _commandIFProxy;
      act_t _commandIFProxy_SystemPropertyChanged_RegId;
      act_t _commandIFProxy_MainSourceSoundPropertyChanged_RegId;
      act_t _commandIFProxy_MainSinkSoundPropertyChanged_RegId;
      act_t _commandIFProxy_VolumeChanged_RegId;
      act_t _commandIFProxy_SinkMuteStateChanged_RegId;
};


} //namespace audio
} //namespace apphmi_master
} //namespace hmibase
#endif //SoundPropertiesReceiverClient_h
