/* ***************************************************************************************
* FILE:          Resource.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Resource.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef Resource_h
#define Resource_h

#include <string>

namespace hmibase {
namespace apphmi_master {
namespace audio {

class Resource
{
   public:
      Resource(std::string sName) : m_ID(-1), m_Name(sName), m_Availability(false), m_ClassID(-1)
      {
      }
      ~Resource()
      {
         m_Name.clear();
      }

      inline void SetID(int nID)
      {
         m_ID = nID;
      }
      inline int GetID() const
      {
         return m_ID;
      }
      inline std::string GetName()
      {
         return m_Name;
      }

      inline void SetAvailability(int nAvailability)
      {
         m_Availability = nAvailability;
      }
      inline int GetAvailability() const
      {
         return m_Availability;
      }

      inline void SetClassID(int nClassID)
      {
         m_ClassID = nClassID;
      }
      inline int GetClassID() const
      {
         return m_ClassID;
      }

      inline bool operator==(const Resource& resource) const
      {
         return (resource.GetID() == GetID());
      }

      inline bool operator!=(const Resource& resource) const
      {
         return !(*this == resource);
      }

   private:
      int m_ID;
      std::string m_Name;
      int m_Availability;
      int m_ClassID;
};


}
}


}
#endif //Resource_h
