/* ***************************************************************************************
* FILE:          HmiSoundProperties.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HmiSoundProperties.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

//#include "hall_std_if.h"

#include "AppHmi_MasterBase/AudioInterface/SoundController.h"
#include "AppHmi_MasterBase/AudioInterface/HmiSoundProperties.h"
#include "AppHmi_MasterBase/AudioInterface/AudioControllerObjectManager.h"
#include "AppHmi_MasterBase/AudioInterface/Source.h"
#include "AppHmi_MasterBase/AudioInterface/Sink.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_AUDIO_IF
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/HmiSoundProperties.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties;
using namespace ::hmibase::apphmi_master::audio;

namespace hmibase {
namespace services {
namespace audio {

HmiSoundProperties* HmiSoundProperties::_hmiSoundProperties = NULL;

HmiSoundProperties::HmiSoundProperties()
   : SoundPropertiesStub("soundPropertiesPort")
{
   _hmiSoundProperties = this;
}


HmiSoundProperties::~HmiSoundProperties()
{
}


void HmiSoundProperties::initialize()
{
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->RegisterHmiSoundProperties(this);
}


HmiSoundProperties* HmiSoundProperties::getInstance()
{
   return _hmiSoundProperties ;
}


void HmiSoundProperties::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/)
{
}


void HmiSoundProperties::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/)
{
}


// for UserMute State Update
void HmiSoundProperties::onSetMuteStateRequest(const ::boost::shared_ptr< SetMuteStateRequest >& request)
{
   bool muteState = request->getMuteState();
   uint16_t sinkId = request->getSinkId();
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->requestUserMuteState(muteState, sinkId);
   sendSetMuteStateResponse(request->getAct());
}


void HmiSoundProperties::onSetMainSinkSoundPropertyRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetMainSinkSoundPropertyRequest >& request)
{
   uint16_t nSinkId = request->getSinkId();
   uint16_t nPropertyType = request->getPropertyType();
   int nValue = request->getValue();
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->requestMainSinkSoundProperty(nSinkId, nPropertyType, nValue);
   sendSetMainSinkSoundPropertyResponse(request->getAct());
}


void HmiSoundProperties::onSetSystemPropertyRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetSystemPropertyRequest >& request)
{
   uint16_t nPropertyType = request->getPropertyType();
   int nValue = request->getValue();
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->requestSystemProperty(nPropertyType, nValue);
   sendSetSystemPropertyResponse(request->getAct());
}


void HmiSoundProperties::onRequestMainSinkSoundPropertyListRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::SoundProperties::RequestMainSinkSoundPropertyListRequest >& request)
{
   uint16_t nSinkId = request->getSinkId();
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->requestMainSinkSoundPropertiesList(nSinkId);
}


void HmiSoundProperties::onRequestSystemPropertyListRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::SoundProperties::RequestSystemPropertyListRequest >& /*request*/)
{
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->requestSystemPropertiesList();
}


void HmiSoundProperties::sendMainSinkSoundPropertyUpdate(int32 propertyType, int32 value, uint16 sinkId)
{
   SoundPropertiesStub::sendMainSinkSoundPropertyChangedSignal(propertyType, value, sinkId);
}


void HmiSoundProperties::sendSystemPropertyUpdate(int32 propertyType, int32 value)
{
   SoundPropertiesStub::sendSystemPropertyChangedSignal(propertyType, value);
}


void HmiSoundProperties::updateSystemPropertyList(::std::vector< bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemProperty > systemproperty)
{
   SoundPropertiesStub::setSystemPropertyList(systemproperty);
}


void HmiSoundProperties:: updateMainSinkSoundPropertyList(::std::vector<bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundProperty > soundproperty, int nSinkId)
{
   SoundPropertyData PropertyList(soundproperty, nSinkId);
   SoundPropertiesStub::setSoundPropertyList(PropertyList);
}


//for AudioOff ste Update
void HmiSoundProperties::onSetAudioStateRequest(const ::boost::shared_ptr< SetAudioStateRequest >& request)
{
   bool audioOffState = request->getAudioState();
   uint16_t sinkId = request->getSinkId();
   AudioControllerObjectManager::getInstance().getSoundController<SoundController>()->requestAudioOffMuteState(audioOffState, sinkId);
   sendSetAudioStateResponse(request->getAct());
}


void HmiSoundProperties::updateVolumeValue(int nVolume, uint16_t nSinkId)
{
   if (nVolume >= 0)
   {
      ::std::map<uint16_t, uint8_t> volumeData = SoundPropertiesStub::getVolumeMapMutable();
      ::std::map<uint16_t, uint8_t>::iterator it = volumeData.find(nSinkId);

      if (it != volumeData.end())
      {
         it->second = static_cast<uint8_t>(nVolume);
      }
      else
      {
         volumeData[nSinkId] = static_cast<uint8_t>(nVolume);
      }

      if (nSinkId == DEFAULT_MAIN_SINK_ID)
      {
         SoundPropertiesStub::setVolume(nVolume);
      }

      SoundPropertiesStub::setVolumeMap(volumeData);
   }
}


// updates User Mute State
void HmiSoundProperties::updateMuteState(bool bMuteState, uint16_t nSinkId)
{
   ::std::map<uint16_t, bool> muteStateData = SoundPropertiesStub::getMuteStateMapMutable();
   ::std::map<uint16_t, bool>::iterator it = muteStateData.find(nSinkId);

   if (it != muteStateData.end())
   {
      it->second = bMuteState;
   }
   else
   {
      muteStateData[nSinkId] = bMuteState;
   }

   if (nSinkId == DEFAULT_MAIN_SINK_ID)
   {
      SoundPropertiesStub::setMuteState(bMuteState);
   }

   SoundPropertiesStub::setMuteStateMap(muteStateData);
}


void HmiSoundProperties::updateAudioState(bool bUserMuteStatus, bool bAudioOffMuteStatus, uint16_t nSinkId)
{
   ::std::map<uint16_t, AudioStateInfo> audioOffStateData = SoundPropertiesStub::getAudioStateInfoMapMutable();
   ::std::map<uint16_t, AudioStateInfo>::iterator it = audioOffStateData.find(nSinkId);

   if (it != audioOffStateData.end())
   {
      it->second.setMuteState(bUserMuteStatus);
      it->second.setAudioOnOffState(bAudioOffMuteStatus);
   }
   else
   {
      AudioStateInfo data(bUserMuteStatus, bAudioOffMuteStatus);
      audioOffStateData[nSinkId] = data;
   }

   if (nSinkId == DEFAULT_MAIN_SINK_ID)
   {
      AudioStateInfo data(bUserMuteStatus, bAudioOffMuteStatus);
      SoundPropertiesStub::setAudioStateInfo(data);
   }

   SoundPropertiesStub::setAudioStateInfoMap(audioOffStateData);
}


}
}


}
