/* ***************************************************************************************
* FILE:          AudioControllerObjectManager.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AudioControllerObjectManager.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"
#include "AudioControllerObjectManager.h"

namespace hmibase {
namespace apphmi_master {
namespace audio {

AudioControllerObjectManager* AudioControllerObjectManager::_theInstance = 0;

bool AudioControllerObjectManager::initialize(boost::shared_ptr<ConnectionController> connectionController,
      boost::shared_ptr<SoundController> soundController,
      boost::shared_ptr<ResourceController> resourceController)
{
   bool ret = false;
   if (_theInstance == 0)
   {
      _theInstance = new AudioControllerObjectManager(/*cmdIfProxy, mediatorServiceProxy,*/ connectionController, soundController, resourceController);
      ret = true;
   }
   return ret;
}


AudioControllerObjectManager::AudioControllerObjectManager(boost::shared_ptr<ConnectionController> connectionController,
      boost::shared_ptr<SoundController> soundController,
      boost::shared_ptr<ResourceController> resourceController) :
   _connectionController(connectionController),
   _soundController(soundController),
   _resourceController(resourceController)
{
}


}
}


}
