/* ***************************************************************************************
* FILE:          AppHmi_MasterHallBase.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AppHmi_MasterHallBase.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "AppHmi_MasterHallBase.h"

#include "RootDaemonClient/RootDaemon.h"

namespace hmibase {
namespace app {
namespace master {


AppHmi_MasterHallBase::AppHmi_MasterHallBase(): HallComponentBase("", "App.Core.AppHmi_Master", "/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_Master")
{
}


AppHmi_MasterHallBase::AppHmi_MasterHallBase(const std::string& objname): HallComponentBase("", "App.Core.AppHmi_Master", objname)
{
}


AppHmi_MasterHallBase::~AppHmi_MasterHallBase()
{
}


void AppHmi_MasterHallBase::initializeAudioComponents(boost::shared_ptr<hmibase::apphmi_master::audio::ConnectionController> connCtrl,
      boost::shared_ptr<hmibase::apphmi_master::audio::SoundController> soundCtrl,
      boost::shared_ptr<hmibase::apphmi_master::audio::ResourceController> resourceCtrl)
{
   // ::bosch::cm::ai::hmi::masteraudioservice
   _audioClientHandler.initialize(connCtrl, soundCtrl, resourceCtrl);
   // ::org::genivi::audiomanager::CommandInterface
   _masterAudioClient.initialize();
   _hmiSoundProperties.initialize();
}


void AppHmi_MasterHallBase::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   HallComponentBase::onAvailable(proxy, stateChange);
}


void AppHmi_MasterHallBase::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   HallComponentBase::onUnavailable(proxy, stateChange);
}


void AppHmi_MasterHallBase::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/)
{
}


void AppHmi_MasterHallBase::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/)
{
}


}
}


}
