/* ***************************************************************************************
* FILE:          SystemConfiguration.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SystemConfiguration.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_APP_BASE_SYSTEMCONFIGURATION_H
#define HMIBASE_APP_BASE_SYSTEMCONFIGURATION_H

#include <string>

namespace hmibase {
namespace app {
namespace base {
class SystemConfiguration
{
   public:
      static std::string getAssetFileName();
      static std::string getDefaultAssetFileName();
   public:
      static bool s_initialize();
      static void s_destroy();
      static SystemConfiguration& s_getInstance();

   private:
      static SystemConfiguration* _theInstance;

      SystemConfiguration();
      SystemConfiguration(const SystemConfiguration&);
};


}
}


}
#endif // HMIBASE_APP_BASE_SYSTEMCONFIGURATION_H
