/* ***************************************************************************************
* FILE:          SystemConfiguration.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SystemConfiguration.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"
#include "SystemConfiguration.h"

#include "AppBase/HmiAsfComponentBase.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_CGI
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SystemConfiguration.cpp.trc.h"
#endif

namespace hmibase {
namespace app {
namespace base {

SystemConfiguration* SystemConfiguration::_theInstance = 0;


void getWorkingDir(std::string& cwd)
{
   char cCurrentPath[FILENAME_MAX];
   memset(cCurrentPath, 0, FILENAME_MAX);

   if (getcwd(cCurrentPath, sizeof(cCurrentPath) - 1))
   {
      cwd = cCurrentPath;
   }
}


bool SystemConfiguration::s_initialize()
{
   if (_theInstance == 0)
   {
      _theInstance = new SystemConfiguration();
      return true;
   }

   HMI_APP_ASSERT_ALWAYS();
   return false;
}


void SystemConfiguration::s_destroy()
{
   if (_theInstance)
   {
      delete _theInstance;
      _theInstance = 0;
   }
}


SystemConfiguration& SystemConfiguration::s_getInstance()
{
   HMI_APP_ASSERT(_theInstance != 0);
   return *_theInstance;
}


SystemConfiguration::SystemConfiguration()
{
}


std::string SystemConfiguration::getAssetFileName()
{
   char* path = getenv("ASSET_BIN");
   return (path != 0) ? path : getDefaultAssetFileName();
}


std::string SystemConfiguration::getDefaultAssetFileName()
{
   std::stringstream assetFileName;
   std::string s;

   getWorkingDir(s);

   assetFileName << s;
   assetFileName << "/";
   assetFileName << HmiAsfComponentBase::getAppName();
   assetFileName << "_Asset.bin";

   ETG_TRACE_USR1_THR(("default asset file name: %s", assetFileName.str().c_str()));
   return assetFileName.str();
}


}
}


}
