/* ***************************************************************************************
* FILE:          AsfThreadStartupSync.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AsfThreadStartupSync.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __AsfThreadStartupSync_H_
#define __AsfThreadStartupSync_H_

#include "hmibase/util/Condition.h"
#include "hmibase/util/Semaphore.h"

namespace hmibase {
namespace util {

class AsfThreadStartupSync
{
      Condition _cond;
      EventRef  _evReceiverView;
      EventRef  _evReceiverHall;
      bool _viewReceiverReady;
      bool _hallReceiverReady;
      void waitForEvent();
   public:
      AsfThreadStartupSync();
      ~ AsfThreadStartupSync();
      void waitUntilHallReady();
      void waitUntilGuiReady();
      void hallReady();
      void guiReady();
};


} // namespace util
} // namespace hmibase

extern ::hmibase::util::AsfThreadStartupSync _gStartupSync;

#endif // guard
