/* ***************************************************************************************
* FILE:          AsfThreadStartupSync.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Semaphore.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"
#include "AsfThreadStartupSync.h"
#include "hmibase/util/TimerThreaded.h"

namespace hmibase {
namespace util {


AsfThreadStartupSync::AsfThreadStartupSync()
{
   _evReceiverHall = _cond.addEvent();
   _evReceiverView = _cond.addEvent();
   _viewReceiverReady = false;
   _hallReceiverReady = false;
   hmibase::util::TimerThreaded::createTimerThread();
}


AsfThreadStartupSync::~AsfThreadStartupSync()
{
}


void AsfThreadStartupSync::waitUntilGuiReady()
{
   while (_viewReceiverReady == false)
   {
      waitForEvent();
   }
}


void AsfThreadStartupSync::waitUntilHallReady()
{
   while (_hallReceiverReady == false)
   {
      waitForEvent();
   }
}


void AsfThreadStartupSync::guiReady()
{
   _cond.signal(_evReceiverView);
}


void AsfThreadStartupSync::hallReady()
{
   _cond.signal(_evReceiverHall);
}


void AsfThreadStartupSync::waitForEvent()
{
   hmibase::util::EventRef ev = _cond.wait(0xFFFFFFFF);
   if (ev == _evReceiverHall)
   {
      _hallReceiverReady = true;
   }
   if (ev == _evReceiverView)
   {
      _viewReceiverReady = true;
   }
}


} // namespace util
} // namespace hmibase
