/* ***************************************************************************************
* FILE:          ServiceAvailableIF.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ServiceAvailableIF.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_SERVICE_AVAILABLE_IF_H
#define HMIBASE_SERVICE_AVAILABLE_IF_H

#include "asf/core/Proxy.h"
#include "AppBase/StartupSync/StartupSync.h"

#include "AppUtils/HmiMacros.h"

namespace hmibase {
namespace app {
namespace base {
class ServiceAvailableIF : public asf::core::ServiceAvailableIF
{
   public:
      // ServiceAvailableIF implementation
      virtual void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange)
      {
         StartupSync::getInstance().onAvailable(proxy, stateChange);
      }

      virtual void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange)
      {
         StartupSync::getInstance().onUnavailable(proxy, stateChange);
      }
};


}
}


HMIBASE_DEPRECATED_TYPE_ALIAS(ServiceAvailableIF, ::hmibase::app::base::ServiceAvailableIF)
}


#endif // HMIBASE_SERVICE_AVAILABLE_IF_H
