/* ***************************************************************************************
* FILE:          KeyMappingBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  KeyMappingBase.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef KEYMAPPINGBASE_H
#define KEYMAPPINGBASE_H

#include "BaseContract/generated/BaseTypes.h"
#include "AppUtils/HmiMacros.h"

namespace hmibase {
namespace app {
namespace base {
namespace keymapbase {

static const uint32_t KEY_CODE_INVALID = 0xFFFF;
static const uint32_t ENCODER_CODE_INVALID = 0xFFFF;
} // end of namespace keymapbase
} // end of namespace base
} // end of namespace app

namespace appbase {
namespace keymapbase {
HMIBASE_DEPRECATED_CONST_ALIAS(KEY_CODE_INVALID, ::hmibase::app::base::keymapbase::KEY_CODE_INVALID, uint32_t)
HMIBASE_DEPRECATED_CONST_ALIAS(ENCODER_CODE_INVALID, ::hmibase::app::base::keymapbase::ENCODER_CODE_INVALID, uint32_t)
}


}
} // end of namespace hmibase

class KeyMappingBase
{
   public:

      struct HkTimers
      {
         unsigned int long1;
         unsigned int long2;
         unsigned int long3;
         unsigned int long4;
         unsigned int long5;
         unsigned int long6;
         unsigned int long7;
         unsigned int long8;
         unsigned int long9;
         unsigned int long10;
      };

      HkTimers Timers;

      ///
      KeyMappingBase()
      {
         memset(&Timers, 0, sizeof(Timers));
      }

      ///
      virtual ~KeyMappingBase() {}

      ///
      virtual uint32_t GetHmiKeyCode(uint32_t key, uint32_t userData) const
      {
         (void)key;
         (void)userData;

         return hmibase::app::base::keymapbase::KEY_CODE_INVALID;
      }

      ///
      virtual uint32_t GetOrigKeyCode(uint32_t key, uint32_t userData) const
      {
         (void)key;
         (void)userData;

         return 0;
      }

      ///
      virtual uint32_t GetHmiEncoderCode(uint32_t encoder, uint32_t userData) const
      {
         (void)encoder;
         (void)userData;

         return hmibase::app::base::keymapbase::ENCODER_CODE_INVALID;
      }

      ///
      virtual uint32_t GetOrigEncoderCode(uint32_t encoder, uint32_t userData) const
      {
         (void)encoder;
         (void)userData;

         return 0;
      }

      //Function which returns structure of existing timers
      virtual HkTimers GetTimerValuesForKey(uint32_t key, uint32_t userData) const
      {
         (void)key;
         (void)userData;

         return Timers;
      }

      //Function which returns value for repeat time for a key
      virtual unsigned int GetRepeatTimeoutForKey(uint32_t key, uint32_t userData) const
      {
         (void)key;
         (void)userData;

         return 0;
      }

      virtual bool IsAbortKey(uint32_t key, uint32_t userData) const
      {
         (void)key;
         (void)userData;

         return false;
      }
};


extern KeyMappingBase& getKeyMapping();


#endif
