/* ***************************************************************************************
* FILE:          IUserInputObserver.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IUserInputObserver.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef IUSERINPUTOBSERVER_H
#define IUSERINPUTOBSERVER_H

#include <stdint.h>
#include "hmibase/util/Macros.h"
namespace hmibase {
namespace input {
class IUserInputObserver
{
   public:
      virtual ~IUserInputObserver() {};

      /// any kind of input event
      virtual void onInputEvent() = 0;

      /// detailed touch information
      virtual void onTouchEventDown(int x, int y, uint32_t surface, int32_t id, uint32_t timestamp);
      virtual void onTouchEventUp(int x, int y, uint32_t surface, int32_t id, uint32_t timestamp);
      virtual void onTouchEventMove(int x, int y, uint32_t surface, int32_t id, uint32_t timestamp);
};


}
}


HMIBASE_DEPRECATED_TYPE_ALIAS(IUserInputObserver, ::hmibase::input::IUserInputObserver)

#endif // IUSERINPUTOBSERVER_H
