/* ***************************************************************************************
* FILE:          IAppViewSettings.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IAppViewSettings.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(IAppViewSettings_h)
#define IAppViewSettings_h

#include <ScreenBroker/ScreenBroker.h>
#include <ScreenBroker/PopupPresentationArg.h>

#include "View/ViewIdentifier.h"
#include "BaseContract/generated/BaseTypes.h"

class IAppViewSettings
{
   public:
      ///
      virtual ~IAppViewSettings() {}

      virtual const ScreenBroker::PopupPresentationArg GetPopupPresentationArg(const ::hmibase::view::ViewIdentifier& viewId, uint32_t displayID = ::hmibase::DEFAULT_UNKNOWN_DISPLAY) const;
      virtual ScreenBroker::UInt32 GetShowSurfaceRequestId(const ::hmibase::view::ViewIdentifier& viewId, uint32_t displayID = ::hmibase::DEFAULT_UNKNOWN_DISPLAY) const;
      virtual ScreenBroker::UInt32 GetHideSurfaceRequestId(const ::hmibase::view::ViewIdentifier& viewId, uint32_t displayID = ::hmibase::DEFAULT_UNKNOWN_DISPLAY) const;
      virtual ScreenBroker::UInt32 GetShowPopupRequestId(const ::hmibase::view::ViewIdentifier& viewId, uint32_t displayID = ::hmibase::DEFAULT_UNKNOWN_DISPLAY) const;
      virtual ScreenBroker::UInt32 GetHidePopupRequestId(const ::hmibase::view::ViewIdentifier& viewId, uint32_t displayID = ::hmibase::DEFAULT_UNKNOWN_DISPLAY)  const;
      virtual ScreenBroker::UInt32 GetPopupSurfaceId(const ::hmibase::view::ViewIdentifier& viewId, uint32_t displayID = ::hmibase::DEFAULT_UNKNOWN_DISPLAY)  const;

   protected:
      ///
      IAppViewSettings() {}
};


#endif
