/* ***************************************************************************************
* FILE:          IAppViewSettings.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IAppViewSettings.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"

#include "IAppViewSettings.h"
#include "ScreenBrokerSettings/Settings.h"

#ifndef VARIANT_S_FTR_ENABLE_QT_APPLICATION
#include "View/CGI/CgiExtensions/PopupConfig.h"
#else
#include "View/Qt/QtExtensions/PopupConfig.h"
#endif

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW_SBCLIENT
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/IAppViewSettings.cpp.trc.h"
#endif

// ------------------------------------------------------------------------
const ScreenBroker::PopupPresentationArg IAppViewSettings::GetPopupPresentationArg(const ::hmibase::view::ViewIdentifier& viewId, uint32_t displayID) const
{
   // fetch popup argument from popup configuration
   ::hmibase::view::ST_POPUP_CONFIG* PopupConfigLoc = ::hmibase::view::PopUpConfig::FindPopupConfig(viewId, displayID);

   if (PopupConfigLoc != NULL)
   {
      ETG_TRACE_USR4_THR(("AppViewSettings::GetPopupPresentationArg viewId: %s", viewId.CStr()));
#ifdef VARIANT_S_FTR_ENABLED_SCREENBROKER_ALIGNMENT
      ETG_TRACE_USR4_THR(("AppViewSettings::GetPopupPresentationArg popupPresentationArgs: prio: %d, modality: %d, presentTime: %d, minPresentTime: %d, validityPeriod: %d, hAlign: %d, vAlign: %d, scaling: %d ",
                          PopupConfigLoc->priority, PopupConfigLoc->enModality, PopupConfigLoc->presTime, PopupConfigLoc->minPresTime,
                          PopupConfigLoc->validityPeriod, PopupConfigLoc->enHorizontalAlignment, PopupConfigLoc->enVerticalAlignment, ScreenBroker::Scaling::None));
#else
      ETG_TRACE_USR4_THR(("AppViewSettings::GetPopupPresentationArg popupPresentationArgs: prio: %d, modality: %d, presentTime: %d, minPresentTime: %d, validityPeriod: %d, hAlign: %d, vAlign: %d, scaling: %d ",
                          PopupConfigLoc->priority, PopupConfigLoc->enModality, PopupConfigLoc->presTime, PopupConfigLoc->minPresTime,
                          PopupConfigLoc->validityPeriod, ScreenBroker::HorizontalAlignment::Center, ScreenBroker::VerticalAlignment::Center, ScreenBroker::Scaling::None));
#endif

      // create popup presentation argument
      ScreenBroker::PopupPresentationArg \
      lPopupPresentationArg(PopupConfigLoc->priority,
                            PopupConfigLoc->enModality,
                            PopupConfigLoc->presTime,
                            PopupConfigLoc->minPresTime,
                            PopupConfigLoc->validityPeriod,
#ifdef VARIANT_S_FTR_ENABLED_SCREENBROKER_ALIGNMENT
                            PopupConfigLoc->enHorizontalAlignment,
                            PopupConfigLoc->enVerticalAlignment,
#else
                            ScreenBroker::HorizontalAlignment::Center,
                            ScreenBroker::VerticalAlignment::Center,
#endif
                            ScreenBroker::Scaling::None,
                            PopupConfigLoc->focuspriority);
      return lPopupPresentationArg;
   }
   else
   {
      ETG_TRACE_ERR_THR(("AppViewSettings::GetPopupPresentationArg No popup arguments found for viewId: %s! Empty default Args are returned. \n !", viewId.CStr()));
      return ScreenBroker::PopupPresentationArg();
   }
}


// ------------------------------------------------------------------------
ScreenBroker::UInt32 IAppViewSettings::GetShowSurfaceRequestId(const ::hmibase::view::ViewIdentifier& viewId, uint32_t displayId) const
{
   PARAM_UNUSED(viewId);
   PARAM_UNUSED(displayId);
   ScreenBrokerProtocol::RequestId<ScreenBrokerProtocol::ShowSurfaceMode::Enum> lRequestId;
   // can later be extended, once special information has to be added to the request ID
   // the setting that a surface has to be shown is done in SBClient
   return lRequestId.Get();
}


// ------------------------------------------------------------------------
ScreenBroker::UInt32 IAppViewSettings::GetHideSurfaceRequestId(const ::hmibase::view::ViewIdentifier& viewId, uint32_t displayId) const
{
   PARAM_UNUSED(viewId);
   PARAM_UNUSED(displayId);
   ScreenBrokerProtocol::RequestId<ScreenBrokerProtocol::HideSurfaceMode::Enum> lRequestId;
   // can later be extended, once special information has to be added to the request ID
   // the setting that a surface has to be hided is done in SBClient
   return lRequestId.Get();
}


// ------------------------------------------------------------------------
ScreenBroker::UInt32 IAppViewSettings::GetShowPopupRequestId(const ::hmibase::view::ViewIdentifier& viewId, uint32_t displayID) const
{
   ScreenBrokerProtocol::RequestId<ScreenBrokerProtocol::ShowPopupMode::Enum> lRequestId;

   // fetch popup argument from popup configuration
   ::hmibase::view::ST_POPUP_CONFIG* PopupConfigLoc = ::hmibase::view::PopUpConfig::FindPopupConfig(viewId, displayID);

   if (PopupConfigLoc != NULL)
   {
      if (PopupConfigLoc->closeOnSuperseded)
      {
         ETG_TRACE_USR4_THR(("AppViewSettings::GetShowPopupRequestId closeOnSuperseded=true for viewId: %s! \n", viewId.CStr()));
         lRequestId.Set(ScreenBrokerProtocol::ShowPopupMode::CloseOnSuperseded);
      }
      else
      {
         ETG_TRACE_USR4_THR(("AppViewSettings::GetShowPopupRequestId closeOnSuperseded=false for viewId: %s! \n", viewId.CStr()));
         lRequestId.Clear(ScreenBrokerProtocol::ShowPopupMode::CloseOnSuperseded);
      }

      if (PopupConfigLoc->closeOnAppLeave)
      {
         ETG_TRACE_USR4_THR(("AppViewSettings::GetShowPopupRequestId closeOnAppLeave=true for viewId: %s! \n", viewId.CStr()));
         lRequestId.Set(ScreenBrokerProtocol::ShowPopupMode::CloseOnAppLeave);
      }
      else
      {
         ETG_TRACE_USR4_THR(("AppViewSettings::GetShowPopupRequestId CloseOnAppLeave=false for viewId: %s! \n", viewId.CStr()));
         lRequestId.Clear(ScreenBrokerProtocol::ShowPopupMode::CloseOnAppLeave);
      }
      if (PopupConfigLoc->closeOnExternalTouch)
      {
         ETG_TRACE_USR4_THR(("AppViewSettings::GetShowPopupRequestId closeOnExternalTouch=true for viewId: %s! \n", viewId.CStr()));
         lRequestId.Set(ScreenBrokerProtocol::ShowPopupMode::CloseOnExternalTouch);
      }
      else
      {
         ETG_TRACE_USR4_THR(("AppViewSettings::GetShowPopupRequestId closeOnExternalTouch=false for viewId: %s! \n", viewId.CStr()));
         lRequestId.Clear(ScreenBrokerProtocol::ShowPopupMode::CloseOnExternalTouch);
      }
   }
   else
   {
      ETG_TRACE_ERR_THR(("AppViewSettings::GetShowPopupRequestId No popup arguments found for viewId: %s! Default request ID is returned. \n", viewId.CStr()));
   }

   return lRequestId.Get();
}


// ------------------------------------------------------------------------
ScreenBroker::UInt32 IAppViewSettings::GetHidePopupRequestId(const ::hmibase::view::ViewIdentifier& viewId, uint32_t displayId) const
{
   PARAM_UNUSED(viewId);
   PARAM_UNUSED(displayId);
   ScreenBrokerProtocol::RequestId<ScreenBrokerProtocol::HidePopupMode::Enum> lRequestId;
   // can later be extended, once special information has to be added to the request ID
   return lRequestId.Get();
}


// ------------------------------------------------------------------------
ScreenBroker::UInt32 IAppViewSettings::GetPopupSurfaceId(const ::hmibase::view::ViewIdentifier& viewId, uint32_t displayID)  const
{
   ScreenBroker::UInt32 surfaceID = 0;

   // fetch popup argument from popup configuration
   ::hmibase::view::ST_POPUP_CONFIG* PopupConfigLoc = ::hmibase::view::PopUpConfig::FindPopupConfig(viewId, displayID);

   if (PopupConfigLoc != NULL)
   {
      surfaceID = PopupConfigLoc->surfaceID;
      ETG_TRACE_USR4_THR(("AppViewSettings::GetPopupSurfaceId surfaceID = %d for viewId: %s! \n", surfaceID, viewId.CStr()));
   }

   return surfaceID;
}
