/* ***************************************************************************************
* FILE:          ILM_Accessor.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ILM_Accessor.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef HMIBASE_ILM_ACCESSOR_H
#define HMIBASE_ILM_ACCESSOR_H

#ifdef WIN32
#define VARIANT_S_FTR_ENABLE_ILM_MOCK
#endif

#if !defined VARIANT_S_FTR_ENABLE_ILM_MOCK

#include "ilm/ilm_types.h"
#endif
#include <vector>


namespace hmibase {

class ILM_Accessor
{
   public:
      static bool init(void* nativeHandle);
      static void deInit();

      static bool setSurfacePosition(unsigned int surfaceId, int posX, int posY);
      static void getSurfacePosition(unsigned int surfaceId, int& posX, int& posY);

      static bool setSynchronizedSurface(unsigned int* surfaces, unsigned int count);
      static bool removeSynchronizedSurface(unsigned int* surfaces, unsigned int count);

      static bool updateInputAcceptance(unsigned int surfaceId, unsigned int devices, bool acceptance);

      static bool getSurfaceProperties(unsigned int surfaceId, struct ilmSurfaceProperties* properties);

      static bool setSurfaceDestinationRectangle(unsigned int surfaceId, unsigned int x, unsigned int y, unsigned int w, unsigned int h);

      static bool takeSnapshot(const char* name);
      static bool takeSurfaceSnapshot(const char* name, unsigned int surface);

      static bool getScreenIDs(std::vector<unsigned int>& screenIds);
      static bool getSurfaceIds(std::vector<unsigned int>& surfaceIds);

      static bool lockUnlockScreen(bool lock, const char* connectorName = 0);
};


}  // namespace

#endif
