/* ***************************************************************************************
* FILE:          HallComponentBaseMessaging.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HallComponentBaseMessaging.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "HallComponentBaseMessaging.h"

#ifdef VARIANT_S_FTR_ENABLE_COURIERMESSAGING
#include "View/CGI/CgiExtensions/CourierMsgQueue2ASF.h"
#elif  VARIANT_S_FTR_ENABLE_QT_MESSAGING
#include <QtCore/QEventLoop>
#else
// no event loop
#endif

namespace hmibase {
namespace app {
namespace base {


void HallComponentBaseMessaging::processViewEvents()
{
#ifdef VARIANT_S_FTR_ENABLE_COURIERMESSAGING
   while (_ASFCourierMsgQueue.getSize() > 0)
   {
      Courier::MessageReferrer msgRef;
      if (_ASFCourierMsgQueue.fetch(msgRef))
      {
         Courier::Message* lMsg = msgRef.GetMessage();
         if (lMsg)
         {
            static_cast<void>(OnMessage(*lMsg));
         }
      }
   }
#elif  VARIANT_S_FTR_ENABLE_QT_MESSAGING
   QEventLoop eventLoop;
   eventLoop.QEventLoop::processEvents(QEventLoop::AllEvents);
#else
   //no event loop
#endif
}


#ifdef  VARIANT_S_FTR_ENABLE_QT_MESSAGING
bool HallComponentBaseMessaging::onContractMessage(const GuiStartupFinishedUpdMsg& /*msg*/)
{
   return onStatemachineStartupFinished();
}


bool HallComponentBaseMessaging::onContractMessage(const ChangeHmiSubStateReqMsg& /*msg*/)
{
   return onChangeHmiSubStateReq();
}


#endif
} // namespace base
} // namespace app
} // namespace hmibase
