/* ***************************************************************************************
* FILE:          HallComponentBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HallComponentBase.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HALLCOMPONENTBASE_H
#define HALLCOMPONENTBASE_H

#include "asf/core/BaseComponent.h"
#include "asf/core/Proxy.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/LcmClient/LcmHandler.h"
//#include "View/IMessageSystem.h"
#include "AppBase/StartupSync/StartupSync.h"
#include "AppBase/ServiceAvailableIF.h"
#include "AppBase/HmiAsfComponentBase.h"
//#include "AppUtils/HmiMacros.h"
#include "HallComponentBaseMessaging.h"

namespace hmibase {
namespace app {
namespace base {

class HallComponentBase : public HallComponentBaseMessaging
   , public HmiAsfComponentBase
   , public asf::core::BaseComponent
   , public CourierTunnelService::CourierMessageReceiver::CourierMessageReceiverStub
   , public hmibase::app::base::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public hmibase::app::base::lcm::LcmHandlerCallback
{
   private:
      HallComponentBase();
   public:
      explicit HallComponentBase(const char* appName, const std::string& busname, const std::string& objname);
      ~HallComponentBase();

      // tunnelservice GUI<>HALL
      virtual void onReceiveCourierMessageRequest(const ::boost::shared_ptr< CourierTunnelService::CourierMessageReceiver::ReceiveCourierMessageRequest >& request);

      // StartupSync::PropertyRegistrationIF
      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // to be overwritten by HALL implementation
      // hmibase::app::base::lcm::LcmHandlerCallback
      virtual void onLoadPersistency();
      virtual void onSavePersistency();
      virtual void onAppSubStateReady(hmibase::HMIStateEnum val);
      virtual bool OnAppModeChange(hmibase::app::base::lcm::ShutdownType newState, hmibase::app::base::lcm::ShutdownType oldState);

      void SendLifeCycleRequestCompleteRequest();
      void hallComponentReady();

   protected:
      virtual bool onGuiStartupFinished();
      virtual bool onStatemachineStartupFinished();
      virtual bool onChangeHmiSubStateReq();

   private:
      ::hmibase::app::base::lcm::LcmHandler  _lcmHandler;
};


} // namspace
} // namspace
} // namspace


HMIBASE_DEPRECATED_TYPE_ALIAS(HallComponentBase, ::hmibase::app::base::HallComponentBase)

#endif // HALLCOMPONENTBASE_H
