/* ***************************************************************************************
* FILE:          GuiComponentMessageHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GuiComponentMessageHandler.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _GuiComponentMessageHandler_H_
#define _GuiComponentMessageHandler_H_

#include "View/IMessageSystem.h"
#include "Courier/Foundation/ModelComponent.h"

namespace hmibase {
namespace app {
namespace base {

class GuiComponentMessageHandler :  public Courier::ModelComponent
{
   signals:
      void postMsg(const HMISubStateChangedUpdMsg&);
   public:
      virtual void triggerHall() = 0;
   protected:
      virtual bool OnMessage(const Courier::Message& message);
};


}
}


}

#endif // _GuiComponentMessageHandler_H_
