/* ***************************************************************************************
* FILE:          GuiComponentBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GuiComponentBase.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef GUICOMPONENTBASE_H
#define GUICOMPONENTBASE_H

#include "AppBase/HmiAsfComponentBase.h"
#include "asf/core/BaseComponent.h"
#include "CourierTunnelService/CourierMessageReceiverProxy.h"
#include "View/IMessageSystem.h"
#include "AppBase/IApplicationSettings.h"
#include "AppUtils/HmiMacros.h"
#include "GuiComponentMessageHandler.h"
#include "CourierMessageReceiverAdapter.h"

class IAppViewSettings;
class ICgiApp;

namespace hmibase {
namespace app {
namespace base {
class GuiComponentBase: public GuiComponentMessageHandler
   , public HmiAsfComponentBase
   , public asf::core::BaseComponent
   , public asf::core::ServiceAvailableIF
{
   public:
      GuiComponentBase(const char* appName, const IApplicationSettings&);
      virtual ~GuiComponentBase();
      // ASF slots
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      virtual unsigned int getDefaultTraceClass() = 0;
      virtual void triggerHall();
      void waitUntilTunnelServiceReady();

      static GuiComponentBase& getInstance();
      // static const char* getAppName();

      struct SurfaceParameter
      {
         SurfaceParameter();

         unsigned int mainSurfaceId;
         unsigned int applicationPopupSurfaceId;
         unsigned int globalPopupSurfaceId;
         unsigned int videoSurfaceId;
         const IAppViewSettings* appViewSettings;
      };

      const IApplicationSettings& _appSettings;

   private:
      static GuiComponentBase*    _theInstance;
      ::boost::shared_ptr< ::CourierTunnelService::CourierMessageReceiver::CourierMessageReceiverProxy > _hallTunnelProxy;

   public:
      void startGuiMainThread();
      virtual void preRun();
      virtual int  run();
      virtual void postRun();
      virtual void setupCgiInstance() = 0;
      void setCgiApp(class ICgiApp* ptr);

   protected:
      class ICgiApp* getCgiApp();

   private:
      ::asf::threading::Thread*  _hmiThread;
      class ICgiApp*             _cgiApp;
      static void* threadFunc(void* args);

      hmibase::services::CourierTunnelService::CourierMessageReceiverAdapter _courierMessageReceiverAdapter;

      HMIBASE_UNCOPYABLE(GuiComponentBase)
};


}
}


}


HMIBASE_DEPRECATED_TYPE_ALIAS(GuiComponentBase, ::hmibase::app::base::GuiComponentBase)

#endif // GUICOMPONENTBASE_H
