/* ***************************************************************************************
* FILE:          CourierMessageReceiverAdapter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CourierMessageReceiverAdapter.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef FRAMEWORK_APPBASE_COURIERMESSAGERECEIVERADAPTER_H_
#define FRAMEWORK_APPBASE_COURIERMESSAGERECEIVERADAPTER_H_

#include "asf/core/BaseComponent.h"
#include "CourierTunnelService/CourierMessageReceiverProxy.h"

namespace hmibase {
namespace services {
namespace CourierTunnelService {

class CourierMessageReceiverAdapter: public ::asf::core::LocalMessageCallbackIF0
{
   public:
      CourierMessageReceiverAdapter();
      virtual ~CourierMessageReceiverAdapter();

      virtual void onLocalMessage(::boost::shared_ptr< ::asf::core::PayloadTuple0 >& payload);
      void setProxy(::boost::shared_ptr< ::CourierTunnelService::CourierMessageReceiver::CourierMessageReceiverProxy > proxy)
      {
         _proxy = proxy;
      }

   private:

      ::boost::shared_ptr< ::CourierTunnelService::CourierMessageReceiver::CourierMessageReceiverProxy > _proxy;
};


}
}


}


#endif /* FRAMEWORK_APPBASE_COURIERMESSAGERECEIVERADAPTER_H_ */
