/*
 * g3g_dbusobject.h
 *
 *  Created on: Sep 12, 2012
 *      Author: rjk2hi
 */

#ifndef TCLDBUSOBJECT_H_
#define TCLDBUSOBJECT_H_

#include <dbus/dbus.h>
#include <string>
#include "../include/g3g_dbusbindingdatatypes.h"
#include "../include/g3g_dbusconnection.h"

/*
 * Intro :
 * tclDbusObjectProxy : Class to add match rules for Dbus
 * tclDbusObjectAdapter : Class to register object paths and v-table with XXX
 */

/*
 * Class for Dbus Proxy Object
 */
class g3g_dbusmessagehandler;

class g3g_dbusobjectproxy
{
private:
	g3g_dbusobjectproxy();

	DBusConnection* m_ptrConnection;
	std::string m_matchrule;
	std::string m_InterfaceName;
	std::string m_ObjectPath;
	std::string m_NodeName;
	bool		m_disablepathcheck;

protected:
	g3g_dbusmessagehandler m_oMsgHandler;//Maintaining a different message object per object proxy makes sense
	/*
	 * Standard use
	 */
	bool bSetup();
	/*
	 * Expert use
	 */
	bool bAddMatchRule(std::string type, std::string busname,std::string interface, std::string member,std::string path);
	bool bRemoveMatchRule(std::string type, std::string busname,std::string interface, std::string member,std::string path);
	/*
	 * Sets up dbus message filter function
	 */
	virtual bool bSetupFilter();

private:
	virtual DBusHandlerResult eDispatch_Signal(g3g_dbusmessage *msg)= 0;

public:
	/*
	 * Constructor
	 */
	g3g_dbusobjectproxy(g3g_dbusconnection* rfConnection,const char* sNodeName, const char* sObjectPath, const char* sInterfaceName);
	/*
	 * Destructor
	 */
	virtual ~g3g_dbusobjectproxy();

	/*
	 * Message filter
	 */
	static DBusHandlerResult dbusMessageFilter(DBusConnection *conn, DBusMessage *msg, void *data);

};


/*
 * Class for Dbus Adaptor object
 */
class g3g_dbusobjectadapter
{
	DBusConnection* m_ptrConnection;
	std::string m_InterfaceName;
	std::string m_ObjectPath;
protected:
	g3g_dbusmessagehandler m_oMsgHandler;//Maintaining a different message object per object proxy makes sense
private:
	DBusObjectPathVTable m_interfacevtable;


	/*
	 *  Dbus Introspection related
	 */
	static std::string m_NodeName; //As of now, I will go with one root node per app.
	static std::map<std::string,std::map<std::string, g3g_dbusobjectadapter*> > m_interfacelist;//Pointer to interfaces
	DBusHandlerResult eRootIntrospection(DBusConnection *conn, DBusMessage *msg, void *data) const;

	/*
	 * Pure virtual functions
	 */
	virtual DBusHandlerResult eDispatch_MethodCall(g3g_dbusmessage *msg)= 0;//Trigger method invocation call
	virtual std::string sGetIntrospectionData() = 0;// Get the introspection data from Interfaces

	static DBusHandlerResult dbusMessageFilter(DBusConnection *conn, DBusMessage *msg, void *data);

	g3g_dbusobjectadapter();

protected:
	bool bSetup();

public:
	/*
	 * Constructor
	 */
	g3g_dbusobjectadapter(g3g_dbusconnection *rfConnection, const char* sNodeName, const char* sObjPath, const char* sIfName);
	/*
	 * Destructor
	 */
	virtual ~g3g_dbusobjectadapter();
};


#endif /* TCLDBUSOBJECT_H_ */

