/*
 * g3g_dbusconnection.h
 *
 *  Created on: Sep 13, 2012
 *      Author: rjk2hi
 */

#ifndef G3G_DBUSCONNECTION_H_
#define G3G_DBUSCONNECTION_H_

extern am::CAmSocketHandler* pSocketHandler();

class g3g_dbusconnection
{
private:
	/*
	 * Map to handle watches
	 */
	std::map<DBusWatch*, am::sh_pollHandle_t> 	mMapHandleWatch;
	/*
	 * List to all handle timers
	 */
	std::vector<am::sh_timerHandle_t*> 			mpListTimerHandles;

	//Call back function pointers
	am::TAmShPollCheck<g3g_dbusconnection> 			pDbusCheckCallback;
    am::TAmShTimerCallBack<g3g_dbusconnection> 		pDbusTimerCallback;
    am::TAmShPollFired<g3g_dbusconnection> 			pDbusFireCallback;
    am::TAmShPollDispatch<g3g_dbusconnection> 		pDbusDispatchCallback;

    /*
     * Error code
     */
    T_e8_DbusErrorCode 	e8ErrCode;

    DBusBusType m_eBusType;
    /*
     * Map to handle Connections
     */
    static std::map<DBusBusType,g3g_dbusconnection*>	mMapHandleConnections;

	DBusConnection* m_ptrConn;
	/***************************************************************************
	 *                Timeout Functions
	 ***************************************************************************/
	static dbus_bool_t	bAddTimeout(DBusTimeout *timeout, void* pvUserData);
	static void		vRemoveTimeout(DBusTimeout *timeout, void* pvUserData);
	static void		vToggleTimeout(DBusTimeout *timeout, void* pvUserData);
	/***************************************************************************
	 *                Watch Functions
	 ***************************************************************************/
	static dbus_bool_t 	bAddWatch(DBusWatch *watch, void* pvUserData);
	static void			vRemoveWatch(DBusWatch *watch, void* pvUserData);
	static void			vToggleWatch(DBusWatch *watch, void* pvUserData);

	bool 				bSetup(DBusBusType eType);

	/*****************************************************************************
	 *                Socket callback functions
	 *****************************************************************************/
	bool				bDispatchCallback(const am::sh_pollHandle_t handle, void* pvuserdata);
	bool				bCheckCallback(const am::sh_pollHandle_t handle, void* pvuserdata);
	void				vFireCallback(const pollfd pollfd, const am::sh_pollHandle_t handle, void * pvuserdata);
	void				vTimerCallback(am::sh_timerHandle_t handle, void *pvuserdata);

	g3g_dbusconnection(DBusBusType eType);

public:

	~g3g_dbusconnection();

	static g3g_dbusconnection* getConnection(DBusBusType eType);

	/* Error handling related functions */
	operator bool() const
	{
		return (e8ErrCode == DBERR_NONE);
	}
	T_e8_DbusErrorCode e8GetError()
	{
		return e8ErrCode;
	}
	DBusConnection* pGetDbusConnectionPtr();
};


#endif /* TEMP_H_ */
