/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2017
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
***************************************************************************/

/*!
*\file     DoIP_Server.cpp
*\brief
*
*\author   CM-CI3/ESW-Losch
*
*\par Copyright:
*(c) 2017 Robert Bosch Car Multimedia GmbH
*
*\par History:
* See history of revision control system
***************************************************************************/

/****************************************************************************
| includes
|--------------------------------------------------------------------------*/
#include <cstdarg>
#include <string.h>

#include "DoIP_Server.h"
#include "DoIP_Channel.h"
#include "DoIP_Connection.h"
#include "ethernetbus.h"

#ifndef DOIP_USE_EXTERNAL_TRACE
void DoIP_TraceFormat(int priority, const char *string_buffer, ...)
{
   char trace_buffer[255] = {0};
   va_list     va_lst;

   va_start(va_lst, string_buffer);
   vsnprintf(trace_buffer, sizeof(trace_buffer)-1, string_buffer, va_lst);
   va_end(va_lst);

   DoIP_Trace(priority, trace_buffer);
}
#endif



DoIP_Server::DoIP_Server(tclEthernetBus* poBus, tU16 u16LocalAddr, char const acVIN[], tU8 u8VINlen)
// : tclDiaServer(NULL, UDS_DOIP, u16LocalAddr, 0, u16S3, u16P2, u16P2ext, NULL, 0),
 : cu16LocalAddr(u16LocalAddr),
   poEthBus(poBus)
{
   poEthBus->bRegister(this, acVIN, u8VINlen);
}

DoIP_Server::~DoIP_Server()
{
   poEthBus->bRemove(this);
}

tU8 DoIP_Server::u8GetBusNumber()
{
   if(poEthBus != NULL)
      return poEthBus->cu8BusNumber;
   return 0xFF;
}

/**
 * to be implemented by derived class in user process
 * this is the template how it may be done
 *
void DoIP_Server::vAddDoIPChannel(tclDoIPServerChannel* poConn)
{
   oConnections.push_back(poConn);
}

void DoIP_Server::vRemoveDoIPChannel(tclDoIPServerChannel* poChan)
{
   std::list<tclDiaServerConnection*>::iterator conn;
   for(conn = oConnections.begin(); conn != oConnections.end(); conn++)
   {
      if(*conn == poChan) //TODO does this pointer comparison work???
      {
         oConnections.erase(conn);
         break;
      }
   }
}
*/

void DoIP_Server::vPowerModeResponse(tU8 powerState)
{
   if(poEthBus->poGetDoIPProtocoll() != NULL)
   {
      poEthBus->poGetDoIPProtocoll()->vPowerModeResponse(powerState);
   }
}

void DoIP_Server::vRoutingActivationAuthenticationResp(bool Authentified, tU8* AuthenticationResData)
{
   if(poEthBus->poGetDoIPProtocoll() != NULL)
   {
      poEthBus->poGetDoIPProtocoll()->vRoutingActivationAuthenticationResp(Authentified, AuthenticationResData);
   }
}

#if 0
void DoIP_Server::vRoutingActivationConfirmationResp(bool Confirmed, tU8* ConfirmedResData)
{
   std::list<tclDiaServerConnection*>::iterator conn;
   for(conn = oConnections.begin(); conn != oConnections.end(); conn++)
   {
   }
}
#endif
