/**********************************************************************************************************************
 *
 * COPYRIGHT RESERVED, Robert Bosch GmbH, 2013. All rights reserved.
 * The reproduction, distribution and utilization of this document as well as the communication of its contents to
 * others without explicit authorization is prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 **********************************************************************************************************************/

#ifndef DOIP_TRACE_TYPES_H
#define DOIP_TRACE_TYPES_H

typedef bool (tIsTraceInfoActiveFn)(void);

#ifndef DOIP_USE_EXTERNAL_TRACE

// function prototypes for trace purposes
void DoIP_TraceFormat(int priority, const char *string_buffer, ...);

void DoIP_Trace(int priority, const char* trace_buffer); // prototype, to be implemented in process context


#define DOIP_LOG_ALWAYS    -1
#define DOIP_LOG_EMERG      0  /* system is unusable */
#define DOIP_LOG_ALERT      1  /* action must be taken immediately */
#define DOIP_LOG_CRIT       2  /* critical conditions */
#define DOIP_LOG_ERR        3  /* error conditions */
#define DOIP_LOG_WARNING    4  /* warning conditions */
#define DOIP_LOG_NOTICE     5  /* normal but significant condition */
#define DOIP_LOG_INFO       6  /* informational */
#define DOIP_LOG_DEBUG      7  /* debug-level messages */

#define DOIP_TRACE_CRIT(...)      DoIP_TraceFormat(DOIP_LOG_CRIT, __VA_ARGS__);
#define DOIP_TRACE_ERR(...)       DoIP_TraceFormat(DOIP_LOG_ERR, __VA_ARGS__);
#define DOIP_TRACE_WARNING(...)   DoIP_TraceFormat(DOIP_LOG_WARNING, __VA_ARGS__);
#define DOIP_TRACE_NOTICE(...)    DoIP_TraceFormat(DOIP_LOG_NOTICE, __VA_ARGS__);
#define DOIP_TRACE_INFO(...)      DoIP_TraceFormat(DOIP_LOG_INFO, __VA_ARGS__);
#define DOIP_TRACE_DEBUG(...)     DoIP_TraceFormat(DOIP_LOG_DEBUG, __VA_ARGS__);
#define DOIP_TRACE_ALWAYS(...)    DoIP_TraceFormat(DOIP_LOG_ALWAYS, __VA_ARGS__);


#endif

#endif /* DOIP_TRACE_TYPES_H */
