/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     DoIP_RoutingActivation.h
 *\brief    .
 *
 *\author   CM-CI1/ENP1 - Losch
 *
 *\par Copyright:
 *(c) 2018 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/

#ifndef DOIP_ROUTINGACTIVATION_H
#define DOIP_ROUTINGACTIVATION_H


#define DOIP_RA_RESPCODE_UNKNOWN_SA            0x00u
#define DOIP_RA_RESPCODE_NO_FREE_SOCKET        0x01u
#define DOIP_RA_RESPCODE_CONNECTION_IN_USE     0x02u
#define DOIP_RA_RESPCODE_SA_IN_USE             0x03u
#define DOIP_RA_RESPCODE_AUTH_FAILED           0x04u
#define DOIP_RA_RESPCODE_CONF_FAILED           0x05u
#define DOIP_RA_RESPCODE_UNKNWON_TYPE          0x06u
#define DOIP_RA_RESPCODE_SUCCESS               0x10u
#define DOIP_RA_RESPCODE_CONF_PENDING          0x11u

#define DOIP_RA_STATUS_AUTH_MASK               0x07u
#define DOIP_RA_STATUS_AUTH_NOT_CHECKED        0x00u
#define DOIP_RA_STATUS_AUTH_SUCCESS            0x01u
#define DOIP_RA_STATUS_AUTH_PENDING            0x02u
#define DOIP_RA_STATUS_AUTH_FAILED             0x04u
#define DOIP_RA_STATUS_CONF_MASK               0x38u
#define DOIP_RA_STATUS_CONF_NOT_CHECKED        0x00u
#define DOIP_RA_STATUS_CONF_SUCCESS            0x08u
#define DOIP_RA_STATUS_CONF_PENDING            0x10u
#define DOIP_RA_STATUS_CONF_FAILED             0x20u
#define DOIP_RA_STATUS_ROUTE_ACTIVE_MASK       0x40u
#define DOIP_RA_STATUS_ROUTE_ACTIVE            0x40u
#define DOIP_RA_STATUS_ROUTE_NOT_ACTIVE        0x00u
#define DOIP_RA_STATUS_ROUTE_REG_MASK          0x80u
#define DOIP_RA_STATUS_ROUTE_REGISTERED        0x80u
#define DOIP_RA_STATUS_ROUTE_NOT_REG           0x00u

#define DOIP_RA_STATUS_INIT (DOIP_RA_STATUS_AUTH_NOT_CHECKED|DOIP_RA_STATUS_CONF_NOT_CHECKED|DOIP_RA_STATUS_ROUTE_NOT_REG|DOIP_RA_STATUS_ROUTE_NOT_ACTIVE)

#define DOIP_CENTRAL_SECURITY_ID                            (tU8)0xE0
#define DOIP_ROUTEACTIVE_NO_FURTHER_ACTION                  (tU8)0x00
#define DOIP_ROUTENOTACTIVE_INIT_CENTRAL_SECURITY           (tU8)0x10

#define DOIP_ROUTINGACTIVATION_IDLE                0x00u
#define DOIP_ROUTINGACTIVATION_RECEIVED            0x01u
#define DOIP_ROUTINGACTIVATION_WAIT4ALIVECHECK     0x02u
#define DOIP_ROUTINGACTIVATION_READY2SEND          0x03u
#define DOIP_ROUTINGACTIVATION_WAIT4CONFIRMATION   0x04u
#define DOIP_ROUTINGACTIVATION_PENDING             0x05u



#endif

