/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     DoIP_BaseTypes.h
 *\brief    basic type definition for DoIP protocol library
 *
 *\author   CM-CI1/ENP1 - Losch
 *
 *\par Copyright:
 *(c) 2018 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/


#ifndef DOIP_BASETYPES_H
#define DOIP_BASETYPES_H

#define  DOIP_XSTR(s) DOIP_STR(s)
#define DOIP_STR(s) #s

#ifdef DOIP_BASE_TYPES_FILE
   #include DOIP_XSTR(DOIP_BASE_TYPES_FILE)
#else


#ifndef TRUE
#define TRUE true
#endif

#ifndef FALSE
#define FALSE false
#endif


/* --Include needed for size_t. */
#include "stddef.h"
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif


/*****************************************************************************
| typedefs (scope: global)
|---------------------------------------------------------------------------*/
#include <stdint.h>
typedef unsigned char           tBool;

typedef uint8_t                 tU8;
typedef int8_t                  tS8;
typedef char                    tChar;

typedef char*                   tString;
typedef const char*             tCString;

typedef uint16_t                tU16;
typedef int16_t                 tS16;


typedef unsigned short          tUShort;
typedef short                   tShort;

typedef unsigned int            tUInt;
typedef int                     tInt;

typedef unsigned long           tULong;
typedef long                    tLong;


typedef float                   tFloat;
typedef double                  tDouble;
typedef long double             tLDouble;

typedef size_t                  tSize;

// typedef void                    tVoid;
#define tVoid void
// ---> typedef of void is nonstandard and leads to compiler errors

typedef unsigned int            tUBitfield;
typedef int                     tBitfield;

typedef float                   tF32;


/* -- Target-dependent types: -- */
/* LINUX: */

typedef uint32_t                tU32;
typedef int32_t                 tS32;
typedef double                  tF64;
typedef uint64_t                tU64;
typedef int64_t                 tS64;

#ifdef __cplusplus
}
#endif

#  endif

#endif /*DOIP_BASETYPES_H*/
