/*
 * DoIP_Node.h
 *
 *  Created on: Aug 14, 2018
 *      Author: sdn2hi
 */

#ifndef DOIP_TRACER_H_
#define DOIP_TRACER_H_

#include "doipcommon/DoIP_Types.h"
struct  DoIP_Tracer
    {
       typedef bool (tIsTraceActiveFn)(uint8_t);
       typedef void (tTraceFn)(uint8_t, const char *);
    public:

       DoIP_Tracer():
          mLevelCritical(2),
          mLevelError(3),
          mLevelWarning(4),
          mLevelNotice(5),
          mLevelInfo(6),
          mIsTraceActiveFn(nullptr),
          mTraceFn(nullptr)
       {
       }
       uint8_t mLevelCritical;
       uint8_t mLevelError;
       uint8_t mLevelWarning;
       uint8_t mLevelNotice;
       uint8_t mLevelInfo;
       void setIsTraceActiveFn(tIsTraceActiveFn *fn) {
          mIsTraceActiveFn=fn;          
       }
       void setTraceFn(tTraceFn *fn) {
          mTraceFn=fn;
       }
       bool isTraceActive(uint8_t level) {
          return mIsTraceActiveFn ? mIsTraceActiveFn(level) : false;
       }

       void traceFormat(uint8_t level, const char *string_buffer, ...);
       
    private:
       tIsTraceActiveFn *mIsTraceActiveFn;
       tTraceFn *mTraceFn;
    };


#define DOIP_CLIENT_TRACE_CRITICAL(...)                                 \
   if (mDoipCfg.mTracer.isTraceActive(mDoipCfg.mTracer.mLevelCritical)) { \
      mDoipCfg.mTracer.traceFormat(mDoipCfg.mTracer.mLevelCritical, __VA_ARGS__); \
   }

#define DOIP_CLIENT_TRACE_ERROR(...)                                    \
   if (mDoipCfg.mTracer.isTraceActive(mDoipCfg.mTracer.mLevelError)) { \
      mDoipCfg.mTracer.traceFormat(mDoipCfg.mTracer.mLevelError, __VA_ARGS__); \
   }

#define DOIP_CLIENT_TRACE_WARNING(...)                                  \
   if (mDoipCfg.mTracer.isTraceActive(mDoipCfg.mTracer.mLevelWarning)) { \
      mDoipCfg.mTracer.traceFormat(mDoipCfg.mTracer.mLevelWarning, __VA_ARGS__); \
   }

#define DOIP_CLIENT_TRACE_NOTICE(...)                                   \
   if (mDoipCfg.mTracer.isTraceActive(mDoipCfg.mTracer.mLevelNotice)) { \
      mDoipCfg.mTracer.traceFormat(mDoipCfg.mTracer.mLevelNotice, __VA_ARGS__); \
   }

#define DOIP_CLIENT_TRACE_INFO(...)                                     \
   if (mDoipCfg.mTracer.isTraceActive(mDoipCfg.mTracer.mLevelInfo)) { \
      mDoipCfg.mTracer.traceFormat(mDoipCfg.mTracer.mLevelInfo, __VA_ARGS__); \
   }



#endif
