/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     DoIP_ClientCfg.h
 *\brief    static configurations of DoIP protocol library for a client
 *
 *\author   CM-CI1/ENP1 - Losch
 *
 *\par Copyright:
 *(c) 2018 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/



#ifndef DOIP_CLIENT_CFG_H
#define DOIP_CLIENT_CFG_H

#include "doipcommon/DoIP_Types.h"
#include "DoIP_Tracer.h"

struct DoIP_Cfg {
   DoIP_Cfg():
      entityStatusMaxByteFieldUse(true),
      payloadLengthEntityStatusResp(0x00000007u)
   {

   }
   bool entityStatusMaxByteFieldUse;
   uint32_t payloadLengthEntityStatusResp;
   
   //DoIP_Tracer mTracer;
};


#define DOIP_CFG_MaxUDPRequestPerMessage                3u
/*Extra one location is provided for storing NACK when the queue is full*/
#define DOIP_CFG_MaxUDPQueueSize    (DOIP_CFG_MaxUDPRequestPerMessage + 1u)


#define DOIP_CFG_cu32UDPBufferSize             128U
#define DOIP_CFG_cu32TCPMaxRequestSize         65535
#define DOIP_CFG_cu32TCPBufferSize             (16*1024)

#define DOIP_CFG_UDPSOCKET_LISTENER_STACKSIZE  (12*1024)

#define DOIP_CFG_TCPSOCKET_CLIENT_STACKSIZE    (6*1024)



#endif /* DOIP_CLIENT_CFG_H */
