/************************************************************************
* FILE:         vd_Diaglog_clienthandlerspm.h
* PROJECT:      ARION Prototyp
* SW-COMPONENT: Virtual Device Keyboard
*----------------------------------------------------------------------
*
* DESCRIPTION: VD Diaglog <-> SPM Interface
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 16.05.08  | TMS Plischke | initial version
* 07.11.12	| GPU2KOR			 | changed vOnHandleSystemPowerModeEvent for new spm_fi
*************************************************************************/

#ifndef _VDDIAGLOG_CLIENT_HANDLERSPM_H_
#define _VDDIAGLOG_CLIENT_HANDLERSPM_H_

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
//lint -e451  //Warning 451: prio3: Header file repeatedly included but does not have a standard include guard
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"
//lint +e451

#ifndef VD_DIAGLOG_INCLUDEGUARD_cfc_fi_if
   #define VD_DIAGLOG_INCLUDEGUARD_cfc_fi_if

   #define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_DBGVISITORS
   #define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_STDVISITORS
   #define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_FUNCTIONIDS
   #define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_SERVICEINFO
   #define CFC_FI_S_IMPORT_INTERFACE_FI_TYPES
   #include "cfc_fi_if.h"
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_spm_fi_if
   #define VD_DIAGLOG_INCLUDEGUARD_spm_fi_if

   #define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_DBGVISITORS
   #define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
   #define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
   #define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
   #define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
   #include "spm_fi_if.h"
#endif



//-----------------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------------
class vdDiagLog_tclApp;  //lint !e763 Info 763 , eliminating lint warnings Redundant declaration for symbol
class fi_tclTypeBase;    //lint !e763 Info 763 , eliminating lint warnings Redundant declaration for symbol
//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
/* ---
the application has one client message handler for each service
--- */
class vdDiaglog_tclclienthandlerspm : public ahl_tclBaseWork
{
private:
   vdDiagLog_tclApp*          m_poGWMain;
   /* ---   to store the RegID of the service    --- */
   tU16 _u16RegID;
   tBool _bFidReg;
   tBool _bRegistrationInProgress;
   tU32 m_u32InternalSubstateOld;
   /*---------------------------------------------------------------------*/
   tBool bRegisterForService();
   /*---------------------------------------------------------------------*/
   tBool bUnregisterForService();
   /*---------------------------------------------------------------------*/
   tBool bRegisterForFID(tU16 u16FID);
   /*---------------------------------------------------------------------*/
   tBool bUnregisterForFID(tU16 u16FID);
   /*---------------------------------------------------------------------*/
   tBool bFirstIgnitionCycleEventRecvd;//The First IgnitionCycle Event das only indicate how many ignition cycles have been 
								  //seen after startup (before Diaglog has started)). So it does not indicate the beginning 
								  //of an ignition cycle like the subsequent IgnitionCycle Events
   /* +++   Enter your private Data and functions here   +++ */

    spm_fi_tcl_SPM_e32_SYSPWRMODE::tenType  _enLastPowerMode;
public:
   /*---------------------------------------------------------------------*/
   vdDiaglog_tclclienthandlerspm(); // default constructor
   vdDiaglog_tclclienthandlerspm(vdDiagLog_tclApp* poMain); // constructor
   /*---------------------------------------------------------------------*/
   tVoid vOnNewAppState( tU32 u32OldAppState, tU32 u32AppState );
   /*---------------------------------------------------------------------*/
   tVoid vOnSpmCvmEvent( amt_tclServiceData* poMessage ) const;
	/*---------------------------------------------------------------------*/
   //tVoid vOnHandleSpmSubstateEvent( amt_tclServiceData* poMessage );
	/*---------------------------------------------------------------------*/
   //tVoid    vOnHandleSpmSubstateHandlingEvent( amt_tclServiceData* poMessage );
   /*---------------------------------------------------------------------*/
   tVoid    vOnHandleSysStateEvent( amt_tclServiceData* poMessage ) const;
   /*---------------------------------------------------------------------*/
//#if 0//SysPwrMode
   tVoid    vOnHandleSystemPowerModeEvent( amt_tclServiceData* poMessage );
//#endif//SysPwrMode
   /*---------------------------------------------------------------------*/
   tVoid    vOnHandleIgnitionCyclesEvent( amt_tclServiceData* poMessage );
   /*---------------------------------------------------------------------*/
   tVoid vOnServiceState ( tU16 u16ServiceId, tU16 u16ServerId, tU16 u16RegisterId,
                           tU8  u8ServiceState,  tU16 u16SubId );
   /*---------------------------------------------------------------------*/
   /* +++   Enter your public Data and functions here   +++ */
   /*---------------------------------------------------------------------*/
protected:
   DECLARE_MSG_MAP(vdDiaglog_tclclienthandlerspm)

   /*---------------------------------------------------------------------*/
   virtual tVoid vOnUnknownMessage( amt_tclBaseMessage* poMessage );
   /*---------------------------------------------------------------------*/
   tVoid vSendMsg(amt_tclServiceData const*, fi_tclTypeBase const&, tU8);

};

#endif


