//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_inc_conf.cpp
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog INC Interface
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2013 Robert Bosch GmbH}, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 24.10.13  | BSOT Plischke                | Initial version
//////////////////////////////////////////////////////////////////////////
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_inc_comm
   #include "common/interfaces/inc/vd_diaglog_inc_comm.h"
#endif  

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include <vd_diaglog_if.h>

#define DemConf_DemEventParameter_KEY_FAC_SETUP                      19
#define DemConf_DemEventParameter_KEY_FAC_SOUND                      20
#define DemConf_DemEventParameter_KEY_FAC_LEFT_ENC                   21
#define DemConf_DemEventParameter_KEY_FAC_RADIO                      22
#define DemConf_DemEventParameter_KEY_FAC_MEDIA                      23
#define DemConf_DemEventParameter_KEY_FAC_MENU                       24
#define DemConf_DemEventParameter_KEY_FAC_CAR                        25
#define DemConf_DemEventParameter_KEY_FAC_MUTE                       26
#define DemConf_DemEventParameter_KEY_FAC_PHONE                      27
#define DemConf_DemEventParameter_KEY_FAC_EJECT                      28
#define DemConf_DemEventParameter_KEY_FAC_AM_FM                      29
#define DemConf_DemEventParameter_KEY_FAC_TP                         30
#define DemConf_DemEventParameter_KEY_DEV_FACEPLATE                  31
#define DemConf_DemEventParameter_KEY_DEV_SWC                        32
#define DemConf_DemEventParameter_KEY_DEV_POWER                      33
#define DemConf_DemEventParameter_KEY_DEV_EJECT                      34
#define DemConf_DemEventParameter_AMPLIFIER_ON_SHORT_BAT             35
#define DemConf_DemEventParameter_EXT_UART_OVERLOADED                99 // changed 36 to 99
#define DemConf_DemEventParameter_CMC_VCAN_BUS_OFF                   36
#define DemConf_DemEventParameter_CMC_MCAN_BUS_OFF                   37
#define DemConf_DemEventParameter_CMC_VCAN_TIME_OUT                  38
#define DemConf_DemEventParameter_CMC_MCAN_TIME_OUT                  39

/*static*/
const trEventItcMap vdl_tclIncCommunication::rEventToItcMap[] =
{
/* { Event ID                                             , ITC                                      }*/
	{ DemConf_DemEventParameter_KEY_FAC_SETUP,                     ITC_AIVI_KEY_FAC_SETUP         },
	{ DemConf_DemEventParameter_KEY_FAC_SOUND,                     ITC_AIVI_KEY_FAC_SOUND 		    },
	{ DemConf_DemEventParameter_KEY_FAC_LEFT_ENC,                  ITC_AIVI_KEY_FAC_LEFT_ENC		 },
	{ DemConf_DemEventParameter_KEY_FAC_RADIO,                     ITC_AIVI_KEY_FAC_RADIO 			 },
	{ DemConf_DemEventParameter_KEY_FAC_MEDIA,                     ITC_AIVI_KEY_FAC_MEDIA			 },
	{ DemConf_DemEventParameter_KEY_FAC_MENU,                      ITC_AIVI_KEY_FAC_MENU			 },
	{ DemConf_DemEventParameter_KEY_FAC_CAR,                       ITC_AIVI_KEY_FAC_CAR				 },
	{ DemConf_DemEventParameter_KEY_FAC_MUTE,                      ITC_AIVI_KEY_FAC_MUTE			 },
	{ DemConf_DemEventParameter_KEY_FAC_PHONE,                     ITC_AIVI_KEY_FAC_PHONE			 },
	{ DemConf_DemEventParameter_KEY_FAC_EJECT,                     ITC_AIVI_KEY_FAC_EJECT			 },
	{ DemConf_DemEventParameter_KEY_FAC_AM_FM,                     ITC_AIVI_KEY_FAC_AM_FM			 },
	{ DemConf_DemEventParameter_KEY_FAC_TP,                        ITC_AIVI_KEY_FAC_TP				 },
   { DemConf_DemEventParameter_KEY_DEV_FACEPLATE,                 ITC_AIVI_KEY_DEV_FACEPLATE     },
   { DemConf_DemEventParameter_KEY_DEV_SWC,                       ITC_AIVI_KEY_DEV_SWC           },
   { DemConf_DemEventParameter_KEY_DEV_POWER,                     ITC_AIVI_KEY_DEV_POWER         },
   { DemConf_DemEventParameter_KEY_DEV_EJECT,                     ITC_AIVI_KEY_DEV_EJECT         },
   { DemConf_DemEventParameter_AMPLIFIER_ON_SHORT_BAT,            ITC_AMPLIFIER_ON_SHORT_BAT     },
   { DemConf_DemEventParameter_EXT_UART_OVERLOADED, 			  ITC_AIVI_EXT_UART_OVERLOAD	 },
   { DemConf_DemEventParameter_CMC_VCAN_BUS_OFF, 			      ITC_CMC_VCAN_BUS_OFF	 		 },
   { DemConf_DemEventParameter_CMC_MCAN_BUS_OFF, 			      ITC_CMC_MCAN_BUS_OFF	 		 },
   { DemConf_DemEventParameter_CMC_VCAN_TIME_OUT, 			      ITC_CMC_VCAN_TIME_OUT	 		 },
   { DemConf_DemEventParameter_CMC_MCAN_TIME_OUT, 			      ITC_CMC_MCAN_TIME_OUT	 		 },

};

/*static*/
int vdl_tclIncCommunication::iEventToItcMapSize()
{
  return (static_cast<int>(sizeof(vdl_tclIncCommunication::rEventToItcMap)/sizeof(trEventItcMap)));
}

