//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_typedefs_prj.h
// PROJECT:      project
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Typdef Definitions
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 24.10.13  | BSOT Plischke               | Initial version
// 28.12.18  | mky6kor						| Extended data configuration(RTC-434184)
//////////////////////////////////////////////////////////////////////////
#ifndef _VDDIAGLOG_TYPEDEFS_PRJ_H_
#define _VDDIAGLOG_TYPEDEFS_PRJ_H_


// this type must be defined by Project, because some could add here
// DIAGLOG_REPORT_BASE is always requiered!!!
typedef enum
{
   DIAGLOG_REPORT_BASE,                      // common requiered
}vdl_teDiaglogReportType;

// Extended Data
const tU8 DIAGLOG_XD_NO                = 0x00; // common requiered
const tU8 DIAGLOG_XD_STANDARD_ENV	   = 0x01;
const tU8 DIAGLOG_XD_MILEAGE           = 0x80;
const tU8 DIAGLOG_XD_AGE_COUNTER       = 0x81; // common requiered
const tU8 DIAGLOG_XD_OCC_COUNTER       = 0x82; // common requiered
const tU8 DIAGLOG_XD_ALL_RECORDS       = 0xff; // common requiered
struct vdl_tsDiagReadReportDM1
{
   tU32 u32DTC;
   tU8 u16Priority;
   tU8 u32OccuranceCount;
   vdl_tsDiagReadReportDM1()
   {
      u32DTC = 0x00;
      u16Priority = 0x00;
      u32OccuranceCount = 0x00;
   }
};

typedef std::vector<struct vdl_tsDiagReadReportDM1>              tReadReportListDM1;
typedef std::vector<struct vdl_tsDiagReadReportDM1>::iterator    tReadReportListDM1itr;
// Snapshot Data
const tU8 DIAGLOG_SNAPSHOTDATA_NO             = 0x00;
const tU8 DIAGLOG_SNAPSHOTDATA_MILEAGE_OCC_COUNTER  = 0x01;
//const tU8 DIAGLOG_SNAPSHOTDATA_OCC_COUNTER    = 0x02;


typedef tU32 tDiaResult;

#define DIA_SUCCESS                                         ((tU32) 0x00000000)
#define DIA_DONE                                            ((tU32) 0x00000000)
#define DIA_E_NOERROR                                       ((tU32) 0x00000000)
#define DIA_E_NO_ERROR                                      ((tU32) 0x00000000)

#define DIA_FAILED                                          ((tU32) 0x00000001)
#define DIA_NOT_DONE                                        ((tU32) 0x00000001)
#define DIA_E_ERROR                                         ((tU32) 0x00000001)


#endif // _VDDIAGLOG_TYPEDEFS_PRJ_H_
