/************************************************************************
* FILE:         vd_diaglog_store_to_emtrace.cpp
* PROJECT:      G3G
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: DiagLog write to EM-Trace class
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 07.08.14  | BSOT - Plischke    | initial version
*
*************************************************************************/
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>


#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_memory_master
   #include <common/framework/vd_diaglog_memory_master.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_store_to_emtrace
   #include <common/framework/vd_diaglog_store_to_emtrace.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_itc_definition_common
   #include <common/framework/vd_diaglog_itc_definition_common.h>  
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_store_to_emtrace.cpp.trc.h"
#endif

///////////////////////////////////////////////////////////////////////////////////
// 
// FUNCTION:tVoid vdl_tclMemoryMaster::vStoreToEmTrace
// 
// DESCRIPTION: write Data to EM-Trace
//
// PARAMETER:  none
//
// RETURNVALUE: none
// 
///////////////////////////////////////////////////////////////////////////////////

#ifdef DIAGLOG_STORE_TO_EMTRACE
/* static */ tVoid vdDiagLog_tclStoreToEmTrace::vStoreToEmTrace (tU8 MemoryId, vdl_teDiaglogReportMsg enReportMsg, tU32 u32DTC, tU16 u16ITC)
{
   ETG_TRACE_USR3_THR(( "--> vdDiagLog_tclStoreToEmTrace::vStoreToEmTrace"));
   if (u32DTC != 0xffffff)
   {
      if(enReportMsg == DIAGLOG_REPORT_FAILED)
      {
         switch (u16ITC)
         {
            case 0:  
            {
               // do nothing
               break;
            }
            default:
            {
               // store only master Memory
               if(MemoryId == DIAGLOG_MEMORY_CUSTOMER)
               {
                  ETG_TRACE_USR1_THR(( "--- vdDiagLog_tclStoreToEmTrace::vStoreToEmTrace => Store DTC %x to EM_TRACE",u32DTC));
                  ETG_TRACE_ERRMEM(("DIAGLOG => MemoryId:%02x DTC:%06x ITC:%04x => Status changed from PASSED to FAILED.",MemoryId, static_cast<tUInt>(u32DTC),u16ITC));
               }
               break;
            }
         }// switch (u16ITC)
      }//if(enReportMsg == DIAGLOG_REPORT_FAILED)
      else if(enReportMsg == DIAGLOG_REPORT_PASSED)
      {
         switch (u16ITC)
         {
            case 0:     
            {
               // do nothing
               break;
            }
            default:
            {
               // store only master Memory
               if(MemoryId == DIAGLOG_MEMORY_CUSTOMER)
               {
                  ETG_TRACE_USR1_THR(( "--- vdDiagLog_tclStoreToEmTrace::vStoreToEmTrace => Store DTC %x to EM_TRACE",u32DTC));
                  ETG_TRACE_ERRMEM(("DIAGLOG => MemoryId:%02x DTC:%06x ITC:%04x => Status changed from FAILED to PASSED.",MemoryId, static_cast<tUInt>(u32DTC),u16ITC));
               }
               break;
            }
         }// switch (u16ITC)
      }// else if(enReportMsg == DIAGLOG_REPORT_PASSED)
      else
      {
         ETG_TRACE_ERRMEM(("!!! vdDiagLog_tclStoreToEmTrace::vStoreToEmTrace => UNKNOWN enReportMsg:%x",enReportMsg));
         NORMAL_M_ASSERT_ALWAYS();
      }
   }// if (u32DTC != 0xffffff)
   ETG_TRACE_USR3_THR(( "<-- vdDiagLog_tclStoreToEmTrace::vStoreToEmTrace"));
}
#endif // #ifdef DIAGLOG_STORE_TO_EMTRACE
