//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_reprod_record_prj.cpp
// PROJECT:      common
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: Project depended Reprort
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 23.01.15  | BSOT Plischke                | created
// 28.12.18  | mky6kor						| Extended data configuration(RTC-434184)
//////////////////////////////////////////////////////////////////////////
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifndef VD_DIAGLOG_INCLUDEGUARD_ExtendedData
   #include <common/framework/extendedData/ExtendedData.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_ExtendedDataPrj
   #include <project/framework/extendedData/ExtendedDataPrj.h>
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record
   #include <common/framework/vd_diaglog_report_record.h>
#endif

/* --Includes. */

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
#include "trcGenProj/Header/vd_diaglog_report_record_prj.cpp.trc.h"   
#endif


//lint -esym(1762, vdl_tclReportRecord::generateExtendedData)
VDD::ExtendedData* vdl_tclReportRecord::generateExtendedData(tU8 recNo, const vdl_tclReportRecord* const pReportRecord)
{
   VDD::ExtendedData* pNew = NULL;

   if(pReportRecord == NULL)
   {
      NORMAL_M_ASSERT_ALWAYS();
      return NULL;
   }// if(pReportRecord == NULL)
   else
   {
      const tU32 DTC = pReportRecord->u32DTC();

      //lint -e764 //switch statement does not have a case
      switch(recNo)
      {
         /*case DIAGLOG_XD_MILEAGE:
         {
            ETG_TRACE_USR1_THR(( "--- vdl_tclUDSReportRecord::generateExtendedData => DTC:%06x  ExtData:%02x create",DTC,recNo));   
            pNew = new VDD::MileageFreezeFrame(pReportRecord);
            if(!pNew)
            {
               ETG_TRACE_ERRMEM(( "!!! vdl_tclUDSReportRecord::generateExtendedData => NULL == pNew"));
               NORMAL_M_ASSERT_ALWAYS();
               return NULL;
            }
            break;
         }
         case DIAGLOG_XD_AGE_COUNTER:
         {
            ETG_TRACE_USR1_THR(( "--- vdl_tclUDSReportRecord::generateExtendedData => DTC:%06x  ExtData:%02x create",DTC,recNo));   
            pNew = new VDD::AgeingCounterFreezeFrame(pReportRecord);
            if(!pNew)
            {
               ETG_TRACE_ERRMEM(( "!!! vdl_tclUDSReportRecord::generateExtendedData => NULL == pNew"));
               NORMAL_M_ASSERT_ALWAYS();
               return NULL;
            }
            break;
         }
         case DIAGLOG_XD_OCC_COUNTER:
         {
            ETG_TRACE_USR1_THR(( "--- vdl_tclUDSReportRecord::generateExtendedData => DTC:%06x  ExtData:%02x create",DTC,recNo));   
            pNew = new VDD::OccurenceCounterFreezeFrame(pReportRecord);
            if(!pNew)
            {
               ETG_TRACE_ERRMEM(( "!!! vdl_tclUDSReportRecord::generateExtendedData => NULL == pNew"));
               NORMAL_M_ASSERT_ALWAYS();
               return NULL;
            }
            break;
         }
         case 0x02:
         {
            ETG_TRACE_USR1_THR(( "--- vdl_tclUDSReportRecord::generateExtendedData => DTC:%06x  ExtData:%02x create",DTC,recNo));   
            pNew = new DummyFreezeFrame ();
            if(!pNew)
            {
               ETG_TRACE_ERRMEM(( "!!! vdl_tclUDSReportRecord::generateExtendedData => NULL == pNew"));
               NORMAL_M_ASSERT_ALWAYS();
               return NULL;
            }
            break;
         }
         */
      	 case DIAGLOG_XD_STANDARD_ENV:
      	 {
             ETG_TRACE_USR1_THR(( "--- vdl_tclUDSReportRecord::generateExtendedData => DTC:%06x  ExtData:%02x create",DTC,recNo));
             pNew = new VDD::StandardizedEnvironmentalDataFreezeFrame(pReportRecord);
             if(!pNew)
             {
                ETG_TRACE_ERRMEM(( "!!! vdl_tclUDSReportRecord::generateExtendedData => NULL == pNew"));
                NORMAL_M_ASSERT_ALWAYS();
                return NULL;
             }

      		 break;
      	 }
         default:
         {
            ETG_TRACE_USR1_THR(( "--- vdl_tclUDSReportRecord::generateExtendedData => DTC:%06x  ExtData:%02x NOT FOUND",DTC,recNo));   
            break;
         }
      }// switch(recNo)
      //lint +e764 //switch statement does not have a case
   }// else // if(pReportRecord == NULL)
   return pNew;
}



