//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_report_record_factory.cpp
// PROJECT:      GEN2(Next GEN,MY13)
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog ReportMemory creator class
//
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:
// Date      | Author                       | Modification
// 31.07.12  | BSOT Plischke                | Initial version
// 05.02.16  | gpu2kor                      | fix for NCG3D-6368
// 28.12.18  | mky6kor						| Extended data configuration(RTC-434184)
// 06.11.19  | hgr6kor						| New set of dtc configuration(RTC-651137)
//////////////////////////////////////////////////////////////////////////
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record_factory
   #include <project/framework/vd_diaglog_report_record_factory.h>
   #include <project/framework/vd_diaglog_itc_definition.h>
#endif

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include <vd_diaglog_if.h>

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record_const_data
   #include <common/framework/vd_diaglog_report_record_const_data.h>
#endif


/*********************************************************/
// START OF CONFIGURATION BEGINNS HERE
/*********************************************************/


/*********************************************************/
/* configuration Table informations                      */
/*********************************************************/


/*********************************************************/
// varinat
// System Configuration Defines
/*********************************************************/
#define V_VAR1          0x01


/*********************************************************/
// severity/priority
//
// UNUSED


/*********************************************************/
// enable logging
//
// UNUSED

/*********************************************************/
// Clear allowed
//
// TRUE:  if clear is allowed via clear command
// FALSE: could only be cleared by PASSED event and follwing ageing

/*********************************************************/
// Ageing allowed
//
// TRUE:  if clear is allowed via automatic clearing
// FALSE: could only be cleared by ClearCommand
//
// not supported for GLOBAL Ageing
// works in combination with max age
//
// a)
// m_bAgeingAllowed = false & m_u8MaxAge = e.g.40
// -> age DTC, but do not clear if Max reached
//
// b)
// m_bAgeingAllowed = true & m_u8MaxAge = e.g.40
// -> age DTC and clear if Max reached
//
// c)
// m_bAgeingAllowed = false & m_u8MaxAge = 0
// -> do not age and do not clear
//
// d)
// m_bAgeingAllowed = true & m_u8MaxAge = 0
// -> only valid for one Cycle, clear after this cycle
/*********************************************************/

/*********************************************************/
// Clear on first pass
//
// TRUE:  clear on first pass
// FALSE: do not clear on first pass
/*********************************************************/

/*********************************************************/
// Clear on startup
//
// TRUE:  clear on each startup
// FALSE: do not clear on Startup
/*********************************************************/

/*********************************************************/
// change without debounce
//
// TRUE:  set to FAIL without debouncetime,
//        but HISTORY only after debouncing
// FALSE: set FAIL and HISTORY only after debouncetime
/*********************************************************/

/*********************************************************/
// fail/pass delta
//
// delay Timer [ms] limt tS32 postive only
/*********************************************************/

/*********************************************************/
// max age
//
// only used for DIAGLOG_SINGLE_AGEING
// number of cycles before automatic clearing
// not supported for GLOBAL Ageing
// see also Ageing allowed
/*********************************************************/

/*********************************************************/
// ageingevent
//
// only used for DIAGLOG_SINGLE_AGEING
// trigger to age
// not supported for GLOBAL Ageing
/*********************************************************/
/*********************************************************/
#define AGE_UNUSED                DIAGLOG_AGEING_CYCLE_UNUSED                    // means use the overall handling
#define AGE_IGN_START             DIAGLOG_AGEING_CYCLE_ON_IGNITION_CYCLE_START
#define AGE_IGN_END               DIAGLOG_AGEING_CYCLE_ON_IGNITION_CYCLE_END
#define AGE_OPERATION_START       DIAGLOG_AGEING_CYCLE_ON_OPERATION_CYCLE_START
#define AGE_OPERATION_END         DIAGLOG_AGEING_CYCLE_ON_OPERATION_CYCLE_END
#define AGE_ACC_START             DIAGLOG_AGEING_CYCLE_ON_ACC_CYCLE_START
#define AGE_ACC_END               DIAGLOG_AGEING_CYCLE_ON_ACC_CYCLE_END
#define AGE_EXT_EVENT             DIAGLOG_AGEING_CYCLE_ON_EXTERNAL_EVENT

/*********************************************************/
// BlockingMode
//
// short defines for configuration Table
// Set Flag if must Blocked
/*********************************************************/

/*lint -e750 suppress 750 */
#define BM_STARTUP      DIAGLOG_BLOCKING_MODE_STARTUP_TIMER
#define BM_VO_OUT_RANGE DIAGLOG_BLOCKING_MODE_VOLTAGE_OUT_OF_RANGE
#define BM_PM_NONE      DIAGLOG_BLOCKING_MODE_POWER_NONE
#define BM_PM_OFF       DIAGLOG_BLOCKING_MODE_POWER_OFF
#define BM_PM_ACC       DIAGLOG_BLOCKING_MODE_POWER_ACC
#define BM_PM_RUN       DIAGLOG_BLOCKING_MODE_POWER_RUN
#define BM_PM_CRANK     DIAGLOG_BLOCKING_MODE_POWER_CRANK
#define BM_PM_TIMER     DIAGLOG_BLOCKING_MODE_POWER_CRANK_TIMER
#define BM_VO_TIMER     DIAGLOG_BLOCKING_MODE_VOLTAGE_TIMER
#define BM_DIAG         DIAGLOG_BLOCKING_MODE_DIAGNOSIS
#define BM_PM_RUN_TIMER DIAGLOG_BLOCKING_MODE_POWER_RUN_TIMER
#define BM_HS_COMM      DIAGLOG_BLOCKING_MODE_HS_COMM_ENABLE_NOT_ACTIVE
#define BM_VN_NOTACT    DIAGLOG_BLOCKING_MODE_VN_NOT_ACTIVE
#define BM_NGI_SLEEP    DIAGLOG_BLOCKING_MODE_NGI_SYS_STATE_SLEEP
#define BM_MOST_BUS     DIAGLOG_BLOCKING_MODE_MOST_BUS_NOT_ACTIVE
#define BM_DTC_46       DIAGLOG_BLOCKING_MODE_DTC_B101_46_CURRENT
#define BM_DTC_47       DIAGLOG_BLOCKING_MODE_DTC_B101_47_CURRENT
#define BM_MOST_TIMER   DIAGLOG_BLOCKING_MODE_MOST_TIMER
#define BM_LOGISTIC     DIAGLOG_BLOCKING_MODE_LOGISTIC_MODE
#define BM_IGN_OFF      DIAGLOG_BLOCKING_MODE_IGNITION_OFF

/*********************************************************/
// TestFrequency
//
// currently not used
/*********************************************************/
#define CONTINUOUSLY    DIAGLOG_TEST_FREQ_CONTINUOUSLY
#define AT_STARTUP      DIAGLOG_TEST_FREQ_AT_STARTUP
#define AFTER_DOWNLOAD  DIAGLOG_TEST_FREQ_AFTER_DOWNLOAD
//#define AFTER_CPID_FE DIAGLOG_TEST_FREQ_AFTER_CPID_FE
#define AFTER_DTC_CLEAR DIAGLOG_TEST_FREQ_AFTER_DTC_CLEARING

/*********************************************************/
// Report Type
//
/*********************************************************/
#define BASE    DIAGLOG_REPORT_BASE

/*********************************************************/
//  Extended Data
//
/*********************************************************/
#define XD_NO         DIAGLOG_XD_NO
#define XD_AGE_CTR    DIAGLOG_XD_AGE_COUNTER
#define XD_OCC_CTR    DIAGLOG_XD_OCC_COUNTER
#define XD_MILE       DIAGLOG_XD_MILEAGE
#define XD_STD_ENV    DIAGLOG_XD_STANDARD_ENV
#define XD_ALL        DIAGLOG_XD_ALL_RECORDS

/*********************************************************/
//  SnapShot Data
//
/*********************************************************/
#define SSD_NO          DIAGLOG_SNAPSHOTDATA_NO
#define SSD_MILE_OCC    DIAGLOG_SNAPSHOTDATA_MILEAGE_OCC_COUNTER
//#define SSD_OCC_CTR     DIAGLOG_SNAPSHOTDATA_OCC_COUNTER


/*********************************************************/
//  I-IVI SPEAKER -- DTC BASE NUMBER FOR SPEAKER
//  1/ IN CDD CODE B1Axxyy ==> 9Axxyy DTC CODE  (| 0x800000)
//  2/ IN CDD CODE U02xxyy ==> C2xxyy DTC CODE  (| 0xC00000)
/*********************************************************/
#define DTC_AIVI_FL_DOOR_SPEAKER                                       0x9A0010
#define DTC_AIVI_FL_DOOR_WOOFER                                        0x9A0110
#define DTC_AIVI_FL_DOOR_SQUAWKER                                      0x9A0210
#define DTC_AIVI_FL_DOOR_TWEETER                                       0x9A0310
#define DTC_AIVI_FR_DOOR_SPEAKER                                       0x9A0410
#define DTC_AIVI_FR_DOOR_WOOFER                                        0x9A0510
#define DTC_AIVI_FR_DOOR_SQUAWKER                                      0x9A0610
#define DTC_AIVI_FR_DOOR_TWEETER                                       0x9A0710
#define DTC_AIVI_F_INST_L_SPEAKER                                      0x9A0810
#define DTC_AIVI_F_INST_L_WOOFER                                       0x9A0910
#define DTC_AIVI_F_INST_L_SQUAWKER                                     0x9A0A10
#define DTC_AIVI_F_INST_L_TWEETER                                      0x9A0B10
#define DTC_AIVI_F_INST_C_SPEAKER                                      0x9A0C10
#define DTC_AIVI_F_INST_C_WOOFER                                       0x9A0D10
#define DTC_AIVI_F_INST_C_SQUAWKER                                     0x9A0E10
#define DTC_AIVI_F_INST_C_TWEETER                                      0x9A0F10
#define DTC_AIVI_F_INST_R_SPEAKER                                      0x9A1010
#define DTC_AIVI_F_INST_R_WOOFER                                       0x9A1110
#define DTC_AIVI_F_INST_R_SQUAWKER                                     0x9A1210
#define DTC_AIVI_F_INST_R_TWEETER                                      0x9A1310
#define DTC_AIVI_FL_SEAT_L_SPEAKER                                     0x9A1410
#define DTC_AIVI_FL_SEAT_L_WOOFER                                      0x9A1510
#define DTC_AIVI_FL_SEAT_L_SQUAWKER                                    0x9A1610
#define DTC_AIVI_FL_SEAT_L_TWEETER                                     0x9A1710
#define DTC_AIVI_FL_SEAT_C_SPEAKER                                     0x9A1810
#define DTC_AIVI_FL_SEAT_C_WOOFER                                      0x9A1910
#define DTC_AIVI_FL_SEAT_C_SQUAWKER                                    0x9A1A10
#define DTC_AIVI_FL_SEAT_C_TWEETER                                     0x9A1B10
#define DTC_AIVI_FL_SEAT_R_SPEAKER                                     0x9A1C10
#define DTC_AIVI_FL_SEAT_R_WOOFER                                      0x9A1D10
#define DTC_AIVI_FL_SEAT_R_SQUAWKER                                    0x9A1E10
#define DTC_AIVI_FL_SEAT_R_TWEETER                                     0x9A1F10
#define DTC_AIVI_FR_SEAT_L_SPEAKER                                     0x9A2010
#define DTC_AIVI_FR_SEAT_L_WOOFER                                      0x9A2110
#define DTC_AIVI_FR_SEAT_L_SQUAWKER                                    0x9A2210
#define DTC_AIVI_FR_SEAT_L_TWEETER                                     0x9A2310
#define DTC_AIVI_FR_SEAT_C_SPEAKER                                     0x9A2410
#define DTC_AIVI_FR_SEAT_C_WOOFER                                      0x9A2510
#define DTC_AIVI_FR_SEAT_C_SQUAWKER                                    0x9A2610
#define DTC_AIVI_FR_SEAT_C_TWEETER                                     0x9A2710
#define DTC_AIVI_FR_SEAT_R_SPEAKER                                     0x9A2810
#define DTC_AIVI_FR_SEAT_R_WOOFER                                      0x9A2910
#define DTC_AIVI_FR_SEAT_R_SQUAWKER                                    0x9A2A10
#define DTC_AIVI_FR_SEAT_R_TWEETER                                     0x9A2B10
#define DTC_AIVI_FL_PILLAR_SPEAKER                                     0x9A2C10
#define DTC_AIVI_FL_PILLAR_WOOFER                                      0x9A2D10
#define DTC_AIVI_FL_PILLAR_SQUAWKER                                    0x9A2E10
#define DTC_AIVI_FL_PILLAR_TWEETER                                     0x9A2F10
#define DTC_AIVI_FR_PILLAR_SPEAKER                                     0x9A3010
#define DTC_AIVI_FR_PILLAR_WOOFER                                      0x9A3110
#define DTC_AIVI_FR_PILLAR_SQUAWKER                                    0x9A3210
#define DTC_AIVI_FR_PILLAR_TWEETER                                     0x9A3310
#define DTC_AIVI_F_CONSOLE_C_SPEAKER                                   0x9A3410
#define DTC_AIVI_F_CONSOLE_C_WOOFER                                    0x9A3510
#define DTC_AIVI_F_CONSOLE_C_SQUAWKER                                  0x9A3610
#define DTC_AIVI_F_CONSOLE_C_TWEETER                                   0x9A3710
#define DTC_AIVI_2L_DOOR_SPEAKER                                       0x9A3810
#define DTC_AIVI_2L_DOOR_WOOFER                                        0x9A3910
#define DTC_AIVI_2L_DOOR_SQUAWKER                                      0x9A3A10
#define DTC_AIVI_2L_DOOR_TWEETER                                       0x9A3B10
#define DTC_AIVI_2R_DOOR_SPEAKER                                       0x9A3C10
#define DTC_AIVI_2R_DOOR_WOOFER                                        0x9A3D10
#define DTC_AIVI_2R_DOOR_SQUAWKER                                      0x9A3E10
#define DTC_AIVI_2R_DOOR_TWEETER                                       0x9A3F10
#define DTC_AIVI_2_ROOF_L_SPEAKER                                      0x9A4010
#define DTC_AIVI_2_ROOF_L_WOOFER                                       0x9A4110
#define DTC_AIVI_2_ROOF_L_SQUAWKER                                     0x9A4210
#define DTC_AIVI_2_ROOF_L_TWEETER                                      0x9A4310
#define DTC_AIVI_2_ROOF_C_SPEAKER                                      0x9A4410
#define DTC_AIVI_2_ROOF_C_WOOFER                                       0x9A4510
#define DTC_AIVI_2_ROOF_C_SQUAWKER                                     0x9A4610
#define DTC_AIVI_2_ROOF_C_TWEETER                                      0x9A4710
#define DTC_AIVI_2_ROOF_R_SPEAKER                                      0x9A4810
#define DTC_AIVI_2_ROOF_R_WOOFER                                       0x9A4910
#define DTC_AIVI_2_ROOF_R_SQUAWKER                                     0x9A4A10
#define DTC_AIVI_2_ROOF_R_TWEETER                                      0x9A4B10
#define DTC_AIVI_RL_DOOR_SPEAKER                                       0x9A4C10
#define DTC_AIVI_RL_DOOR_WOOFER                                        0x9A4D10
#define DTC_AIVI_RL_DOOR_SQUAWKER                                      0x9A4E10
#define DTC_AIVI_RL_DOOR_TWEETER                                       0x9A4F10
#define DTC_AIVI_RR_DOOR_SPEAKER                                       0x9A5010
#define DTC_AIVI_RR_DOOR_WOOFER                                        0x9A5110
#define DTC_AIVI_RR_DOOR_SQUAWKER                                      0x9A5210
#define DTC_AIVI_RR_DOOR_TWEETER                                       0x9A5310
#define DTC_AIVI_R_PSHELF_L_SPEAKER                                    0x9A5410
#define DTC_AIVI_R_PSHELF_L_WOOFER                                     0x9A5510
#define DTC_AIVI_R_PSHELF_L_SQUAWKER                                   0x9A5610
#define DTC_AIVI_R_PSHELF_L_TWEETER                                    0x9A5710
#define DTC_AIVI_R_PSHELF_C_SPEAKER                                    0x9A5810
#define DTC_AIVI_R_PSHELF_C_WOOFER                                     0x9A5910
#define DTC_AIVI_R_PSHELF_C_SQUAWKER                                   0x9A5A10
#define DTC_AIVI_R_PSHELF_C_TWEETER                                    0x9A5B10
#define DTC_AIVI_R_PSHELF_R_SPEAKER                                    0x9A5C10
#define DTC_AIVI_R_PSHELF_R_WOOFER                                     0x9A5D10
#define DTC_AIVI_R_PSHELF_R_SQUAWKER                                   0x9A5E10
#define DTC_AIVI_R_PSHELF_R_TWEETER                                    0x9A5F10
#define DTC_AIVI_RL_PILLAR_SPEAKER                                     0x9A6010
#define DTC_AIVI_RL_PILLAR_WOOFER                                      0x9A6110
#define DTC_AIVI_RL_PILLAR_SQUAWKER                                    0x9A6210
#define DTC_AIVI_RL_PILLAR_TWEETER                                     0x9A6310
#define DTC_AIVI_RR_PILLAR_SPEAKER                                     0x9A6410
#define DTC_AIVI_RR_PILLAR_WOOFER                                      0x9A6510
#define DTC_AIVI_RR_PILLAR_SQUAWKER                                    0x9A6610
#define DTC_AIVI_RR_PILLAR_TWEETER                                     0x9A6710
#define DTC_AIVI_R_LUGGAGE_L_SPEAKER                                   0x9A6810
#define DTC_AIVI_R_LUGGAGE_L_WOOFER                                    0x9A6910
#define DTC_AIVI_R_LUGGAGE_L_SQUAWKER                                  0x9A6A10
#define DTC_AIVI_R_LUGGAGE_L_TWEETER                                   0x9A6B10
#define DTC_AIVI_R_LUGGAGE_C_SPEAKER                                   0x9A6C10
#define DTC_AIVI_R_LUGGAGE_C_WOOFER                                    0x9A6D10
#define DTC_AIVI_R_LUGGAGE_C_SQUAWKER                                  0x9A6E10
#define DTC_AIVI_R_LUGGAGE_C_TWEETER                                   0x9A6F10
#define DTC_AIVI_R_LUGGAGE_R_SPEAKER                                   0x9A7010
#define DTC_AIVI_R_LUGGAGE_R_WOOFER                                    0x9A7110
#define DTC_AIVI_R_LUGGAGE_R_SQUAWKER                                  0x9A7210
#define DTC_AIVI_R_LUGGAGE_R_TWEETER                                   0x9A7310
#define DTC_AIVI_R_ROOF_L_SPEAKER                                      0x9A7410
#define DTC_AIVI_R_ROOF_L_WOOFER                                       0x9A7510
#define DTC_AIVI_R_ROOF_L_SQUAWKER                                     0x9A7610
#define DTC_AIVI_R_ROOF_L_TWEETER                                      0x9A7710
#define DTC_AIVI_R_ROOF_C_SPEAKER                                      0x9A7810
#define DTC_AIVI_R_ROOF_C_WOOFER                                       0x9A7910
#define DTC_AIVI_R_ROOF_C_SQUAWKER                                     0x9A7A10
#define DTC_AIVI_R_ROOF_C_TWEETER                                      0x9A7B10
#define DTC_AIVI_R_ROOF_R_SPEAKER                                      0x9A7C10
#define DTC_AIVI_R_ROOF_R_WOOFER                                       0x9A7D10
#define DTC_AIVI_R_ROOF_R_SQUAWKER                                     0x9A7E10
#define DTC_AIVI_R_ROOF_R_TWEETER                                      0x9A7F10
#define DTC_AIVI_B_DOOR_L_SPEAKER                                      0x9A8010
#define DTC_AIVI_B_DOOR_L_WOOFER                                       0x9A8110
#define DTC_AIVI_B_DOOR_L_SQUAWKER                                     0x9A8210
#define DTC_AIVI_B_DOOR_L_TWEETER                                      0x9A8310
#define DTC_AIVI_B_DOOR_C_SPEAKER                                      0x9A8410
#define DTC_AIVI_B_DOOR_C_WOOFER                                       0x9A8510
#define DTC_AIVI_B_DOOR_C_SQUAWKER                                     0x9A8610
#define DTC_AIVI_B_DOOR_C_TWEETER                                      0x9A8710
#define DTC_AIVI_B_DOOR_R_SPEAKER                                      0x9A8810
#define DTC_AIVI_B_DOOR_R_WOOFER                                       0x9A8910
#define DTC_AIVI_B_DOOR_R_SQUAWKER                                     0x9A8A10
#define DTC_AIVI_B_DOOR_R_TWEETER                                      0x9A8B10
#define DTC_AIVI_FRONT_LEFT_DOOR_SPEAKER                               0xD60010
#define DTC_AIVI_FRONT_RIGHT_DOOR_SPEAKER                              0xD60810
#define DTC_AIVI_REAR_LEFT_DOOR_WOOFER                                 0xD70910
#define DTC_AIVI_REAR_RIGHT_DOOR_WOOFER                                0xD71110

/*********************************************************/
//  A-IVI MICROPHONE -- DTC BASE NUMBER FOR BOSE MICROPHONE
//
/*********************************************************/
#define DTC_AIVI_BOSE_ANC_MIC1_CIRC                                    0x9F0B10
#define DTC_AIVI_BOSE_ANC_MIC2_CIRC                                    0x9F1010
#define DTC_AIVI_BOSE_ANC_MIC3_CIRC                                    0x9F1510
#define DTC_AIVI_BOSE_ANC_MIC4_CIRC                                    0x9F1A10

/*********************************************************/
// START OF CONFIGURATION BEGINNS HERE
/*********************************************************/

const trReportRecordData g_oaDtcDefinitionTable[] =
{
// ITC                                                                                                            * DTC            *   report *   variant,  * severity  * warning   * enable   * Clear    * Ageing  * clear on    * clear on  *  change    *   fail  *  pass  * max     * Aging Cycle     * TestFrequency * DTC Block List     	*  Blocking Mode   				* Application-ID                                                     * Freeze Frame Data         * Snapshot Data
//                                                                                                                * (inc. FTB)     *   TYP    *             * priority  * indicator * Logging  * allowed  * allowed * FirstPass   * Startup   *  without   *   delta *  delta * age     *                 *               *                    	*  Blocking Mode   				* for retrigger                                                      *                           * (max Elements
//                                                                                                                *                *          *             *           *           *          *          *         *             *           *  debounce  *   [ms]  *  [ms]  *         *                 *               *                    	*                  				*                                                                    *                           *  or final 0)
//.                                                                                                                                                      
{ITC_HEATCONTROL_AMPLIFIER_CRITICAL_TEMP_HIGH           ,/* ECU Amplifier                                         */ 0x00E0EF,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_HEATCONTROL_CMC_MAIN_PROCESSOR_CRITICAL_TEMP_HIGH  ,/* Main processor                                        */ 0x02E0EF,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_HEATCONTROL_CMC_CO_PROCESSOR_CRITICAL_TEMP_HIGH    ,/* Co processor                                          */ 0x03E0EF,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_HEATCONTROL_DISPLAY_CRITICAL_TEMP_HIGH             ,/* Display                                               */ 0xFFDFEF,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_CMC_VCAN_BUS_OFF                                   ,/* No CAN 1 communication possible                       */ 0x7F0213,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_CMC_MCAN_BUS_OFF                                   ,/* No CAN 2 communication possible                       */ 0x710213,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_CMC_VCAN_TIME_OUT                                  ,/* CAN 1 Time out                                        */ 0x7F0209,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_CMC_MCAN_TIME_OUT                                  ,/* CAN 2 Time out                                        */ 0x710209,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_CMC_ETHERNET_NO_COMMUNICATION                      ,/* Ethernet communication not possible                   */ 0x7C2013,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_SPM_VOLTAGE_BELOW_THRESHOLD                        ,/* Low voltage error              					      */ 0xA80004,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_SPM_VOLTAGE_ABOVE_THRESHOLD                        ,/* High voltage error                                    */ 0xA80003,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AMFM_TUNER1_SYSTEM_FAILURE                         ,/* Tuner AM/FM - initialisation fails                    */ 0x01E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_DAB_TUNER_SYSTEM_FAILURE                           ,/* Tuner DAB - Initialisation error                      */ 0x04E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_BLUETOOTH_SYSTEM_FAILURE                           ,/* Bluetooth - Initialisation error                      */ 0x05E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_AMPLIFIER_INIT_FAILED                          ,/* CMC Amplifier initialisation error                    */ 0x06E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_TUNER_SXM_INIT_FAILED                          ,/* Tuner SXM - initialisation error                      */ 0x07E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_TUNER_HD_RADIO_INIT_FAILED                     ,/* Tuner HD-Radio - initialisation error                 */ 0x08E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_MIC1_SHORT_BAT                                     ,/* External Microphone Signal Line 1 - short to battery  */ 0x0EE0E3,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_MIC1_OPEN                                          ,/* External Microphone Signal Line 1 - open load         */ 0x0EE0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_MIC1_SHORT_GND                                     ,/* External Microphone Signal Line 1 - short to ground   */ 0x0EE0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_MIC2_SHORT_BAT                                     ,/* External Microphone Signal Line 2 - short to battery  */ 0x0FE0E3,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_MIC2_OPEN                                          ,/* External Microphone Signal Line 2 - open load         */ 0x0FE0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_MIC2_SHORT_GND                                     ,/* External Microphone Signal Line 2 - short to ground   */ 0x0FE0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_OVERCURRENT                                   ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_HUB_NOT_DETECTED                              ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_HUB_NUMBER_OF_PORTS_MISMATCH                  ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_OPEN                                          ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_LINK_DISABLED                                 ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_SPEED_REDUCED                                 ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_DATA_LINE_FAULT                               ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_POWER_SUPPLY_FAULT                            ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_SHORT_GND                                     ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_SHORT_BAT                                     ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_SYSTEM_FAILURE,                                /* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB2_OVERCURRENT                                   ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB2_HUB_NOT_DETECTED                              ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB2_HUB_NUMBER_OF_PORTS_MISMATCH                  ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB2_OPEN                                          ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB2_LINK_DISABLED                                 ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB2_SPEED_REDUCED                                 ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB2_DATA_LINE_FAULT                               ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB2_POWER_SUPPLY_FAULT                            ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB2_SHORT_GND                                     ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB2_SHORT_BAT                                     ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB2_SYSTEM_FAILURE,                                /* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_OVERCURRENT                                   ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_HUB_NOT_DETECTED                              ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_HUB_NUMBER_OF_PORTS_MISMATCH                  ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_OPEN                                          ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_LINK_DISABLED                                 ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_SPEED_REDUCED                                 ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_DATA_LINE_FAULT                               ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_POWER_SUPPLY_FAULT                            ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_SHORT_GND                                     ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_SHORT_BAT                                     ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_SYSTEM_FAILURE,                                /* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB4_OVERCURRENT                                   ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB4_HUB_NOT_DETECTED                              ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB4_HUB_NUMBER_OF_PORTS_MISMATCH                  ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB4_OPEN                                          ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB4_LINK_DISABLED                                 ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB4_SPEED_REDUCED                                 ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB4_DATA_LINE_FAULT                               ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB4_POWER_SUPPLY_FAULT                            ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB4_SHORT_GND                                     ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB4_SHORT_BAT                                     ,/* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB4_SYSTEM_FAILURE,                                /* External USB CM-Hub - general failure                 */ 0x10E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_HEATCTRL_FAN_SYSTEM_FAILURE                        ,/* ECU Fan - electronic error                            */ 0x11E0EC,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_STD_ENV,XD_ALL},{SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_CMC_SWITCHABLE_OUTPUT_VOLTAGE_SHORT_TO_BATTERY     ,/* Switchable Output Voltage SW_12V - short to battery   */ 0x12E0E3,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_CMC_SWITCHABLE_OUTPUT_VOLTAGE_SHORT_TO_GROUND      ,/* Switchable Output Voltage SW_12V - short to groung    */ 0x12E0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AMFM_TUNER_ANT1_SHORT_BAT                          ,/* AM/FM1 Antenna - short to battery                     */ 0x0AE0E3,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AMFM_TUNER_ANT1_OPEN                               ,/* AM/FM1/ Antenna - open load                           */ 0x0AE0E5,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AMFM_TUNER_ANT1_SHORT_GND                          ,/* AM/FM1/ Antenna - short to ground                     */ 0x0AE0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DAB_TUNER_ANT1_SHORT_BAT                           ,/* DAB Antenna - short to battery                        */ 0x0AE0E3,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DAB_TUNER_ANT1_OPEN                                ,/*  DAB Antenna - open load                              */ 0x0AE0E5,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DAB_TUNER_ANT1_SHORT_GND                           ,/* DAB Antenna - short to ground                         */ 0x0AE0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_SENSOR_GPS_ANTENNA_OPEN                            ,/* GNSS Antenna - open load                              */ 0x09E0E5,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_SENSOR_GPS_ANTENNA_SHORT_GND                       ,/* GNSS Antenna - short to ground                        */ 0x09E0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AMFM_TUNER_ANT2_SHORT_BAT                          ,/* FM2 Antenna - short to battery                        */ 0x0BE0E3,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AMFM_TUNER_ANT2_OPEN                               ,/* FM2 Antenna - open load                               */ 0x0BE0E5,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AMFM_TUNER_ANT2_SHORT_GND                          ,/* FM2 Antenna - short to ground                         */ 0x0BE0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_XM_TUNER_ANT1_SHORT_BAT                            ,/* SXM Antenna - short to battery                        */ 0x0CE0E3,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_XM_TUNER_ANT1_OPEN                                 ,/* SXM Antenna - open load                               */ 0x0CE0E5,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_XM_TUNER_ANT1_SHORT_GND                            ,/* SXM Antenna - short to ground                         */ 0x0CE0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AUDIO_SPK_RF_CIRCUIT_SHORT_VSS                     ,/* Front Right Speaker Output - short to battery         */ 0x13E0E3,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AUDIO_SPK_RF_CIRCUIT_SHORT_ACROSS                  ,/* Front Right Speaker Output - short +/- lines          */ 0x13E0E4,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AUDIO_SPK_RF_CIRCUIT_INTERRUPTED                   ,/* Front Right Speaker Output - open load                */ 0x13E0E5,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AUDIO_SPK_RF_CIRCUIT_SHORT_GND                     ,/* Front Right Speaker Output - short to ground          */ 0x13E0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AUDIO_SPK_LF_CIRCUIT_SHORT_VSS                     ,/* Front Left Speaker Output - short to battery          */ 0x14E0E3,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AUDIO_SPK_LF_CIRCUIT_SHORT_ACROSS                  ,/* Front Left Speaker Output - short +/- lines           */ 0x14E0E4,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AUDIO_SPK_LF_CIRCUIT_INTERRUPTED                   ,/* Front Left Speaker Output - open load                 */ 0x14E0E5,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AUDIO_SPK_LF_CIRCUIT_SHORT_GND						,/* Front Left Speaker Output - short to ground           */ 0x14E0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_CMC_MCP_HOMEBUTTON_KEY_JAM							,/* HOMEBUTTON - key jam                                  */ 0x17E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_HOME_COCKPIT_KEY_JAM						,/* MCP_HOME_COCKPIT - key jam                            */ 0x18E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_SRC_COCKPIT_KEY_JAM						,/* MCP_SRC_COCKPIT - key jam                             */ 0x19E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_NAV_KEY_JAM								,/* MCP_NAV - key jam                                     */ 0x1AE0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_MAP_KEY_JAM								,/* MCP_MAP - key jam                                     */ 0x1BE0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_SRC_CABIN_KEY_JAM							,/* MCP_SRC_CABIN - key jam                               */ 0x1CE0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_HOME_CABIN_KEY_JAM							,/* MCP_HOME_CABIN - key jam                              */ 0x1DE0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_SET_COCKPIT_KEY_JAM						,/* MCP_SET_COCKPIT - key jam                             */ 0x1EE0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_CAM_KEY_JAM								,/* MCP_CAM - key jam                                     */ 0x1FE0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_PHONE_ACCEPT_KEY_JAM						,/* MCP_PHONE_ACCEPT - key jam                            */ 0x20E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_PHONE_REJECT_KEY_JAM						,/* MCP_PHONE_REJECT - key jam                            */ 0x21E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_MON_KEY_JAM								,/* MCP_MON - key jam                                     */ 0x22E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_SET_CABIN_KEY_JAM							,/* MCP_SET_CABIN - key jam                               */ 0x23E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_VOLUMEBUTTON_COCKPIT_KEY_JAM				,/* VolumeButton_COCKPIT - key jam                        */ 0x24E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_VOLUMEBUTTON_CABIN_KEY_JAM					,/* VolumeButton_CABIN - key jaam                         */ 0x25E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_HOMEBUTTON_ILLUMINATION_ERROR				,/* AMBER LED of HOMEBUTTON - illumination error          */ 0x26E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_HOME_COCKPIT_ILLUMINATION_ERROR			,/* RGBW  LED of MCP_HOME_COCKPIT - illumination error    */ 0x27E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_SRC_COCKPIT_ILLUMINATION_ERROR				,/* RGBW  LED of MCP_SRC_COCKPIT - illumination error     */ 0x28E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_NAV_ILLUMINATION_ERROR						,/* RGBW  LED of MCP_NAV - illumination error             */ 0x29E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_MAP_ILLUMINATION_ERROR						,/* RGBW  LED of MCP_MAP - illumination error             */ 0x2AE0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_SRC_CABIN_ILLUMINATION_ERROR				,/* RGBW  LED of MCP_SRC_CABIN - illumination error       */ 0x2BE0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_HOME_CABIN_ILLUMINATION_ERROR				,/* RGBW  LED of MCP_HOME_CABIN - illumination error      */ 0x2CE0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_SET_COCKPIT_ILLUMINATION_ERROR				,/* RGBW  LED of MCP_SET_COCKPIT - illumination error     */ 0x2DE0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_CAM_ILLUMINATION_ERROR						,/* RGBW  LED of MCP_CAM - illumination error             */ 0x2EE0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_PHONE_ACCEPT_ILLUMINATION_ERROR			,/* RGBW  LED of MCP_PHONE_ACCEPT - illumination error    */ 0x2FE0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_PHONE_REJECT_ILLUMINATION_ERROR			,/* RGBW  LED of MCP_PHONE_REJECT - illumination error    */ 0x30E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_MON_ILLUMINATION_ERROR						,/* RGBW  LED of MCP_MON - illumination error             */ 0x31E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_SET_CABIN_ILLUMINATION_ERROR				,/* RGBW  LED of MCP_SET_CABIN - illumination error       */ 0x32E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_VOLUMEBUTTON_COCKPIT_ILLUMINATION_ERROR 	,/* RGBW  LED of VolumeButton_COCKPIT -illumination error */ 0x33E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_MCP_VOLUMEBUTTON_CABIN_ILLUMINATION_ERROR 		,/* RGBW  LED of VolumeButton_CABIN   -illumination error */ 0x34E0E2,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_CABINOUTPUT_SHORT_TO_BATTERY			    	,/* Cabin Output - short to battery                       */ 0x15E0E3,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_CABINOUTPUT_SHORT_TO_LINES				    	,/* Cabin Output - short +/- lines                        */ 0x15E0E4,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_CABINOUTPUT_SHORT_TO_LOAD				    	,/* Cabin Output - open load                              */ 0x15E0E5,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_CABINOUTPUT_SHORT_TO_GROUND				    ,/* Cabin Output - short to groun                         */ 0x15E0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_PRIVATESPEAKER_OUTPUT_SHORT_TO_BATTERY			,/* Private Speaker Output - short to battery             */ 0x16E0E3,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_PRIVATESPEAKER_OUTPUT_SHORT_TO_LINES			,/* Private Speaker Output - short +/- lines              */ 0x16E0E4,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_PRIVATESPEAKER_OUTPUT_SHORT_TO_LOAD			,/* Private Speaker Output - open load                    */ 0x16E0E5,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_CMC_PRIVATESPEAKER_OUTPUT_SHORT_TO_GROUND		 	,/* Private Speaker Output - short to ground              */ 0x16E0E6,       BASE,     V_VAR1,       1,         false,       true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_STD_ENV,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },

//{ITC_DAB_TUNER_ANT1_SHORT_GND,               /* DAB antenna connection abnormality     */ 0x930311,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DAB_TUNER_ANT1_SHORT,                   /* DAB antenna connection abnormality     */ 0x930311,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DAB_TUNER_ANT1_OPEN,                    /* DAB antenna connection abnormality     */ 0x930313,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_DAB_TUNER_SYSTEM_FAILURE,               /* Tuner DAB                              */ 0x930349,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{0x0000,                                     /* Control unit internal error            */ 0x930504,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_BCAS_COMM_FAILURE,                 /* B-CAS communication error              */ 0x930602,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AMPLIFIER_ON_SHORT_GND,                 /* System ON                              */ 0x930911,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AMPLIFIER_ON_SHORT_BAT,                 /* System ON                              */ 0x930912,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AMPLIFIER_ON_OPEN,                      /* System ON                              */ 0x930913,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_RR_CIRCUIT_SHORT_GND,         /* Rear right loudspeaker output          */ 0x930B11,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_RR_CIRCUIT_SHORT_VSS,         /* Rear right loudspeaker output          */ 0x930B12,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_RR_CIRCUIT_INTERRUPTED,       /* Rear right loudspeaker output          */ 0x930B13,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_RR_CIRCUIT_SHORT_ACROSS,      /* Rear right loudspeaker output          */ 0x930B1C,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_RF_CIRCUIT_SHORT_GND,         /* Front right loudspeaker output         */ 0x930D11,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_RF_CIRCUIT_SHORT_VSS,         /* Front right loudspeaker output         */ 0x930D12,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_RF_CIRCUIT_INTERRUPTED,       /* Front right loudspeaker output         */ 0x930D13,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}             },
//{ITC_AUDIO_SPK_RF_CIRCUIT_SHORT_ACROSS,      /* Front right loudspeaker output         */ 0x930D1C,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_LF_CIRCUIT_SHORT_GND,         /* Front left loudspeaker output          */ 0x930F11,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_LF_CIRCUIT_SHORT_VSS,         /* Front left loudspeaker output          */ 0x930F12,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_LF_CIRCUIT_INTERRUPTED,       /* Front left loudspeaker output          */ 0x930F13,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}             },
//{ITC_AUDIO_SPK_LF_CIRCUIT_SHORT_ACROSS,      /* Front left loudspeaker output          */ 0x930F1C,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_TCU_COM_ERR,                  /* AV Communication                       */ 0xD30001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_BOSE_COM_ERR,                 /* AV Communication                       */ 0xD30001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_METER_AUD_COM_ERR,            /* AV Communication                       */ 0xD30001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_METER_SWC_COM_ERR,            /* AV Communication                       */ 0xD30001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_METER_NAV_COM_ERR,            /* AV Communication                       */ 0xD30001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_METER_NAV_GEN2_COM_ERR,       /* AV Communication                       */ 0xD30001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_BUS_OFF,                      /* AV Communication                       */ 0xD30001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_RSE_COM_ERR,                  /* AV Communication                       */ 0xD30001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_AVM_COM_ERR,                  /* AV Communication                       */ 0xD30001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_AMP_COM_ERR,                  /* AV Communication                       */ 0xD30001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_SWITCH_COM_ERR,               /* AV Communication                       */ 0xD30001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_REAR_SW_COM_ERR,              /* AV Communication                       */ 0xD30001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_IT_COMM_COM_ERR,              /* AV Communication                       */ 0xD30001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_LR_CIRCUIT_SHORT_GND,         /* Rear left loudspeaker output           */ 0x931111,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_LR_CIRCUIT_SHORT_VSS,         /* Rear left loudspeaker output           */ 0x931112,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_LR_CIRCUIT_INTERRUPTED,       /* Rear left loudspeaker output           */ 0x931113,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_SPK_LR_CIRCUIT_SHORT_ACROSS,      /* Rear left loudspeaker output           */ 0x93111C,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AMFM_TUNER_ANT1_SHORT,                  /* AM/FM 1 antenna supply                 */ 0x931511,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AMFM_TUNER_ANT1_OPEN,                   /* AM/FM 1 antenna supply                 */ 0x931513,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AMFM_TUNER_ANT2_SHORT,                  /* FM 2 antenna supply                    */ 0x931611,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AMFM_TUNER_ANT2_OPEN,                   /* FM 2 antenna supply                    */ 0x931613,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_XM_TUNER_ANT1_SHORT_GND,                /* SXM antenna connection abnormality     */ 0x931711,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_XM_TUNER_ANT1_OPEN,                     /* SXM antenna connection abnormality     */ 0x931713,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AUDIO_SUBWOOFER_CIRCUIT_SHORT_GND,      /* Audio subwoofer ON output              */ 0x931911,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AUDIO_SUBWOOFER_CIRCUIT_SHORT_VSS,      /* Audio subwoofer ON output              */ 0x931912,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AUDIO_SUBWOOFER_CIRCUIT_INTERRUPTED,    /* Audio subwoofer ON output              */ 0x931913,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_TWEETER_RR_CIRCUIT_INTERRUPTED,   /* Rear right tweeter output              */ 0x932013,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_TWEETER_RF_CIRCUIT_INTERRUPTED,   /* Front right tweeter output             */ 0x932113,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_TWEETER_LF_CIRCUIT_INTERRUPTED,   /* Front left tweeter output              */ 0x932213,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUDIO_TWEETER_LR_CIRCUIT_INTERRUPTED,   /* Rear left tweeter output               */ 0x932313,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_MIC1_SHORT_GND,                         /* External Microphone supply  1          */ 0x932811,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                      {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_MIC1_SHORT_BAT,                         /* External Microphone supply  1          */ 0x932812,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                      {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_MIC1_OPEN,                              /* External Microphone supply  1          */ 0x932813,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,      40000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE|BM_IGN_OFF     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_AUDIO,                {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_MIC2_SHORT_GND,                         /* External Microphone supply  2          */ 0x932911,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_MIC2_SHORT_BAT,                         /* External Microphone supply  2          */ 0x932912,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_MIC2_OPEN,                              /* External Microphone supply  2          */ 0x932913,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                      {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_SHORT_GND,                         /* MCH1 external USB                      */ 0x932A01,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_SHORT_BAT,                         /* MCH1 external USB                      */ 0x932A01,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_OVERCURRENT,                       /* MCH1 external USB                      */ 0x932A01,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_HUB_NOT_DETECTED,                  /* MCH1 external USB                      */ 0x932A13,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_USB1_SYSTEM_FAILURE,                    /* MCH1 external USB Controller           */ 0x932A49,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB1_LINK_DISABLED,                     /* MCH1 external USB                      */ 0x93D98F,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_SHORT_GND,                         /* TCU external USB                       */ 0x932C01,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_SHORT_BAT,                         /* TCU external USB                       */ 0x932C01,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_USB3_OVERCURRENT,                       /* TCU external USB                       */ 0x932C01,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_USB_TCU_OPEN,                      /* TCU external USB                       */ 0x932C13,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_USB3_SYSTEM_FAILURE,                    /* TCU external USB Controller            */ 0x932C49,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_USB_TCU_COM_ERR,                   /* TCU external USB                       */ 0x93E58F,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_DEVICEMANAGER,              {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{0x0000,                                     /* ETC connection abnormality             */ 0x932D02,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AUX_INPUT_1_OPEN,                       /* MCH1 External Aux IN                   */ 0x933213,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DTV_ANT1_SHORT_GND,                     /* D-TV antenna 1 connection abnormality  */ 0x933311,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_DTV_ANT1_SHORT_BAT,                   /* D-TV antenna 1 connection abnormality  */ 0x933312,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DTV_ANT1_OPEN,                          /* D-TV antenna 1 connection abnormality  */ 0x933313,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DTV_ANT2_SHORT_GND,                     /* D-TV antenna 2 connection abnormality  */ 0x933411,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_DTV_ANT2_SHORT_BAT,                   /* D-TV antenna 2 connection abnormality  */ 0x933412,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DTV_ANT2_OPEN,                          /* D-TV antenna 2 connection abnormality  */ 0x933413,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DTV_ANT3_SHORT_GND,                     /* D-TV antenna 3 connection abnormality  */ 0x933511,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_DTV_ANT3_SHORT_BAT,                   /* D-TV antenna 3 connection abnormality  */ 0x933512,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DTV_ANT3_OPEN,                          /* D-TV antenna 3 connection abnormality  */ 0x933513,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DTV_ANT4_SHORT_GND,                     /* D-TV antenna 4 connection abnormality  */ 0x933611,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_DTV_ANT4_SHORT_BAT,                   /* D-TV antenna 4 connection abnormality  */ 0x933612,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DTV_ANT4_OPEN,                          /* D-TV antenna 4 connection abnormality  */ 0x933613,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_EXT_DTV_UART_COM_ERR,              /* D-TV UART communication Failure        */ 0x937B02,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DTV_BOX_OVERCURRENT, 				 /* D-TV Pwer supply Overcurrent Failure   */ 0x937C19,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_VIDEO_NO_SIGNAL,                        /* CVBS IN rear cam line                  */ 0x93398F,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_VIDEO_AVM_NO_SIGNAL,                    /* CVBS IN AVM line                       */ 0x933A8F,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_BEACON_UNIT_COMM_FAILURE,          /* Beacon unit connection abnormality     */ 0x933B02,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_AMP_UNIT_COMM_FAILURE,             /* AMP connection abnormality             */ 0x933C02,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_AMP_UNIT_CH1_COMM_FAILURE,         /* AMP connection abnormality             */ 0x933C02,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_AMP_UNIT_CH2_COMM_FAILURE,         /* AMP connection abnormality             */ 0x933C02,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_SPM_VOLTAGE_BELOW_THRESHOLD,            /* Low voltage error                      */ 0x934116,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,      15000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_SPM_VOLTAGE_ABOVE_THRESHOLD,            /* High voltage error                     */ 0x934117,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_ECU_INTERNAL_FAILURE,                   /* H/U Internal Electronic Failure        */ 0x934149,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_DIAG_CUSTOMER1_CONFIG_INVALID,          /* Configuration error Nissan             */ 0x934155,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_DIAG_CUSTOMER2_CONFIG_INVALID,          /* Configuration error Renault            */ 0x93EC55,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_HEATCONTROL_SYSTEM_CRITICAL_TEMP_HIGH , /* H/U High temperature                   */ 0x934198,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_SECURITY_DEVICE_LOCKED,                 /* Locked ECU                             */ 0x934262,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_ECU_ROM_DEFECT,                         /* ECU Rom                                */ 0x934341,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_SENSOR_GYROSCOPE_SYSTEM_FAILURE,        /* ECU Gyro                               */ 0x934549,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_SENSOR_GPS_ANTENNA_SHORT,               /* GNSS antenna                           */ 0x934611,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_SENSOR_GPS_ANTENNA_OPEN,                /* GNSS antenna                           */ 0x934613,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_TUNERMASTER,                {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_SENSOR_GPS_MODULE_SYSTEM_FAILURE,       /* GNSS antenna                           */ 0x934649,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_BLUETOOTH_SYSTEM_FAILURE,               /* ECU Bluetooth module                   */ 0x934749,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_BLUETOOTH,                  {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{0x0000,                                     /* ECU DSP                                */ 0x935649,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_HEATCTRL_FAN_SYSTEM_FAILURE,            /* ECU Fan                                */ 0x935E49,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_FC_HEATCTRL,                {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_METER_AUD_ERROR,              /* Cluster meter connection abnormality   */ 0x936002,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_METER_SWC_ERROR,              /* Cluster meter connection abnormality   */ 0x936002,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_METER_NAV_ERROR,              /* Cluster meter connection abnormality   */ 0x936002,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_MCAN_METER_NAV_GEN2_ERROR,         /* Cluster meter connection abnormality   */ 0x936002,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{0x0000,                                     /* Media Box connection abnormality       */ 0x936602,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_CD_DRIVE_OVERTEMP,                      /* External CD drive                      */ 0x936C4B,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_CD_LCW_CD_DRIVE,                        /* External CD drive                      */ 0x936C8F,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2ND_DISPLAY_CONN_ERROR,            /* 2nd Display Connection abnormality     */ 0x937002,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RSE_CONN_ERROR,                    /* RSE  connection abnormality            */ 0x937102,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_REAR_SWITCH_CONN_ERROR,            /* RearSwitch connection abnormality      */ 0x937202,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_INTEGRATED_SWITCH_CONN_ERROR,     /* Integrated Switch connection abnormality*/ 0x937A02,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_VIDEO_RVC_SHORT_GND,                    /* Rear camera Power supply               */ 0x937511,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_VIDEO_RVC_SHORT_BAT,                    /* Rear camera Power supply               */ 0x937512,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_VIDEO_RVC_OPEN,                         /* Rear camera Power supply               */ 0x937513,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ETC_SELF_DIAGNOSIS_FAILURE,        /* ETC self-diagnosis abnormality         */ 0x938196,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE,/* 2nd Display self-diagnosis abnormality */ 0x938496,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_BACKLIGHT,/* 2nd Display self-diagnosis abnormality */ 0x938496,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_ROM,      /* 2nd Display self-diagnosis abnormality */ 0x938496,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_TFT,      /* 2nd Display self-diagnosis abnormality */ 0x938496,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_LVDS,     /* 2nd Display self-diagnosis abnormality */ 0x938496,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_TOUCH,    /* 2nd Display self-diagnosis abnormality */ 0x938496,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_BUTTONS,  /* 2nd Display self-diagnosis abnormality */ 0x938496,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_HVAC,     /* 2nd Display self-diagnosis abnormality */ 0x938496,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2ND_DISPLAY_SELF_DIAGNOSIS_FAILURE_IT_COMM,  /* 2nd Display self-diagnosis abnormality */ 0x938496,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_WIFI_SYSTEM_FAILURE,                    /* ECU Wifi module                        */ 0x938049,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_BOSE_AMP_TEMP_ERROR,               /* Amp temperature up                     */ 0x938298,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANGLE_SENSOR_CALIBRATION,          /* Angle sensor calibration               */ 0x938301,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RSE_RR_DISP_UNIT_ERROR,            /* Rear Right Display self-diagnosis abn. */ 0x93C102,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RSE_RL_DISP_UNIT_ERROR,            /* Rear Left Display self-diagnosis abn.  */ 0x93C202,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RSE_RR_DISP_HIGH_TEMP,             /* Rear Right Display High temperature    */ 0x93C398,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RSE_RL_DISP_HIGH_TEMP,             /* Rear Left Display High temperature     */ 0x93C498,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RSE_UNIT_ERROR,                    /* RSE self-diagnosis abnormality         */ 0x93C596,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RSE_HIGH_TEMP,                     /* RSE High temperature                   */ 0x93C698,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_RSE_AUDIO,                         /* Audio in RSE                          */ 0x93AF8F,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_FAC_SETUP,                     /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_FAC_SOUND,                     /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_FAC_LEFT_ENC,                  /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_FAC_RADIO,                     /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_FAC_MEDIA,                     /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_FAC_MENU,                      /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_FAC_CAR,                       /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_FAC_MUTE,                      /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_FAC_PHONE,                     /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_FAC_EJECT,                     /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_FAC_AM_FM,                     /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_DEV_FACEPLATE,                 /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_DEV_SWC,                       /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_DEV_POWER,                     /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_KEY_DEV_EJECT,                     /* ECU Buttons                            */ 0x93CF73,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,     600000,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+1,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_BUS_OFF,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_MUTE_ERROR,                   /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_ABSENT_ECM,                   /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+5,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_ABSENT_CLUSTER,               /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_ABSENT_BCM,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+8,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+9,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+10,                     /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+11,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+12,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_ABSENT_ITM,                    /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+14,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+15,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+16,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_ABSENT_STRG,                   /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+18,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+19,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+20,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+21,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+22,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_ABSENT_USM,                    /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+24,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+25,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+26,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+27,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+28,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+29,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+30,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+31,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+32,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+33,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+34,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+35,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+36,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+37,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+38,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+39,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+40,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+41,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+42,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_VCAN_START+43,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_ABSENT_SBW_GEN3,               /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_ABSENT_SONAR,                  /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+45,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+46,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+47,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+48,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+49,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+50,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_ABSENT_HCM,                    /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+52,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+53,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+54,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+55,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+56,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+57,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+58,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+59,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+60,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+61,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+62,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+63,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+64,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+65,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+66,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+67,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+68,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+69,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+70,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+71,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+72,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+73,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+74,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+75,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+76,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+77,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+78,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+79,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+80,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+81,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+82,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+83,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+84,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+85,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_ABSENT_AVM,                    /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_VCAN_AVM_COM_ERR,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+87,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_VCAN_ABSENT_SBW,                    /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_ABSENT_SBW_GEN5,               /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+89,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+90,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+91,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+92,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+93,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+94,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+95,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+96,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+97,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+98,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+99,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+100,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+101,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+102,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+103,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+104,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+105,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+106,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+107,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+108,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+109,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+110,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+111,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+112,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+113,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+114,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+115,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+116,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+117,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+118,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+119,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+120,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+121,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+122,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+123,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+124,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+125,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+126,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+127,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+128,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+129,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+130,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+131,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+132,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+133,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+134,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+135,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+136,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+137,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+138,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+139,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_VCAN_START+140,                      /* CAN communication                      */ 0xD00001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | CCA_C_U16_APP_VD_VEHICLE_DATA,            {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_EXT_DTV_LVDS_SERIALIZER_COM_FAILURE, /* LVDS Serializer                        */ 0x93DD49,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DSRC_UNIT_COMM_FAILURE,            /* DSRC unit connection abnormality       */ 0x93DF02,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_CD_DRIVE_ELECTRONIC_FAILURE,            /* External CD drive disc                 */ 0x936849,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_MIC_ANC1_SHORT_GND,                     /* ANC Microphone supply 1                */ 0x93EB11,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,      {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_MIC_ANC1_SHORT_BAT,                     /* ANC Microphone supply 1                */ 0x93EB12,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,      {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_MIC_ANC1_OPEN,                          /* ANC Microphone supply 1                */ 0x93EB13,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,      {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_MIC_ANC2_SHORT_GND,                     /* ANC Microphone supply 2                */ 0x93EC11,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,      {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_MIC_ANC2_SHORT_BAT,                     /* ANC Microphone supply 2                */ 0x93EC12,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,      {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_MIC_ANC2_OPEN,                          /* ANC Microphone supply 2                */ 0x93EC13,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,      {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_MIC_ANC2_SHORT_GND,                     /* ANC Microphone supply 3                */ 0x93ED11,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,      {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_MIC_ANC2_SHORT_BAT,                     /* ANC Microphone supply 3                */ 0x93ED12,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,      {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_MIC_ANC2_OPEN,                          /* ANC Microphone supply 3                */ 0x93ED13,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,      {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//
//{ITC_AIVI_FACTORY_MODE,                      /* Factory Mode                           */ 0x93EC52,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//
//{ITC_AIVI_FL_DOOR_SPEAKER          +SHORT2GND,   DTC_AIVI_FL_DOOR_SPEAKER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_SPEAKER          +SHORT2BAT,   DTC_AIVI_FL_DOOR_SPEAKER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_SPEAKER          +OPEN_LOAD,   DTC_AIVI_FL_DOOR_SPEAKER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_SPEAKER          +SHORT_CIR,   DTC_AIVI_FL_DOOR_SPEAKER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_WOOFER           +SHORT2GND,   DTC_AIVI_FL_DOOR_WOOFER          +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_WOOFER           +SHORT2BAT,   DTC_AIVI_FL_DOOR_WOOFER          +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_WOOFER           +OPEN_LOAD,   DTC_AIVI_FL_DOOR_WOOFER          +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_WOOFER           +SHORT_CIR,   DTC_AIVI_FL_DOOR_WOOFER          +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_SQUAWKER         +SHORT2GND,   DTC_AIVI_FL_DOOR_SQUAWKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_SQUAWKER         +SHORT2BAT,   DTC_AIVI_FL_DOOR_SQUAWKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_SQUAWKER         +OPEN_LOAD,   DTC_AIVI_FL_DOOR_SQUAWKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_SQUAWKER         +SHORT_CIR,   DTC_AIVI_FL_DOOR_SQUAWKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_TWEETER          +SHORT2GND,   DTC_AIVI_FL_DOOR_TWEETER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_TWEETER          +SHORT2BAT,   DTC_AIVI_FL_DOOR_TWEETER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_TWEETER          +OPEN_LOAD,   DTC_AIVI_FL_DOOR_TWEETER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_DOOR_TWEETER          +SHORT_CIR,   DTC_AIVI_FL_DOOR_TWEETER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_SPEAKER          +SHORT2GND,   DTC_AIVI_FR_DOOR_SPEAKER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_SPEAKER          +SHORT2BAT,   DTC_AIVI_FR_DOOR_SPEAKER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_SPEAKER          +OPEN_LOAD,   DTC_AIVI_FR_DOOR_SPEAKER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_SPEAKER          +SHORT_CIR,   DTC_AIVI_FR_DOOR_SPEAKER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_WOOFER           +SHORT2GND,   DTC_AIVI_FR_DOOR_WOOFER          +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_WOOFER           +SHORT2BAT,   DTC_AIVI_FR_DOOR_WOOFER          +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_WOOFER           +OPEN_LOAD,   DTC_AIVI_FR_DOOR_WOOFER          +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_WOOFER           +SHORT_CIR,   DTC_AIVI_FR_DOOR_WOOFER          +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_SQUAWKER         +SHORT2GND,   DTC_AIVI_FR_DOOR_SQUAWKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_SQUAWKER         +SHORT2BAT,   DTC_AIVI_FR_DOOR_SQUAWKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_SQUAWKER         +OPEN_LOAD,   DTC_AIVI_FR_DOOR_SQUAWKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_SQUAWKER         +SHORT_CIR,   DTC_AIVI_FR_DOOR_SQUAWKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_TWEETER          +SHORT2GND,   DTC_AIVI_FR_DOOR_TWEETER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_TWEETER          +SHORT2BAT,   DTC_AIVI_FR_DOOR_TWEETER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_TWEETER          +OPEN_LOAD,   DTC_AIVI_FR_DOOR_TWEETER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_DOOR_TWEETER          +SHORT_CIR,   DTC_AIVI_FR_DOOR_TWEETER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_SPEAKER         +SHORT2GND,   DTC_AIVI_F_INST_L_SPEAKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_SPEAKER         +SHORT2BAT,   DTC_AIVI_F_INST_L_SPEAKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_SPEAKER         +OPEN_LOAD,   DTC_AIVI_F_INST_L_SPEAKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_SPEAKER         +SHORT_CIR,   DTC_AIVI_F_INST_L_SPEAKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_WOOFER          +SHORT2GND,   DTC_AIVI_F_INST_L_WOOFER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_WOOFER          +SHORT2BAT,   DTC_AIVI_F_INST_L_WOOFER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_WOOFER          +OPEN_LOAD,   DTC_AIVI_F_INST_L_WOOFER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_WOOFER          +SHORT_CIR,   DTC_AIVI_F_INST_L_WOOFER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_SQUAWKER        +SHORT2GND,   DTC_AIVI_F_INST_L_SQUAWKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_SQUAWKER        +SHORT2BAT,   DTC_AIVI_F_INST_L_SQUAWKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_SQUAWKER        +OPEN_LOAD,   DTC_AIVI_F_INST_L_SQUAWKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_SQUAWKER        +SHORT_CIR,   DTC_AIVI_F_INST_L_SQUAWKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_TWEETER         +SHORT2GND,   DTC_AIVI_F_INST_L_TWEETER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_TWEETER         +SHORT2BAT,   DTC_AIVI_F_INST_L_TWEETER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_TWEETER         +OPEN_LOAD,   DTC_AIVI_F_INST_L_TWEETER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_L_TWEETER         +SHORT_CIR,   DTC_AIVI_F_INST_L_TWEETER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_SPEAKER         +SHORT2GND,   DTC_AIVI_F_INST_C_SPEAKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_SPEAKER         +SHORT2BAT,   DTC_AIVI_F_INST_C_SPEAKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_SPEAKER         +OPEN_LOAD,   DTC_AIVI_F_INST_C_SPEAKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_SPEAKER         +SHORT_CIR,   DTC_AIVI_F_INST_C_SPEAKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_WOOFER          +SHORT2GND,   DTC_AIVI_F_INST_C_WOOFER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_WOOFER          +SHORT2BAT,   DTC_AIVI_F_INST_C_WOOFER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_WOOFER          +OPEN_LOAD,   DTC_AIVI_F_INST_C_WOOFER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_WOOFER          +SHORT_CIR,   DTC_AIVI_F_INST_C_WOOFER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_SQUAWKER        +SHORT2GND,   DTC_AIVI_F_INST_C_SQUAWKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_SQUAWKER        +SHORT2BAT,   DTC_AIVI_F_INST_C_SQUAWKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_SQUAWKER        +OPEN_LOAD,   DTC_AIVI_F_INST_C_SQUAWKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_SQUAWKER        +SHORT_CIR,   DTC_AIVI_F_INST_C_SQUAWKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_TWEETER         +SHORT2GND,   DTC_AIVI_F_INST_C_TWEETER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_TWEETER         +SHORT2BAT,   DTC_AIVI_F_INST_C_TWEETER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_TWEETER         +OPEN_LOAD,   DTC_AIVI_F_INST_C_TWEETER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_C_TWEETER         +SHORT_CIR,   DTC_AIVI_F_INST_C_TWEETER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_SPEAKER         +SHORT2GND,   DTC_AIVI_F_INST_R_SPEAKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_SPEAKER         +SHORT2BAT,   DTC_AIVI_F_INST_R_SPEAKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_SPEAKER         +OPEN_LOAD,   DTC_AIVI_F_INST_R_SPEAKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_SPEAKER         +SHORT_CIR,   DTC_AIVI_F_INST_R_SPEAKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_WOOFER          +SHORT2GND,   DTC_AIVI_F_INST_R_WOOFER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_WOOFER          +SHORT2BAT,   DTC_AIVI_F_INST_R_WOOFER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_WOOFER          +OPEN_LOAD,   DTC_AIVI_F_INST_R_WOOFER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_WOOFER          +SHORT_CIR,   DTC_AIVI_F_INST_R_WOOFER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_SQUAWKER        +SHORT2GND,   DTC_AIVI_F_INST_R_SQUAWKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_SQUAWKER        +SHORT2BAT,   DTC_AIVI_F_INST_R_SQUAWKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_SQUAWKER        +OPEN_LOAD,   DTC_AIVI_F_INST_R_SQUAWKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_SQUAWKER        +SHORT_CIR,   DTC_AIVI_F_INST_R_SQUAWKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_TWEETER         +SHORT2GND,   DTC_AIVI_F_INST_R_TWEETER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_TWEETER         +SHORT2BAT,   DTC_AIVI_F_INST_R_TWEETER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_TWEETER         +OPEN_LOAD,   DTC_AIVI_F_INST_R_TWEETER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_INST_R_TWEETER         +SHORT_CIR,   DTC_AIVI_F_INST_R_TWEETER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_SPEAKER        +SHORT2GND,   DTC_AIVI_FL_SEAT_L_SPEAKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_SPEAKER        +SHORT2BAT,   DTC_AIVI_FL_SEAT_L_SPEAKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_SPEAKER        +OPEN_LOAD,   DTC_AIVI_FL_SEAT_L_SPEAKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_SPEAKER        +SHORT_CIR,   DTC_AIVI_FL_SEAT_L_SPEAKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_WOOFER         +SHORT2GND,   DTC_AIVI_FL_SEAT_L_WOOFER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_WOOFER         +SHORT2BAT,   DTC_AIVI_FL_SEAT_L_WOOFER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_WOOFER         +OPEN_LOAD,   DTC_AIVI_FL_SEAT_L_WOOFER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_WOOFER         +SHORT_CIR,   DTC_AIVI_FL_SEAT_L_WOOFER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_SQUAWKER       +SHORT2GND,   DTC_AIVI_FL_SEAT_L_SQUAWKER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_SQUAWKER       +SHORT2BAT,   DTC_AIVI_FL_SEAT_L_SQUAWKER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_SQUAWKER       +OPEN_LOAD,   DTC_AIVI_FL_SEAT_L_SQUAWKER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_SQUAWKER       +SHORT_CIR,   DTC_AIVI_FL_SEAT_L_SQUAWKER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_TWEETER        +SHORT2GND,   DTC_AIVI_FL_SEAT_L_TWEETER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_TWEETER        +SHORT2BAT,   DTC_AIVI_FL_SEAT_L_TWEETER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_TWEETER        +OPEN_LOAD,   DTC_AIVI_FL_SEAT_L_TWEETER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_L_TWEETER        +SHORT_CIR,   DTC_AIVI_FL_SEAT_L_TWEETER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_SPEAKER        +SHORT2GND,   DTC_AIVI_FL_SEAT_C_SPEAKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_SPEAKER        +SHORT2BAT,   DTC_AIVI_FL_SEAT_C_SPEAKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_SPEAKER        +OPEN_LOAD,   DTC_AIVI_FL_SEAT_C_SPEAKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_SPEAKER        +SHORT_CIR,   DTC_AIVI_FL_SEAT_C_SPEAKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_WOOFER         +SHORT2GND,   DTC_AIVI_FL_SEAT_C_WOOFER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_WOOFER         +SHORT2BAT,   DTC_AIVI_FL_SEAT_C_WOOFER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_WOOFER         +OPEN_LOAD,   DTC_AIVI_FL_SEAT_C_WOOFER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_WOOFER         +SHORT_CIR,   DTC_AIVI_FL_SEAT_C_WOOFER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_SQUAWKER       +SHORT2GND,   DTC_AIVI_FL_SEAT_C_SQUAWKER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_SQUAWKER       +SHORT2BAT,   DTC_AIVI_FL_SEAT_C_SQUAWKER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_SQUAWKER       +OPEN_LOAD,   DTC_AIVI_FL_SEAT_C_SQUAWKER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_SQUAWKER       +SHORT_CIR,   DTC_AIVI_FL_SEAT_C_SQUAWKER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_TWEETER        +SHORT2GND,   DTC_AIVI_FL_SEAT_C_TWEETER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_TWEETER        +SHORT2BAT,   DTC_AIVI_FL_SEAT_C_TWEETER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_TWEETER        +OPEN_LOAD,   DTC_AIVI_FL_SEAT_C_TWEETER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_C_TWEETER        +SHORT_CIR,   DTC_AIVI_FL_SEAT_C_TWEETER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_SPEAKER        +SHORT2GND,   DTC_AIVI_FL_SEAT_R_SPEAKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_SPEAKER        +SHORT2BAT,   DTC_AIVI_FL_SEAT_R_SPEAKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_SPEAKER        +OPEN_LOAD,   DTC_AIVI_FL_SEAT_R_SPEAKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_SPEAKER        +SHORT_CIR,   DTC_AIVI_FL_SEAT_R_SPEAKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_WOOFER         +SHORT2GND,   DTC_AIVI_FL_SEAT_R_WOOFER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_WOOFER         +SHORT2BAT,   DTC_AIVI_FL_SEAT_R_WOOFER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_WOOFER         +OPEN_LOAD,   DTC_AIVI_FL_SEAT_R_WOOFER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_WOOFER         +SHORT_CIR,   DTC_AIVI_FL_SEAT_R_WOOFER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_SQUAWKER       +SHORT2GND,   DTC_AIVI_FL_SEAT_R_SQUAWKER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_SQUAWKER       +SHORT2BAT,   DTC_AIVI_FL_SEAT_R_SQUAWKER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_SQUAWKER       +OPEN_LOAD,   DTC_AIVI_FL_SEAT_R_SQUAWKER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_SQUAWKER       +SHORT_CIR,   DTC_AIVI_FL_SEAT_R_SQUAWKER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_TWEETER        +SHORT2GND,   DTC_AIVI_FL_SEAT_R_TWEETER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_TWEETER        +SHORT2BAT,   DTC_AIVI_FL_SEAT_R_TWEETER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_TWEETER        +OPEN_LOAD,   DTC_AIVI_FL_SEAT_R_TWEETER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_SEAT_R_TWEETER        +SHORT_CIR,   DTC_AIVI_FL_SEAT_R_TWEETER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_SPEAKER        +SHORT2GND,   DTC_AIVI_FR_SEAT_L_SPEAKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_SPEAKER        +SHORT2BAT,   DTC_AIVI_FR_SEAT_L_SPEAKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_SPEAKER        +OPEN_LOAD,   DTC_AIVI_FR_SEAT_L_SPEAKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_SPEAKER        +SHORT_CIR,   DTC_AIVI_FR_SEAT_L_SPEAKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_WOOFER         +SHORT2GND,   DTC_AIVI_FR_SEAT_L_WOOFER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_WOOFER         +SHORT2BAT,   DTC_AIVI_FR_SEAT_L_WOOFER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_WOOFER         +OPEN_LOAD,   DTC_AIVI_FR_SEAT_L_WOOFER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_WOOFER         +SHORT_CIR,   DTC_AIVI_FR_SEAT_L_WOOFER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_SQUAWKER       +SHORT2GND,   DTC_AIVI_FR_SEAT_L_SQUAWKER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_SQUAWKER       +SHORT2BAT,   DTC_AIVI_FR_SEAT_L_SQUAWKER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_SQUAWKER       +OPEN_LOAD,   DTC_AIVI_FR_SEAT_L_SQUAWKER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_SQUAWKER       +SHORT_CIR,   DTC_AIVI_FR_SEAT_L_SQUAWKER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_TWEETER        +SHORT2GND,   DTC_AIVI_FR_SEAT_L_TWEETER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_TWEETER        +SHORT2BAT,   DTC_AIVI_FR_SEAT_L_TWEETER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_TWEETER        +OPEN_LOAD,   DTC_AIVI_FR_SEAT_L_TWEETER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_L_TWEETER        +SHORT_CIR,   DTC_AIVI_FR_SEAT_L_TWEETER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_SPEAKER        +SHORT2GND,   DTC_AIVI_FR_SEAT_C_SPEAKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_SPEAKER        +SHORT2BAT,   DTC_AIVI_FR_SEAT_C_SPEAKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_SPEAKER        +OPEN_LOAD,   DTC_AIVI_FR_SEAT_C_SPEAKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_SPEAKER        +SHORT_CIR,   DTC_AIVI_FR_SEAT_C_SPEAKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_WOOFER         +SHORT2GND,   DTC_AIVI_FR_SEAT_C_WOOFER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_WOOFER         +SHORT2BAT,   DTC_AIVI_FR_SEAT_C_WOOFER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_WOOFER         +OPEN_LOAD,   DTC_AIVI_FR_SEAT_C_WOOFER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_WOOFER         +SHORT_CIR,   DTC_AIVI_FR_SEAT_C_WOOFER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_SQUAWKER       +SHORT2GND,   DTC_AIVI_FR_SEAT_C_SQUAWKER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_SQUAWKER       +SHORT2BAT,   DTC_AIVI_FR_SEAT_C_SQUAWKER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_SQUAWKER       +OPEN_LOAD,   DTC_AIVI_FR_SEAT_C_SQUAWKER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_SQUAWKER       +SHORT_CIR,   DTC_AIVI_FR_SEAT_C_SQUAWKER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_TWEETER        +SHORT2GND,   DTC_AIVI_FR_SEAT_C_TWEETER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_TWEETER        +SHORT2BAT,   DTC_AIVI_FR_SEAT_C_TWEETER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_TWEETER        +OPEN_LOAD,   DTC_AIVI_FR_SEAT_C_TWEETER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_C_TWEETER        +SHORT_CIR,   DTC_AIVI_FR_SEAT_C_TWEETER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_SPEAKER        +SHORT2GND,   DTC_AIVI_FR_SEAT_R_SPEAKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_SPEAKER        +SHORT2BAT,   DTC_AIVI_FR_SEAT_R_SPEAKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_SPEAKER        +OPEN_LOAD,   DTC_AIVI_FR_SEAT_R_SPEAKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_SPEAKER        +SHORT_CIR,   DTC_AIVI_FR_SEAT_R_SPEAKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_WOOFER         +SHORT2GND,   DTC_AIVI_FR_SEAT_R_WOOFER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_WOOFER         +SHORT2BAT,   DTC_AIVI_FR_SEAT_R_WOOFER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_WOOFER         +OPEN_LOAD,   DTC_AIVI_FR_SEAT_R_WOOFER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_WOOFER         +SHORT_CIR,   DTC_AIVI_FR_SEAT_R_WOOFER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_SQUAWKER       +SHORT2GND,   DTC_AIVI_FR_SEAT_R_SQUAWKER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_SQUAWKER       +SHORT2BAT,   DTC_AIVI_FR_SEAT_R_SQUAWKER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_SQUAWKER       +OPEN_LOAD,   DTC_AIVI_FR_SEAT_R_SQUAWKER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_SQUAWKER       +SHORT_CIR,   DTC_AIVI_FR_SEAT_R_SQUAWKER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_TWEETER        +SHORT2GND,   DTC_AIVI_FR_SEAT_R_TWEETER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_TWEETER        +SHORT2BAT,   DTC_AIVI_FR_SEAT_R_TWEETER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_TWEETER        +OPEN_LOAD,   DTC_AIVI_FR_SEAT_R_TWEETER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_SEAT_R_TWEETER        +SHORT_CIR,   DTC_AIVI_FR_SEAT_R_TWEETER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_SPEAKER        +SHORT2GND,   DTC_AIVI_FL_PILLAR_SPEAKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_SPEAKER        +SHORT2BAT,   DTC_AIVI_FL_PILLAR_SPEAKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_SPEAKER        +OPEN_LOAD,   DTC_AIVI_FL_PILLAR_SPEAKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_SPEAKER        +SHORT_CIR,   DTC_AIVI_FL_PILLAR_SPEAKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_WOOFER         +SHORT2GND,   DTC_AIVI_FL_PILLAR_WOOFER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_WOOFER         +SHORT2BAT,   DTC_AIVI_FL_PILLAR_WOOFER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_WOOFER         +OPEN_LOAD,   DTC_AIVI_FL_PILLAR_WOOFER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_WOOFER         +SHORT_CIR,   DTC_AIVI_FL_PILLAR_WOOFER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_SQUAWKER       +SHORT2GND,   DTC_AIVI_FL_PILLAR_SQUAWKER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_SQUAWKER       +SHORT2BAT,   DTC_AIVI_FL_PILLAR_SQUAWKER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_SQUAWKER       +OPEN_LOAD,   DTC_AIVI_FL_PILLAR_SQUAWKER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_SQUAWKER       +SHORT_CIR,   DTC_AIVI_FL_PILLAR_SQUAWKER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_TWEETER        +SHORT2GND,   DTC_AIVI_FL_PILLAR_TWEETER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_TWEETER        +SHORT2BAT,   DTC_AIVI_FL_PILLAR_TWEETER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_TWEETER        +OPEN_LOAD,   DTC_AIVI_FL_PILLAR_TWEETER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FL_PILLAR_TWEETER        +SHORT_CIR,   DTC_AIVI_FL_PILLAR_TWEETER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_SPEAKER        +SHORT2GND,   DTC_AIVI_FR_PILLAR_SPEAKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_SPEAKER        +SHORT2BAT,   DTC_AIVI_FR_PILLAR_SPEAKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_SPEAKER        +OPEN_LOAD,   DTC_AIVI_FR_PILLAR_SPEAKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_SPEAKER        +SHORT_CIR,   DTC_AIVI_FR_PILLAR_SPEAKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_WOOFER         +SHORT2GND,   DTC_AIVI_FR_PILLAR_WOOFER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_WOOFER         +SHORT2BAT,   DTC_AIVI_FR_PILLAR_WOOFER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_WOOFER         +OPEN_LOAD,   DTC_AIVI_FR_PILLAR_WOOFER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_WOOFER         +SHORT_CIR,   DTC_AIVI_FR_PILLAR_WOOFER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_SQUAWKER       +SHORT2GND,   DTC_AIVI_FR_PILLAR_SQUAWKER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_SQUAWKER       +SHORT2BAT,   DTC_AIVI_FR_PILLAR_SQUAWKER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_SQUAWKER       +OPEN_LOAD,   DTC_AIVI_FR_PILLAR_SQUAWKER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_SQUAWKER       +SHORT_CIR,   DTC_AIVI_FR_PILLAR_SQUAWKER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_TWEETER        +SHORT2GND,   DTC_AIVI_FR_PILLAR_TWEETER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_TWEETER        +SHORT2BAT,   DTC_AIVI_FR_PILLAR_TWEETER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_TWEETER        +OPEN_LOAD,   DTC_AIVI_FR_PILLAR_TWEETER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FR_PILLAR_TWEETER        +SHORT_CIR,   DTC_AIVI_FR_PILLAR_TWEETER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_SPEAKER      +SHORT2GND,   DTC_AIVI_F_CONSOLE_C_SPEAKER     +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_SPEAKER      +SHORT2BAT,   DTC_AIVI_F_CONSOLE_C_SPEAKER     +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_SPEAKER      +OPEN_LOAD,   DTC_AIVI_F_CONSOLE_C_SPEAKER     +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_SPEAKER      +SHORT_CIR,   DTC_AIVI_F_CONSOLE_C_SPEAKER     +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_WOOFER       +SHORT2GND,   DTC_AIVI_F_CONSOLE_C_WOOFER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_WOOFER       +SHORT2BAT,   DTC_AIVI_F_CONSOLE_C_WOOFER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_WOOFER       +OPEN_LOAD,   DTC_AIVI_F_CONSOLE_C_WOOFER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_WOOFER       +SHORT_CIR,   DTC_AIVI_F_CONSOLE_C_WOOFER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_SQUAWKER     +SHORT2GND,   DTC_AIVI_F_CONSOLE_C_SQUAWKER    +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_SQUAWKER     +SHORT2BAT,   DTC_AIVI_F_CONSOLE_C_SQUAWKER    +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_SQUAWKER     +OPEN_LOAD,   DTC_AIVI_F_CONSOLE_C_SQUAWKER    +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_SQUAWKER     +SHORT_CIR,   DTC_AIVI_F_CONSOLE_C_SQUAWKER    +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_TWEETER      +SHORT2GND,   DTC_AIVI_F_CONSOLE_C_TWEETER     +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_TWEETER      +SHORT2BAT,   DTC_AIVI_F_CONSOLE_C_TWEETER     +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_TWEETER      +OPEN_LOAD,   DTC_AIVI_F_CONSOLE_C_TWEETER     +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_F_CONSOLE_C_TWEETER      +SHORT_CIR,   DTC_AIVI_F_CONSOLE_C_TWEETER     +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_SPEAKER          +SHORT2GND,   DTC_AIVI_2L_DOOR_SPEAKER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_SPEAKER          +SHORT2BAT,   DTC_AIVI_2L_DOOR_SPEAKER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_SPEAKER          +OPEN_LOAD,   DTC_AIVI_2L_DOOR_SPEAKER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_SPEAKER          +SHORT_CIR,   DTC_AIVI_2L_DOOR_SPEAKER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_WOOFER           +SHORT2GND,   DTC_AIVI_2L_DOOR_WOOFER          +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_WOOFER           +SHORT2BAT,   DTC_AIVI_2L_DOOR_WOOFER          +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_WOOFER           +OPEN_LOAD,   DTC_AIVI_2L_DOOR_WOOFER          +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_WOOFER           +SHORT_CIR,   DTC_AIVI_2L_DOOR_WOOFER          +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_SQUAWKER         +SHORT2GND,   DTC_AIVI_2L_DOOR_SQUAWKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_SQUAWKER         +SHORT2BAT,   DTC_AIVI_2L_DOOR_SQUAWKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_SQUAWKER         +OPEN_LOAD,   DTC_AIVI_2L_DOOR_SQUAWKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_SQUAWKER         +SHORT_CIR,   DTC_AIVI_2L_DOOR_SQUAWKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_TWEETER          +SHORT2GND,   DTC_AIVI_2L_DOOR_TWEETER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_TWEETER          +SHORT2BAT,   DTC_AIVI_2L_DOOR_TWEETER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_TWEETER          +OPEN_LOAD,   DTC_AIVI_2L_DOOR_TWEETER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2L_DOOR_TWEETER          +SHORT_CIR,   DTC_AIVI_2L_DOOR_TWEETER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_SPEAKER          +SHORT2GND,   DTC_AIVI_2R_DOOR_SPEAKER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_SPEAKER          +SHORT2BAT,   DTC_AIVI_2R_DOOR_SPEAKER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_SPEAKER          +OPEN_LOAD,   DTC_AIVI_2R_DOOR_SPEAKER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_SPEAKER          +SHORT_CIR,   DTC_AIVI_2R_DOOR_SPEAKER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_WOOFER           +SHORT2GND,   DTC_AIVI_2R_DOOR_WOOFER          +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_WOOFER           +SHORT2BAT,   DTC_AIVI_2R_DOOR_WOOFER          +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_WOOFER           +OPEN_LOAD,   DTC_AIVI_2R_DOOR_WOOFER          +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_WOOFER           +SHORT_CIR,   DTC_AIVI_2R_DOOR_WOOFER          +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_SQUAWKER         +SHORT2GND,   DTC_AIVI_2R_DOOR_SQUAWKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_SQUAWKER         +SHORT2BAT,   DTC_AIVI_2R_DOOR_SQUAWKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_SQUAWKER         +OPEN_LOAD,   DTC_AIVI_2R_DOOR_SQUAWKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_SQUAWKER         +SHORT_CIR,   DTC_AIVI_2R_DOOR_SQUAWKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_TWEETER          +SHORT2GND,   DTC_AIVI_2R_DOOR_TWEETER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_TWEETER          +SHORT2BAT,   DTC_AIVI_2R_DOOR_TWEETER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_TWEETER          +OPEN_LOAD,   DTC_AIVI_2R_DOOR_TWEETER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2R_DOOR_TWEETER          +SHORT_CIR,   DTC_AIVI_2R_DOOR_TWEETER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_SPEAKER         +SHORT2GND,   DTC_AIVI_2_ROOF_L_SPEAKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_SPEAKER         +SHORT2BAT,   DTC_AIVI_2_ROOF_L_SPEAKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_SPEAKER         +OPEN_LOAD,   DTC_AIVI_2_ROOF_L_SPEAKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_SPEAKER         +SHORT_CIR,   DTC_AIVI_2_ROOF_L_SPEAKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_WOOFER          +SHORT2GND,   DTC_AIVI_2_ROOF_L_WOOFER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_WOOFER          +SHORT2BAT,   DTC_AIVI_2_ROOF_L_WOOFER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_WOOFER          +OPEN_LOAD,   DTC_AIVI_2_ROOF_L_WOOFER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_WOOFER          +SHORT_CIR,   DTC_AIVI_2_ROOF_L_WOOFER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_SQUAWKER        +SHORT2GND,   DTC_AIVI_2_ROOF_L_SQUAWKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_SQUAWKER        +SHORT2BAT,   DTC_AIVI_2_ROOF_L_SQUAWKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_SQUAWKER        +OPEN_LOAD,   DTC_AIVI_2_ROOF_L_SQUAWKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_SQUAWKER        +SHORT_CIR,   DTC_AIVI_2_ROOF_L_SQUAWKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_TWEETER         +SHORT2GND,   DTC_AIVI_2_ROOF_L_TWEETER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_TWEETER         +SHORT2BAT,   DTC_AIVI_2_ROOF_L_TWEETER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_TWEETER         +OPEN_LOAD,   DTC_AIVI_2_ROOF_L_TWEETER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_L_TWEETER         +SHORT_CIR,   DTC_AIVI_2_ROOF_L_TWEETER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_SPEAKER         +SHORT2GND,   DTC_AIVI_2_ROOF_C_SPEAKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_SPEAKER         +SHORT2BAT,   DTC_AIVI_2_ROOF_C_SPEAKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_SPEAKER         +OPEN_LOAD,   DTC_AIVI_2_ROOF_C_SPEAKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_SPEAKER         +SHORT_CIR,   DTC_AIVI_2_ROOF_C_SPEAKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_WOOFER          +SHORT2GND,   DTC_AIVI_2_ROOF_C_WOOFER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_WOOFER          +SHORT2BAT,   DTC_AIVI_2_ROOF_C_WOOFER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_WOOFER          +OPEN_LOAD,   DTC_AIVI_2_ROOF_C_WOOFER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_WOOFER          +SHORT_CIR,   DTC_AIVI_2_ROOF_C_WOOFER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_SQUAWKER        +SHORT2GND,   DTC_AIVI_2_ROOF_C_SQUAWKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_SQUAWKER        +SHORT2BAT,   DTC_AIVI_2_ROOF_C_SQUAWKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_SQUAWKER        +OPEN_LOAD,   DTC_AIVI_2_ROOF_C_SQUAWKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_SQUAWKER        +SHORT_CIR,   DTC_AIVI_2_ROOF_C_SQUAWKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_TWEETER         +SHORT2GND,   DTC_AIVI_2_ROOF_C_TWEETER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_TWEETER         +SHORT2BAT,   DTC_AIVI_2_ROOF_C_TWEETER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_TWEETER         +OPEN_LOAD,   DTC_AIVI_2_ROOF_C_TWEETER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_C_TWEETER         +SHORT_CIR,   DTC_AIVI_2_ROOF_C_TWEETER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_SPEAKER         +SHORT2GND,   DTC_AIVI_2_ROOF_R_SPEAKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_SPEAKER         +SHORT2BAT,   DTC_AIVI_2_ROOF_R_SPEAKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_SPEAKER         +OPEN_LOAD,   DTC_AIVI_2_ROOF_R_SPEAKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_SPEAKER         +SHORT_CIR,   DTC_AIVI_2_ROOF_R_SPEAKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_WOOFER          +SHORT2GND,   DTC_AIVI_2_ROOF_R_WOOFER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_WOOFER          +SHORT2BAT,   DTC_AIVI_2_ROOF_R_WOOFER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_WOOFER          +OPEN_LOAD,   DTC_AIVI_2_ROOF_R_WOOFER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_WOOFER          +SHORT_CIR,   DTC_AIVI_2_ROOF_R_WOOFER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_SQUAWKER        +SHORT2GND,   DTC_AIVI_2_ROOF_R_SQUAWKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_SQUAWKER        +SHORT2BAT,   DTC_AIVI_2_ROOF_R_SQUAWKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_SQUAWKER        +OPEN_LOAD,   DTC_AIVI_2_ROOF_R_SQUAWKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_SQUAWKER        +SHORT_CIR,   DTC_AIVI_2_ROOF_R_SQUAWKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_TWEETER         +SHORT2GND,   DTC_AIVI_2_ROOF_R_TWEETER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_TWEETER         +SHORT2BAT,   DTC_AIVI_2_ROOF_R_TWEETER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_TWEETER         +OPEN_LOAD,   DTC_AIVI_2_ROOF_R_TWEETER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_2_ROOF_R_TWEETER         +SHORT_CIR,   DTC_AIVI_2_ROOF_R_TWEETER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_SPEAKER          +SHORT2GND,   DTC_AIVI_RL_DOOR_SPEAKER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_SPEAKER          +SHORT2BAT,   DTC_AIVI_RL_DOOR_SPEAKER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_SPEAKER          +OPEN_LOAD,   DTC_AIVI_RL_DOOR_SPEAKER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_SPEAKER          +SHORT_CIR,   DTC_AIVI_RL_DOOR_SPEAKER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_WOOFER           +SHORT2GND,   DTC_AIVI_RL_DOOR_WOOFER          +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_WOOFER           +SHORT2BAT,   DTC_AIVI_RL_DOOR_WOOFER          +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_WOOFER           +OPEN_LOAD,   DTC_AIVI_RL_DOOR_WOOFER          +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_WOOFER           +SHORT_CIR,   DTC_AIVI_RL_DOOR_WOOFER          +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_SQUAWKER         +SHORT2GND,   DTC_AIVI_RL_DOOR_SQUAWKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_SQUAWKER         +SHORT2BAT,   DTC_AIVI_RL_DOOR_SQUAWKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_SQUAWKER         +OPEN_LOAD,   DTC_AIVI_RL_DOOR_SQUAWKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_SQUAWKER         +SHORT_CIR,   DTC_AIVI_RL_DOOR_SQUAWKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_TWEETER          +SHORT2GND,   DTC_AIVI_RL_DOOR_TWEETER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_TWEETER          +SHORT2BAT,   DTC_AIVI_RL_DOOR_TWEETER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_TWEETER          +OPEN_LOAD,   DTC_AIVI_RL_DOOR_TWEETER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_DOOR_TWEETER          +SHORT_CIR,   DTC_AIVI_RL_DOOR_TWEETER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_SPEAKER          +SHORT2GND,   DTC_AIVI_RR_DOOR_SPEAKER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_SPEAKER          +SHORT2BAT,   DTC_AIVI_RR_DOOR_SPEAKER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_SPEAKER          +OPEN_LOAD,   DTC_AIVI_RR_DOOR_SPEAKER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_SPEAKER          +SHORT_CIR,   DTC_AIVI_RR_DOOR_SPEAKER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_WOOFER           +SHORT2GND,   DTC_AIVI_RR_DOOR_WOOFER          +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_WOOFER           +SHORT2BAT,   DTC_AIVI_RR_DOOR_WOOFER          +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_WOOFER           +OPEN_LOAD,   DTC_AIVI_RR_DOOR_WOOFER          +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_WOOFER           +SHORT_CIR,   DTC_AIVI_RR_DOOR_WOOFER          +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_SQUAWKER         +SHORT2GND,   DTC_AIVI_RR_DOOR_SQUAWKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_SQUAWKER         +SHORT2BAT,   DTC_AIVI_RR_DOOR_SQUAWKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_SQUAWKER         +OPEN_LOAD,   DTC_AIVI_RR_DOOR_SQUAWKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_SQUAWKER         +SHORT_CIR,   DTC_AIVI_RR_DOOR_SQUAWKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_TWEETER          +SHORT2GND,   DTC_AIVI_RR_DOOR_TWEETER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_TWEETER          +SHORT2BAT,   DTC_AIVI_RR_DOOR_TWEETER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_TWEETER          +OPEN_LOAD,   DTC_AIVI_RR_DOOR_TWEETER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_DOOR_TWEETER          +SHORT_CIR,   DTC_AIVI_RR_DOOR_TWEETER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_SPEAKER       +SHORT2GND,   DTC_AIVI_R_PSHELF_L_SPEAKER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_SPEAKER       +SHORT2BAT,   DTC_AIVI_R_PSHELF_L_SPEAKER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_SPEAKER       +OPEN_LOAD,   DTC_AIVI_R_PSHELF_L_SPEAKER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_SPEAKER       +SHORT_CIR,   DTC_AIVI_R_PSHELF_L_SPEAKER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_WOOFER        +SHORT2GND,   DTC_AIVI_R_PSHELF_L_WOOFER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_WOOFER        +SHORT2BAT,   DTC_AIVI_R_PSHELF_L_WOOFER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_WOOFER        +OPEN_LOAD,   DTC_AIVI_R_PSHELF_L_WOOFER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_WOOFER        +SHORT_CIR,   DTC_AIVI_R_PSHELF_L_WOOFER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_SQUAWKER      +SHORT2GND,   DTC_AIVI_R_PSHELF_L_SQUAWKER     +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_SQUAWKER      +SHORT2BAT,   DTC_AIVI_R_PSHELF_L_SQUAWKER     +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_SQUAWKER      +OPEN_LOAD,   DTC_AIVI_R_PSHELF_L_SQUAWKER     +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_SQUAWKER      +SHORT_CIR,   DTC_AIVI_R_PSHELF_L_SQUAWKER     +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_TWEETER       +SHORT2GND,   DTC_AIVI_R_PSHELF_L_TWEETER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_TWEETER       +SHORT2BAT,   DTC_AIVI_R_PSHELF_L_TWEETER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_TWEETER       +OPEN_LOAD,   DTC_AIVI_R_PSHELF_L_TWEETER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_L_TWEETER       +SHORT_CIR,   DTC_AIVI_R_PSHELF_L_TWEETER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_SPEAKER       +SHORT2GND,   DTC_AIVI_R_PSHELF_C_SPEAKER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_SPEAKER       +SHORT2BAT,   DTC_AIVI_R_PSHELF_C_SPEAKER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_SPEAKER       +OPEN_LOAD,   DTC_AIVI_R_PSHELF_C_SPEAKER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_SPEAKER       +SHORT_CIR,   DTC_AIVI_R_PSHELF_C_SPEAKER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_WOOFER        +SHORT2GND,   DTC_AIVI_R_PSHELF_C_WOOFER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_WOOFER        +SHORT2BAT,   DTC_AIVI_R_PSHELF_C_WOOFER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_WOOFER        +OPEN_LOAD,   DTC_AIVI_R_PSHELF_C_WOOFER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_WOOFER        +SHORT_CIR,   DTC_AIVI_R_PSHELF_C_WOOFER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_SQUAWKER      +SHORT2GND,   DTC_AIVI_R_PSHELF_C_SQUAWKER     +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_SQUAWKER      +SHORT2BAT,   DTC_AIVI_R_PSHELF_C_SQUAWKER     +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_SQUAWKER      +OPEN_LOAD,   DTC_AIVI_R_PSHELF_C_SQUAWKER     +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_SQUAWKER      +SHORT_CIR,   DTC_AIVI_R_PSHELF_C_SQUAWKER     +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_TWEETER       +SHORT2GND,   DTC_AIVI_R_PSHELF_C_TWEETER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_TWEETER       +SHORT2BAT,   DTC_AIVI_R_PSHELF_C_TWEETER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_TWEETER       +OPEN_LOAD,   DTC_AIVI_R_PSHELF_C_TWEETER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_C_TWEETER       +SHORT_CIR,   DTC_AIVI_R_PSHELF_C_TWEETER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_SPEAKER       +SHORT2GND,   DTC_AIVI_R_PSHELF_R_SPEAKER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_SPEAKER       +SHORT2BAT,   DTC_AIVI_R_PSHELF_R_SPEAKER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_SPEAKER       +OPEN_LOAD,   DTC_AIVI_R_PSHELF_R_SPEAKER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_SPEAKER       +SHORT_CIR,   DTC_AIVI_R_PSHELF_R_SPEAKER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_WOOFER        +SHORT2GND,   DTC_AIVI_R_PSHELF_R_WOOFER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_WOOFER        +SHORT2BAT,   DTC_AIVI_R_PSHELF_R_WOOFER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_WOOFER        +OPEN_LOAD,   DTC_AIVI_R_PSHELF_R_WOOFER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_WOOFER        +SHORT_CIR,   DTC_AIVI_R_PSHELF_R_WOOFER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_SQUAWKER      +SHORT2GND,   DTC_AIVI_R_PSHELF_R_SQUAWKER     +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_SQUAWKER      +SHORT2BAT,   DTC_AIVI_R_PSHELF_R_SQUAWKER     +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_SQUAWKER      +OPEN_LOAD,   DTC_AIVI_R_PSHELF_R_SQUAWKER     +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_SQUAWKER      +SHORT_CIR,   DTC_AIVI_R_PSHELF_R_SQUAWKER     +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_TWEETER       +SHORT2GND,   DTC_AIVI_R_PSHELF_R_TWEETER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_TWEETER       +SHORT2BAT,   DTC_AIVI_R_PSHELF_R_TWEETER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_TWEETER       +OPEN_LOAD,   DTC_AIVI_R_PSHELF_R_TWEETER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_PSHELF_R_TWEETER       +SHORT_CIR,   DTC_AIVI_R_PSHELF_R_TWEETER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_SPEAKER        +SHORT2GND,   DTC_AIVI_RL_PILLAR_SPEAKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_SPEAKER        +SHORT2BAT,   DTC_AIVI_RL_PILLAR_SPEAKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_SPEAKER        +OPEN_LOAD,   DTC_AIVI_RL_PILLAR_SPEAKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_SPEAKER        +SHORT_CIR,   DTC_AIVI_RL_PILLAR_SPEAKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_WOOFER         +SHORT2GND,   DTC_AIVI_RL_PILLAR_WOOFER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_WOOFER         +SHORT2BAT,   DTC_AIVI_RL_PILLAR_WOOFER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_WOOFER         +OPEN_LOAD,   DTC_AIVI_RL_PILLAR_WOOFER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_WOOFER         +SHORT_CIR,   DTC_AIVI_RL_PILLAR_WOOFER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_SQUAWKER       +SHORT2GND,   DTC_AIVI_RL_PILLAR_SQUAWKER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_SQUAWKER       +SHORT2BAT,   DTC_AIVI_RL_PILLAR_SQUAWKER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_SQUAWKER       +OPEN_LOAD,   DTC_AIVI_RL_PILLAR_SQUAWKER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_SQUAWKER       +SHORT_CIR,   DTC_AIVI_RL_PILLAR_SQUAWKER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_TWEETER        +SHORT2GND,   DTC_AIVI_RL_PILLAR_TWEETER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_TWEETER        +SHORT2BAT,   DTC_AIVI_RL_PILLAR_TWEETER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_TWEETER        +OPEN_LOAD,   DTC_AIVI_RL_PILLAR_TWEETER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RL_PILLAR_TWEETER        +SHORT_CIR,   DTC_AIVI_RL_PILLAR_TWEETER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_SPEAKER        +SHORT2GND,   DTC_AIVI_RR_PILLAR_SPEAKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_SPEAKER        +SHORT2BAT,   DTC_AIVI_RR_PILLAR_SPEAKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_SPEAKER        +OPEN_LOAD,   DTC_AIVI_RR_PILLAR_SPEAKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_SPEAKER        +SHORT_CIR,   DTC_AIVI_RR_PILLAR_SPEAKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_WOOFER         +SHORT2GND,   DTC_AIVI_RR_PILLAR_WOOFER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_WOOFER         +SHORT2BAT,   DTC_AIVI_RR_PILLAR_WOOFER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_WOOFER         +OPEN_LOAD,   DTC_AIVI_RR_PILLAR_WOOFER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_WOOFER         +SHORT_CIR,   DTC_AIVI_RR_PILLAR_WOOFER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_SQUAWKER       +SHORT2GND,   DTC_AIVI_RR_PILLAR_SQUAWKER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_SQUAWKER       +SHORT2BAT,   DTC_AIVI_RR_PILLAR_SQUAWKER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_SQUAWKER       +OPEN_LOAD,   DTC_AIVI_RR_PILLAR_SQUAWKER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_SQUAWKER       +SHORT_CIR,   DTC_AIVI_RR_PILLAR_SQUAWKER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_TWEETER        +SHORT2GND,   DTC_AIVI_RR_PILLAR_TWEETER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_TWEETER        +SHORT2BAT,   DTC_AIVI_RR_PILLAR_TWEETER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_TWEETER        +OPEN_LOAD,   DTC_AIVI_RR_PILLAR_TWEETER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_RR_PILLAR_TWEETER        +SHORT_CIR,   DTC_AIVI_RR_PILLAR_TWEETER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_SPEAKER      +SHORT2GND,   DTC_AIVI_R_LUGGAGE_L_SPEAKER     +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_SPEAKER      +SHORT2BAT,   DTC_AIVI_R_LUGGAGE_L_SPEAKER     +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_SPEAKER      +OPEN_LOAD,   DTC_AIVI_R_LUGGAGE_L_SPEAKER     +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_SPEAKER      +SHORT_CIR,   DTC_AIVI_R_LUGGAGE_L_SPEAKER     +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_WOOFER       +SHORT2GND,   DTC_AIVI_R_LUGGAGE_L_WOOFER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_WOOFER       +SHORT2BAT,   DTC_AIVI_R_LUGGAGE_L_WOOFER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_WOOFER       +OPEN_LOAD,   DTC_AIVI_R_LUGGAGE_L_WOOFER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_WOOFER       +SHORT_CIR,   DTC_AIVI_R_LUGGAGE_L_WOOFER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_SQUAWKER     +SHORT2GND,   DTC_AIVI_R_LUGGAGE_L_SQUAWKER    +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_SQUAWKER     +SHORT2BAT,   DTC_AIVI_R_LUGGAGE_L_SQUAWKER    +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_SQUAWKER     +OPEN_LOAD,   DTC_AIVI_R_LUGGAGE_L_SQUAWKER    +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_SQUAWKER     +SHORT_CIR,   DTC_AIVI_R_LUGGAGE_L_SQUAWKER    +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_TWEETER      +SHORT2GND,   DTC_AIVI_R_LUGGAGE_L_TWEETER     +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_TWEETER      +SHORT2BAT,   DTC_AIVI_R_LUGGAGE_L_TWEETER     +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_TWEETER      +OPEN_LOAD,   DTC_AIVI_R_LUGGAGE_L_TWEETER     +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_L_TWEETER      +SHORT_CIR,   DTC_AIVI_R_LUGGAGE_L_TWEETER     +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_SPEAKER      +SHORT2GND,   DTC_AIVI_R_LUGGAGE_C_SPEAKER     +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_SPEAKER      +SHORT2BAT,   DTC_AIVI_R_LUGGAGE_C_SPEAKER     +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_SPEAKER      +OPEN_LOAD,   DTC_AIVI_R_LUGGAGE_C_SPEAKER     +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_SPEAKER      +SHORT_CIR,   DTC_AIVI_R_LUGGAGE_C_SPEAKER     +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_WOOFER       +SHORT2GND,   DTC_AIVI_R_LUGGAGE_C_WOOFER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_WOOFER       +SHORT2BAT,   DTC_AIVI_R_LUGGAGE_C_WOOFER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_WOOFER       +OPEN_LOAD,   DTC_AIVI_R_LUGGAGE_C_WOOFER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_WOOFER       +SHORT_CIR,   DTC_AIVI_R_LUGGAGE_C_WOOFER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_SQUAWKER     +SHORT2GND,   DTC_AIVI_R_LUGGAGE_C_SQUAWKER    +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_SQUAWKER     +SHORT2BAT,   DTC_AIVI_R_LUGGAGE_C_SQUAWKER    +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_SQUAWKER     +OPEN_LOAD,   DTC_AIVI_R_LUGGAGE_C_SQUAWKER    +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_SQUAWKER     +SHORT_CIR,   DTC_AIVI_R_LUGGAGE_C_SQUAWKER    +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_TWEETER      +SHORT2GND,   DTC_AIVI_R_LUGGAGE_C_TWEETER     +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_TWEETER      +SHORT2BAT,   DTC_AIVI_R_LUGGAGE_C_TWEETER     +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_TWEETER      +OPEN_LOAD,   DTC_AIVI_R_LUGGAGE_C_TWEETER     +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_C_TWEETER      +SHORT_CIR,   DTC_AIVI_R_LUGGAGE_C_TWEETER     +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_SPEAKER      +SHORT2GND,   DTC_AIVI_R_LUGGAGE_R_SPEAKER     +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_SPEAKER      +SHORT2BAT,   DTC_AIVI_R_LUGGAGE_R_SPEAKER     +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_SPEAKER      +OPEN_LOAD,   DTC_AIVI_R_LUGGAGE_R_SPEAKER     +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_SPEAKER      +SHORT_CIR,   DTC_AIVI_R_LUGGAGE_R_SPEAKER     +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_WOOFER       +SHORT2GND,   DTC_AIVI_R_LUGGAGE_R_WOOFER      +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_WOOFER       +SHORT2BAT,   DTC_AIVI_R_LUGGAGE_R_WOOFER      +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_WOOFER       +OPEN_LOAD,   DTC_AIVI_R_LUGGAGE_R_WOOFER      +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_WOOFER       +SHORT_CIR,   DTC_AIVI_R_LUGGAGE_R_WOOFER      +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_SQUAWKER     +SHORT2GND,   DTC_AIVI_R_LUGGAGE_R_SQUAWKER    +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_SQUAWKER     +SHORT2BAT,   DTC_AIVI_R_LUGGAGE_R_SQUAWKER    +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_SQUAWKER     +OPEN_LOAD,   DTC_AIVI_R_LUGGAGE_R_SQUAWKER    +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_SQUAWKER     +SHORT_CIR,   DTC_AIVI_R_LUGGAGE_R_SQUAWKER    +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_TWEETER      +SHORT2GND,   DTC_AIVI_R_LUGGAGE_R_TWEETER     +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_TWEETER      +SHORT2BAT,   DTC_AIVI_R_LUGGAGE_R_TWEETER     +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_TWEETER      +OPEN_LOAD,   DTC_AIVI_R_LUGGAGE_R_TWEETER     +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_LUGGAGE_R_TWEETER      +SHORT_CIR,   DTC_AIVI_R_LUGGAGE_R_TWEETER     +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_SPEAKER         +SHORT2GND,   DTC_AIVI_R_ROOF_L_SPEAKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_SPEAKER         +SHORT2BAT,   DTC_AIVI_R_ROOF_L_SPEAKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_SPEAKER         +OPEN_LOAD,   DTC_AIVI_R_ROOF_L_SPEAKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_SPEAKER         +SHORT_CIR,   DTC_AIVI_R_ROOF_L_SPEAKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_WOOFER          +SHORT2GND,   DTC_AIVI_R_ROOF_L_WOOFER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_WOOFER          +SHORT2BAT,   DTC_AIVI_R_ROOF_L_WOOFER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_WOOFER          +OPEN_LOAD,   DTC_AIVI_R_ROOF_L_WOOFER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_WOOFER          +SHORT_CIR,   DTC_AIVI_R_ROOF_L_WOOFER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_SQUAWKER        +SHORT2GND,   DTC_AIVI_R_ROOF_L_SQUAWKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_SQUAWKER        +SHORT2BAT,   DTC_AIVI_R_ROOF_L_SQUAWKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_SQUAWKER        +OPEN_LOAD,   DTC_AIVI_R_ROOF_L_SQUAWKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_SQUAWKER        +SHORT_CIR,   DTC_AIVI_R_ROOF_L_SQUAWKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_TWEETER         +SHORT2GND,   DTC_AIVI_R_ROOF_L_TWEETER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_TWEETER         +SHORT2BAT,   DTC_AIVI_R_ROOF_L_TWEETER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_TWEETER         +OPEN_LOAD,   DTC_AIVI_R_ROOF_L_TWEETER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_L_TWEETER         +SHORT_CIR,   DTC_AIVI_R_ROOF_L_TWEETER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_SPEAKER         +SHORT2GND,   DTC_AIVI_R_ROOF_C_SPEAKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_SPEAKER         +SHORT2BAT,   DTC_AIVI_R_ROOF_C_SPEAKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_SPEAKER         +OPEN_LOAD,   DTC_AIVI_R_ROOF_C_SPEAKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_SPEAKER         +SHORT_CIR,   DTC_AIVI_R_ROOF_C_SPEAKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_WOOFER          +SHORT2GND,   DTC_AIVI_R_ROOF_C_WOOFER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_WOOFER          +SHORT2BAT,   DTC_AIVI_R_ROOF_C_WOOFER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_WOOFER          +OPEN_LOAD,   DTC_AIVI_R_ROOF_C_WOOFER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_WOOFER          +SHORT_CIR,   DTC_AIVI_R_ROOF_C_WOOFER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_SQUAWKER        +SHORT2GND,   DTC_AIVI_R_ROOF_C_SQUAWKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_SQUAWKER        +SHORT2BAT,   DTC_AIVI_R_ROOF_C_SQUAWKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_SQUAWKER        +OPEN_LOAD,   DTC_AIVI_R_ROOF_C_SQUAWKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_SQUAWKER        +SHORT_CIR,   DTC_AIVI_R_ROOF_C_SQUAWKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_TWEETER         +SHORT2GND,   DTC_AIVI_R_ROOF_C_TWEETER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_TWEETER         +SHORT2BAT,   DTC_AIVI_R_ROOF_C_TWEETER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_TWEETER         +OPEN_LOAD,   DTC_AIVI_R_ROOF_C_TWEETER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_C_TWEETER         +SHORT_CIR,   DTC_AIVI_R_ROOF_C_TWEETER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_SPEAKER         +SHORT2GND,   DTC_AIVI_R_ROOF_R_SPEAKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_SPEAKER         +SHORT2BAT,   DTC_AIVI_R_ROOF_R_SPEAKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_SPEAKER         +OPEN_LOAD,   DTC_AIVI_R_ROOF_R_SPEAKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_SPEAKER         +SHORT_CIR,   DTC_AIVI_R_ROOF_R_SPEAKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_WOOFER          +SHORT2GND,   DTC_AIVI_R_ROOF_R_WOOFER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_WOOFER          +SHORT2BAT,   DTC_AIVI_R_ROOF_R_WOOFER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_WOOFER          +OPEN_LOAD,   DTC_AIVI_R_ROOF_R_WOOFER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_WOOFER          +SHORT_CIR,   DTC_AIVI_R_ROOF_R_WOOFER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_SQUAWKER        +SHORT2GND,   DTC_AIVI_R_ROOF_R_SQUAWKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_SQUAWKER        +SHORT2BAT,   DTC_AIVI_R_ROOF_R_SQUAWKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_SQUAWKER        +OPEN_LOAD,   DTC_AIVI_R_ROOF_R_SQUAWKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_SQUAWKER        +SHORT_CIR,   DTC_AIVI_R_ROOF_R_SQUAWKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_TWEETER         +SHORT2GND,   DTC_AIVI_R_ROOF_R_TWEETER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_TWEETER         +SHORT2BAT,   DTC_AIVI_R_ROOF_R_TWEETER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_TWEETER         +OPEN_LOAD,   DTC_AIVI_R_ROOF_R_TWEETER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_R_ROOF_R_TWEETER         +SHORT_CIR,   DTC_AIVI_R_ROOF_R_TWEETER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_SPEAKER         +SHORT2GND,   DTC_AIVI_B_DOOR_L_SPEAKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_SPEAKER         +SHORT2BAT,   DTC_AIVI_B_DOOR_L_SPEAKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_SPEAKER         +OPEN_LOAD,   DTC_AIVI_B_DOOR_L_SPEAKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_SPEAKER         +SHORT_CIR,   DTC_AIVI_B_DOOR_L_SPEAKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_WOOFER          +SHORT2GND,   DTC_AIVI_B_DOOR_L_WOOFER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_WOOFER          +SHORT2BAT,   DTC_AIVI_B_DOOR_L_WOOFER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_WOOFER          +OPEN_LOAD,   DTC_AIVI_B_DOOR_L_WOOFER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_WOOFER          +SHORT_CIR,   DTC_AIVI_B_DOOR_L_WOOFER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_SQUAWKER        +SHORT2GND,   DTC_AIVI_B_DOOR_L_SQUAWKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_SQUAWKER        +SHORT2BAT,   DTC_AIVI_B_DOOR_L_SQUAWKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_SQUAWKER        +OPEN_LOAD,   DTC_AIVI_B_DOOR_L_SQUAWKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_SQUAWKER        +SHORT_CIR,   DTC_AIVI_B_DOOR_L_SQUAWKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_TWEETER         +SHORT2GND,   DTC_AIVI_B_DOOR_L_TWEETER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_TWEETER         +SHORT2BAT,   DTC_AIVI_B_DOOR_L_TWEETER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_TWEETER         +OPEN_LOAD,   DTC_AIVI_B_DOOR_L_TWEETER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_L_TWEETER         +SHORT_CIR,   DTC_AIVI_B_DOOR_L_TWEETER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_SPEAKER         +SHORT2GND,   DTC_AIVI_B_DOOR_C_SPEAKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_SPEAKER         +SHORT2BAT,   DTC_AIVI_B_DOOR_C_SPEAKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_SPEAKER         +OPEN_LOAD,   DTC_AIVI_B_DOOR_C_SPEAKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_SPEAKER         +SHORT_CIR,   DTC_AIVI_B_DOOR_C_SPEAKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_WOOFER          +SHORT2GND,   DTC_AIVI_B_DOOR_C_WOOFER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_WOOFER          +SHORT2BAT,   DTC_AIVI_B_DOOR_C_WOOFER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_WOOFER          +OPEN_LOAD,   DTC_AIVI_B_DOOR_C_WOOFER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_WOOFER          +SHORT_CIR,   DTC_AIVI_B_DOOR_C_WOOFER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_SQUAWKER        +SHORT2GND,   DTC_AIVI_B_DOOR_C_SQUAWKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_SQUAWKER        +SHORT2BAT,   DTC_AIVI_B_DOOR_C_SQUAWKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_SQUAWKER        +OPEN_LOAD,   DTC_AIVI_B_DOOR_C_SQUAWKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_SQUAWKER        +SHORT_CIR,   DTC_AIVI_B_DOOR_C_SQUAWKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_TWEETER         +SHORT2GND,   DTC_AIVI_B_DOOR_C_TWEETER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_TWEETER         +SHORT2BAT,   DTC_AIVI_B_DOOR_C_TWEETER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_TWEETER         +OPEN_LOAD,   DTC_AIVI_B_DOOR_C_TWEETER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_C_TWEETER         +SHORT_CIR,   DTC_AIVI_B_DOOR_C_TWEETER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_SPEAKER         +SHORT2GND,   DTC_AIVI_B_DOOR_R_SPEAKER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_SPEAKER         +SHORT2BAT,   DTC_AIVI_B_DOOR_R_SPEAKER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_SPEAKER         +OPEN_LOAD,   DTC_AIVI_B_DOOR_R_SPEAKER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_SPEAKER         +SHORT_CIR,   DTC_AIVI_B_DOOR_R_SPEAKER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_WOOFER          +SHORT2GND,   DTC_AIVI_B_DOOR_R_WOOFER         +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_WOOFER          +SHORT2BAT,   DTC_AIVI_B_DOOR_R_WOOFER         +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_WOOFER          +OPEN_LOAD,   DTC_AIVI_B_DOOR_R_WOOFER         +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_WOOFER          +SHORT_CIR,   DTC_AIVI_B_DOOR_R_WOOFER         +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_SQUAWKER        +SHORT2GND,   DTC_AIVI_B_DOOR_R_SQUAWKER       +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_SQUAWKER        +SHORT2BAT,   DTC_AIVI_B_DOOR_R_SQUAWKER       +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_SQUAWKER        +OPEN_LOAD,   DTC_AIVI_B_DOOR_R_SQUAWKER       +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_SQUAWKER        +SHORT_CIR,   DTC_AIVI_B_DOOR_R_SQUAWKER       +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_TWEETER         +SHORT2GND,   DTC_AIVI_B_DOOR_R_TWEETER        +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_TWEETER         +SHORT2BAT,   DTC_AIVI_B_DOOR_R_TWEETER        +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_TWEETER         +OPEN_LOAD,   DTC_AIVI_B_DOOR_R_TWEETER        +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_B_DOOR_R_TWEETER         +SHORT_CIR,   DTC_AIVI_B_DOOR_R_TWEETER        +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FRONT_LEFT_DOOR_SPEAKER  +SHORT2GND,   DTC_AIVI_FRONT_LEFT_DOOR_SPEAKER +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FRONT_LEFT_DOOR_SPEAKER  +SHORT2BAT,   DTC_AIVI_FRONT_LEFT_DOOR_SPEAKER +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FRONT_LEFT_DOOR_SPEAKER  +OPEN_LOAD,   DTC_AIVI_FRONT_LEFT_DOOR_SPEAKER +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FRONT_LEFT_DOOR_SPEAKER  +SHORT_CIR,   DTC_AIVI_FRONT_LEFT_DOOR_SPEAKER +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FRONT_RIGHT_DOOR_SPEAKER +SHORT2GND,   DTC_AIVI_FRONT_RIGHT_DOOR_SPEAKER+SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FRONT_RIGHT_DOOR_SPEAKER +SHORT2BAT,   DTC_AIVI_FRONT_RIGHT_DOOR_SPEAKER+SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FRONT_RIGHT_DOOR_SPEAKER +OPEN_LOAD,   DTC_AIVI_FRONT_RIGHT_DOOR_SPEAKER+OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_FRONT_RIGHT_DOOR_SPEAKER +SHORT_CIR,   DTC_AIVI_FRONT_RIGHT_DOOR_SPEAKER+SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_REAR_LEFT_DOOR_WOOFER    +SHORT2GND,   DTC_AIVI_REAR_LEFT_DOOR_WOOFER   +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_REAR_LEFT_DOOR_WOOFER    +SHORT2BAT,   DTC_AIVI_REAR_LEFT_DOOR_WOOFER   +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_REAR_LEFT_DOOR_WOOFER    +OPEN_LOAD,   DTC_AIVI_REAR_LEFT_DOOR_WOOFER   +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_REAR_LEFT_DOOR_WOOFER    +SHORT_CIR,   DTC_AIVI_REAR_LEFT_DOOR_WOOFER   +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_REAR_RIGHT_DOOR_WOOFER   +SHORT2GND,   DTC_AIVI_REAR_RIGHT_DOOR_WOOFER  +SHORT2GND,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_REAR_RIGHT_DOOR_WOOFER   +SHORT2BAT,   DTC_AIVI_REAR_RIGHT_DOOR_WOOFER  +SHORT2BAT,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_REAR_RIGHT_DOOR_WOOFER   +OPEN_LOAD,   DTC_AIVI_REAR_RIGHT_DOOR_WOOFER  +OPEN_LOAD,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_REAR_RIGHT_DOOR_WOOFER   +SHORT_CIR,   DTC_AIVI_REAR_RIGHT_DOOR_WOOFER  +SHORT_CIR,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//
///* ANC MIC FOR BOSE */
//{ITC_AIVI_ANC_MIC1_CIRC            +SHORT_STD, (DTC_AIVI_BOSE_ANC_MIC1_CIRC & 0xFFFF00)+SHORT_STD+1,BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC1_CIRC            +SHORT2GND,  DTC_AIVI_BOSE_ANC_MIC1_CIRC   +SHORT2GND,           BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC1_CIRC            +SHORT2BAT,  DTC_AIVI_BOSE_ANC_MIC1_CIRC   +SHORT2BAT,           BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC1_CIRC            +OPEN_LOAD,  DTC_AIVI_BOSE_ANC_MIC1_CIRC   +OPEN_LOAD,           BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC2_CIRC            +SHORT_STD, (DTC_AIVI_BOSE_ANC_MIC2_CIRC & 0xFFFF00)+SHORT_STD+1,BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC2_CIRC            +SHORT2GND,  DTC_AIVI_BOSE_ANC_MIC2_CIRC   +SHORT2GND,           BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC2_CIRC            +SHORT2BAT,  DTC_AIVI_BOSE_ANC_MIC2_CIRC   +SHORT2BAT,           BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC2_CIRC            +OPEN_LOAD,  DTC_AIVI_BOSE_ANC_MIC2_CIRC   +OPEN_LOAD,           BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC3_CIRC            +SHORT_STD, (DTC_AIVI_BOSE_ANC_MIC3_CIRC & 0xFFFF00)+SHORT_STD+1,BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC3_CIRC            +SHORT2GND,  DTC_AIVI_BOSE_ANC_MIC3_CIRC   +SHORT2GND,           BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC3_CIRC            +SHORT2BAT,  DTC_AIVI_BOSE_ANC_MIC3_CIRC   +SHORT2BAT,           BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC3_CIRC            +OPEN_LOAD,  DTC_AIVI_BOSE_ANC_MIC3_CIRC   +OPEN_LOAD,           BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC4_CIRC            +SHORT_STD, (DTC_AIVI_BOSE_ANC_MIC4_CIRC & 0xFFFF00)+SHORT_STD+1,BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC4_CIRC            +SHORT2GND,  DTC_AIVI_BOSE_ANC_MIC4_CIRC   +SHORT2GND,           BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC4_CIRC            +SHORT2BAT,  DTC_AIVI_BOSE_ANC_MIC4_CIRC   +SHORT2BAT,           BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MIC4_CIRC            +OPEN_LOAD,  DTC_AIVI_BOSE_ANC_MIC4_CIRC   +OPEN_LOAD,           BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//
///* A-IVI ANC MICROPHONE */
////{ITC_AIVI_ANC_MICROPHONE_INPUT_CIRCUIT,              0x9F0004,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ANC_MICROPHONE_INPUT_SIGNAL_1,             0x9F0A16,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_ANC_MICROPHONE_INPUT_SIGNAL_2,             0x9F0F16,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_ANC_MICROPHONE_INPUT_SIGNAL_3,             0x9F1416,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_ANC_MICROPHONE_INPUT_SIGNAL_4,             0x9F1916,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//
///* SELF DIAGNOSIS CAN */
////{ITC_AIVI_SELF_DIAGNOSIS_CAN_COMMUNICATION_FAIL_ECM, 0x9F0529,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_SELF_DIAGNOSIS_CAN_COMMUNICATION_FAIL_HCM, 0x9F2229,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_SELF_DIAGNOSIS_CAN_COMMUNICATION_FAIL_BCM, 0xC14000,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_SELF_DIAGNOSIS_ASC_VOLUME_CONTROL_ECM,     0xC10000,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_SELF_DIAGNOSIS_ASC_VOLUME_CONTROL_HCM,     0xC29300,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//
///* ASC VOLUME CONTROL CAN */
////{ITC_AIVI_ASC_VOL_CTRL_CAN_COMM_FAIL_ECM_ACCELP_OPEN_ENG_TOR,         0x9F0629,                     BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_ASC_VOL_CTRL_CAN_COMM_FAIL_ADAS_ASLSETTING_SPEED,           0x9F1F29,                     BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_ASC_VOL_CTRL_CAN_COMM_FAIL_CL_VEH_SPEED_ERROR_STD_BOSE,     0x9F2029,                     BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_ASC_VOL_CTRL_CAN_COMM_FAIL_HCM_ACCELP_OPEN_ENG_TOR,         0x9F2329,                     BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_ASC_VOL_CTRL_CAN_COMM_FAIL_ADAS,                            0xC10400,                     BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_ASC_VOL_CTRL_ANC_STABILITY_CAN_SIGNAL_FAIL_METER,           0xC15500,                     BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//
////{ITC_AIVI_ANC_UNIT_EEPROM_ACCESS_ERROR,              0x9F0049,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_ENGINE_SPEED_SIGNAL_ERROR,                 0x9F0162,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_MODE_CHANGE_CAN_COMM_FAIL_DR_MODE_SIG_4CAN,0x9F0729,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_ANC_CTRL_CAN_COMM_FAIL_BCM_DOOR_OPEN_CLOSE,0x9F2129,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_MODE_CHANGE_CAN_COMM_FAIL_IDM,             0xC19800,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_AMP_TEMPERATURE,                           0xD23198,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_AV_COMMUNICATION,                          0xD30001,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
////{ITC_AIVI_MODE_CHANGE_CAN_COMM_FAIL_TGW,             0xD40E87,                                      BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//
///*LVDS Failures*/
//{ITC_LVDS_IN_MEDIA_COMM_FAILURE,                     /* LVDS IN Media Player - Communication problem              */ 0x93DE8F,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_LVDS_IN_CAMERA_COMM_FAILURE,                  /* LVDS IN LVDS CAMERA - Communication problem               */ 0x93DA8F,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_LVDS_OUT_CP_LINE_COMM_FAILURE,                  /* LVDS OUT CP Line  - Communication problem                 */ 0x93DD8F,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_LVDS_OUT_CP_LINE_I2C_TIMEOUT,                  /* LVDS OUT CP Line  - I2C time-out detect                   */ 0x93DD87,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_LVDS_OUT_SECOND_DISPLAY_COMM_FAILURE,          /* LVDS OUT 2nd Display  - Communication problem             */ 0x93DB8F,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_LVDS_OUT_SECOND_DISPLAY_I2C_TIMEOUT,           /* LVDS OUT 2nd Display  - I2C time-out detect               */ 0x93DB87,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_LVDS_OUT_RSE_COMM_FAILURE,                     /* LVDS OUT RSE - Communication problem                      */ 0x93DF8F,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_LVDS_IN_DTV_BOX_COMM_FAILURE,                  /* LVDS IN DTV BOX - Communication problem                   */ 0x93D88F,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//
///*DIAG_MUX */
//{ITC_AIVI_DIAGMUX_VCAN_BUS_OFF,                     /* lost communication with VCAN BUS OFF                        */ 0xC07900,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_AUT_TRAN_LOST_COM,           /* lost communication with VCAN AUT train                      */ 0xE14187,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_CLUSTER_LOST_COM,            /* lost communication with VCAN cluster                        */ 0xE14E87,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_BCM_LOST_COM,                /* lost communication with VCAN BCM                            */ 0xE14F87,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_E_POW_STEER_LOST_COM,        /* lost communication with VCAN E_Power steer                  */ 0xE15987,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_E_STAB_CON_LOST_COM,         /* lost communication with VCAN E_STAB_CAN                     */ 0xE14887,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_UN_SWITCH_MOD_LOST_COM,      /* lost communication with VCAN UN_Switchmod                   */ 0xE15B87,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_FR_CAMERA_LOST_COM,          /* lost communication with VCAN Front camera                   */ 0xE16B87,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_INT_DYN_CON_LOST_COM,        /* lost communication with VCAN internal dynamic                 */ 0xE17687,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_ULT_SON_ADAS_LOST_COM,       /* lost communication with VCAN ultra son_ADAS                 */ 0xE16587,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_FOUR_WHEEL_ST_LOST_COM,      /* lost communication with VCAN Four wheel_ST                  */ 0xE10487,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_AVM_LOST_COM,                /* lost communication with VCAN AVM                             */ 0xE17587,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_HAND_FREE_MOD_LOST_COM,      /* lost communication with VCAN Handfree mod                   */ 0xE11887,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_CLIM_CONTROL_LOST_COM,       /* lost communication with VCAN Clim control                   */ 0xE15387,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_HUD_LOST_COM,                /* lost communication with VCAN Hud                            */ 0xE17387,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_TCU_LOST_COM,                /* lost communication with VCAN TCU                             */ 0xE16D87,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_AIRBAG_CONT_LOST_COM,        /* lost communication with VCAN AIRBAG control                 */ 0xE15087,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_ADV_DRIV_ASSIST_LOST_COM,    /* lost communication with VCAN ADV Drive assitance            */ 0xE15287,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_BL_SPOT_WARN_LOST_COM,       /* lost communication with VCAN BL spot warn                   */ 0xE16E87,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_ENG_CONT_MOD_LOST_COM,       /* lost communication with VCAN engine cont mod                */ 0xE14087,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_HYBR_ELEC_VEH_LOST_COM,      /* lost communication with VCAN hybrid electric vechicle       */ 0xE14387,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_SCENE_REC_LOST_COM,          /* lost communication with VCAN scene rec                      */ 0xE18787,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_VCAN_AUT_DRI_SEAT_LOST_COM,       /* lost communication with VCAN Aut driver seat                */ 0xE16487,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_MCAN_CENT_PAN_LOST_COM,           /* lost communication with MCAN CENTPAN                        */ 0xE02387,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_PASSENGER_SEAT_LOST_COM,          /* lost communication with Seat Passenger                      */ 0xE17787,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_CLUSTER_LOST_COM,                  /* lost communication with Cluster on multimedia CAN           */ 0xE24E87,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_AMP_V1_CAN_LOST_COM,              /* lost communication with AMP on V1 CAN                       */ 0xE02587,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_V_DIST_LOST_COM,                  /* lost communication with V-DIST (RSE) on multimedia CAN      */ 0xE00A87,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_TELEMATICS_CONTROL_LOST_COM,      /* lost communication with TelematicContrl Unit multimediaCAN  */ 0xE26D87,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_GATEWAY_LOST_COM,                  /* lost communication with Gateway                             */ 0xE76888,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_DIAGMUX_GATEWAY_ERROR_COM,                  /* error communication with Gateway                           */ 0xE7688F,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//
//{ITC_AIVI_PART_AUTH_VNEXT_MASTER_AUTH_NOK,          /* Part Authentication  Vnext Master Authentication NOK        */ 0xAE3806,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_VNEXT_REGIONAL_AUTH_NOK,        /* Part Authentication  Vnext Regional Authentication NOK      */ 0xAE3906,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_VNEXT_MASTER_TIMEOUT,           /* Part Authentication  Vnext Master timeout                   */ 0xAE3A06,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_VNEXT_REGIONAL_TIMEOUT,         /* Part Authentication  Vnext Regional timeout                 */ 0xAE3B06,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_UNKNOWN_PART_ID,                /* Part Authentication  Unknown Part-ID                        */ 0xAE3C06,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_BAD_PAIRING_AIVI_VIN,           /* Part Authentication  Bad Pairing A-IVI & VIN                */ 0xAE3D06,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_NO_CERTIFICATE_AVAILABLE,       /* Part Authentication  No Certificate available               */ 0xAE3E06,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_CERTIFICATE_VERIFICATION_FAILS, /* Part Authentication  Part Certificate Verification fails    */ 0xAE3F06,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_CERTIFICATE_STORAGE_ERROR,      /* Part Authentication  Part Certificate Storage error         */ 0xAE4006,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_AIVI_AUTHENTICATION_FAILS,      /* Part Authentication  A-IVI Authentication Fails             */ 0xAE4106,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_AIVI_NO_REGION_SETTING,         /* Part Authentication  A-IVI no Region Setting                */ 0xAE4206,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_AIVI_INVALID_REGION_SETTING,    /* Part Authentication  A-IVI Invalid Region Setting           */ 0xAE4306,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_REGION_SETTING_STORAGE_ERROR,   /* Part Authentication  Region Setting Storage error           */ 0xAE4406,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_AIVI_NO_PARTITION_SETTING,      /* Part Authentication  A-IVI no Partition Setting             */ 0xAE4506,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_AIVI_INVALID_PARTITION_SETTING, /* Part Authentication  A-IVI Invalid Partition Setting        */ 0xAE4606,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_PARTITION_SETTING_STORAGE_ERROR,/* Part Authentication  Partition Setting Storage error        */ 0xAE4706,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_PART_AUTH_SERVICE_CHECK_NOT_COMPLETE,     /* Part Authentication  Service Check not complete             */ 0xAE4806,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_CELLULAR_TLS_SESSION_ERROR,               /* Cellular TLS Session error                                  */ 0xAE1706,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_CELLULAR_VNEXT_CONFIGURATION_DISCARDED,   /* Cellular Vnext Configuration discarded                      */ 0xAE1981,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
//{ITC_AIVI_CELLULAR_INVALID_AIVI_CERTIFICATE,        /* Cellular	Invalid A-IVI certificate                          */ 0xAE2168,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            }
};

int g_iDtcDefinitionTableSize()
{
  return (static_cast<int>(sizeof(g_oaDtcDefinitionTable)/sizeof(trReportRecordData)));
}


/***********************************************************************
// Internal DTCs as backlog for ITCs used by other Diagnostic services,
// e.g. Multimedia Network Diagnosis
***********************************************************************/
const trReportRecordData g_oaDtcDefinitionTableIntern[] =
{
// ITC                                                                                  * DTC         *   report *   variant,                    * severity * warning   * enable  * Clear      * Ageing  * clear on  * clear on  *  change    *   fail  *  pass  * max   * Aging Cycle     * TestFrequency    * DTC Block List     *  Blocking Mode   * Application-ID                                               * Freeze Frame Data                     * Snapshot Data
//                                                                                      * (inc. FTB)  *   TYP    *                               * priority * indicator * Logging * allowed    * allowed * FirstPass * Startup   *  without   *   delta *  delta * age   *                 *                  *                    *  Blocking Mode   * for retrigger                                                *                                       * (max Elements
//                                                                                      *             *          *                               *          *           *         *            *         *           *           *  debounce  *   [ms]  *  [ms]  *       *                 *                  *                    *                  *                                                              *                                       *  or final 0)
//
{ITC_AIVI_MCAN_METER_AUD_MPDT_MUTE_ERR,      /* AV Communication                       */ 0xD10001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AIVI_MCAN_METER_AUD_CMF_MUTE_ERR,       /* AV Communication                       */ 0xD10002,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AIVI_MCAN_METER_SWC_MPDT_MUTE_ERR,      /* AV Communication                       */ 0xD10003,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AIVI_MCAN_METER_SWC_CMF_MUTE_ERR,       /* AV Communication                       */ 0xD10004,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AIVI_MCAN_METER_NAV_MPDT_MUTE_ERR,      /* AV Communication                       */ 0xD10005,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AIVI_MCAN_METER_NAV_CMF_MUTE_ERR,       /* AV Communication                       */ 0xD10006,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AIVI_MCAN_TCU_MPDT_MUTE_ERR,            /* AV Communication                       */ 0xD10007,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AIVI_MCAN_TCU_CMF_MUTE_ERR,             /* AV Communication                       */ 0xD10008,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AIVI_MCAN_REAR_SW_MPDT_MUTE_ERR,        /* AV Communication                       */ 0xD10009,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AIVI_MCAN_REAR_SW_CMF_MUTE_ERR,         /* AV Communication                       */ 0xD1000A,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AIVI_MCAN_IT_COMM_MPDT_MUTE_ERR,        /* AV Communication                       */ 0xD1000B,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AIVI_MCAN_IT_COMM_CMF_MUTE_ERR,         /* AV Communication                       */ 0xD1000C,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AIVI_MCAN_METER_NAV_GEN2_MPDT_MUTE_ERR, /* AV Communication                       */ 0xD1000D,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
{ITC_AIVI_MCAN_METER_NAV_GEN2_CMF_MUTE_ERR,  /* AV Communication                       */ 0xD1000E,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_ACC_START,      CONTINUOUSLY,   {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},        {SSD_MILE_OCC/*, SSD_OCC_CTR*/}            },
};

int g_iDtcDefinitionTableInternSize()
{
  return (static_cast<int>(sizeof(g_oaDtcDefinitionTableIntern)/sizeof(trReportRecordData)));
}


/***********************************************************************
// Re-Programming (Calibration) DTCs
***********************************************************************/
const trReportRecordData g_oaDtcDefinitionTableReProgramming[] =
{
// ITC                                                                                  * DTC         *   report *   variant,                    * severity * warning   * enable  * Clear      * Ageing  * clear on  * clear on  *  change    *   fail  *  pass  * max   * Aging Cycle     * TestFrequency    * DTC Block List     *  Blocking Mode   * Application-ID                                               * Freeze Frame Data                     * Snapshot Data
//                                                                                      * (inc. FTB)  *   TYP    *                               * priority * indicator * Logging * allowed    * allowed * FirstPass * Startup   *  without   *   delta *  delta * age   *                 *                  *                    *  Blocking Mode   * for retrigger                                                *                                       * (max Elements
//                                                                                      *             *          *                               *          *           *         *            *         *           *           *  debounce  *   [ms]  *  [ms]  *       *                 *                  *                    *                  *                                                              *                                       *  or final 0)
//
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_00,   /* Programming failure/Not programmed        */ 0xFD0051,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_01,   /* Programming failure/Not programmed        */ 0xFD0151,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_02,   /* Programming failure/Not programmed        */ 0xFD0251,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_03,   /* Programming failure/Not programmed        */ 0xFD0351,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_04,   /* Programming failure/Not programmed        */ 0xFD0451,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_05,   /* Programming failure/Not programmed        */ 0xFD0551,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_06,   /* Programming failure/Not programmed        */ 0xFD0651,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_07,   /* Programming failure/Not programmed        */ 0xFD0751,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_08,   /* Programming failure/Not programmed        */ 0xFD0851,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_09,   /* Programming failure/Not programmed        */ 0xFD0951,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_0A,   /* Programming failure/Not programmed        */ 0xFD0A51,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_0B,   /* Programming failure/Not programmed        */ 0xFD0B51,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_0C,   /* Programming failure/Not programmed        */ 0xFD0C51,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_0D,   /* Programming failure/Not programmed        */ 0xFD0D51,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_PROGRAMMING_FAILURE_LB_0E,   /* Programming failure/Not programmed        */ 0xFD0E51,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },

{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_00,    /* system int. failures/General mem.failure  */ 0xFD0042,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_01,    /* system int. failures/General mem.failure  */ 0xFD0142,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_02,    /* system int. failures/General mem.failure  */ 0xFD0242,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_03,    /* system int. failures/General mem.failure  */ 0xFD0342,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_04,    /* system int. failures/General mem.failure  */ 0xFD0442,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_05,    /* system int. failures/General mem.failure  */ 0xFD0542,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_06,    /* system int. failures/General mem.failure  */ 0xFD0642,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_07,    /* system int. failures/General mem.failure  */ 0xFD0742,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_08,    /* system int. failures/General mem.failure  */ 0xFD0842,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_09,    /* system int. failures/General mem.failure  */ 0xFD0942,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0A,    /* system int. failures/General mem.failure  */ 0xFD0A42,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0B,    /* system int. failures/General mem.failure  */ 0xFD0B42,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0C,    /* system int. failures/General mem.failure  */ 0xFD0C42,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0D,    /* system int. failures/General mem.failure  */ 0xFD0D42,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_SYSTEM_INT_FAILURE_LB_0E,    /* system int. failures/General mem.failure  */ 0xFD0E42,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },

{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_00,               /* Algorithm based failure   */ 0xFD0006,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_01,               /* Algorithm based failure   */ 0xFD0106,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_02,               /* Algorithm based failure   */ 0xFD0206,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_03,               /* Algorithm based failure   */ 0xFD0306,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_04,               /* Algorithm based failure   */ 0xFD0406,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_05,               /* Algorithm based failure   */ 0xFD0506,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_06,               /* Algorithm based failure   */ 0xFD0606,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_07,               /* Algorithm based failure   */ 0xFD0706,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_08,               /* Algorithm based failure   */ 0xFD0806,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_09,               /* Algorithm based failure   */ 0xFD0906,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0A,               /* Algorithm based failure   */ 0xFD0A06,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0B,               /* Algorithm based failure   */ 0xFD0B06,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0C,               /* Algorithm based failure   */ 0xFD0C06,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0D,               /* Algorithm based failure   */ 0xFD0D06,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            },
{ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0E,               /* Algorithm based failure   */ 0xFD0E06,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                   BM_DIAG|BM_VO_OUT_RANGE     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {DIAGLOG_XD_NO},        {SSD_NO}            }
};


int g_iDtcDefinitionTableReProgrammingSize()
{
  return (static_cast<int>(sizeof(g_oaDtcDefinitionTableReProgramming)/sizeof(trReportRecordData)));
}

/*********************************************************/
// START OF TML ITC CONFIGURATION BEGINNS HERE
/*********************************************************/

const trReportRecordData g_oaDtcDefinitionTableTMLTest[] =
{
// ITC                                                        * DTC         *   report *   variant,                    * severity * warning   * enable   * Clear     * Ageing  * clear on  * clear on  *  change    *   fail  *  pass  * max   * Aging Cycle     * TestFrequency    * DTC Block List     *  Blocking Mode   * Application-ID                                               * Freeze Frame Data                     * Snapshot Data
//                                                            * (inc. FTB)  *   TYP    *                               * priority * indicator * Logging * allowed    * allowed * FirstPass * Startup   *  without   *   delta *  delta * age   *                 *                  *                    *  Blocking Mode   * for retrigger                                                *                                       * (max Elements
//                                                            *             *          *                               *          *           *         *            *         *           *           *  debounce  *   [ms]  *  [ms]  *       *                 *                  *                    *                  *                                                              *                                       *  or final 0)
//Test ITCs for TML testing - internal use only
{ITC_TML_TEST1,                 /* TML test ITC  */           0x100000,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                    BM_DIAG      ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                            {XD_MILE,XD_AGE_CTR,XD_ALL},        {0/*, SSD_OCC_CTR*/}            },
{ITC_TML_TEST2,                 /* TML test ITC  */           0x100001,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      true,        false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                    BM_DIAG      ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                            {XD_MILE,XD_AGE_CTR,XD_ALL},        {0/*, SSD_OCC_CTR*/}            },
{ITC_TML_TEST3,                 /* TML test ITC  */           0x100002,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      true,        false,      false,      false,          0,      0,    2,     AGE_IGN_START,      CONTINUOUSLY,   {0},                    BM_DIAG      ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                            {XD_MILE,XD_AGE_CTR,XD_ALL},        {0/*, SSD_OCC_CTR*/}            },
{ITC_TML_TEST4,                 /* TML test ITC  */           0x100003,       BASE  ,     V_VAR1,                          1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,   {0},                    BM_DIAG      ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                            {XD_MILE,XD_AGE_CTR,XD_ALL},        {0/*, SSD_OCC_CTR*/}            }
};

int g_iDtcDefinitionTableTMLTestSize()
{
  return (static_cast<int>(sizeof(g_oaDtcDefinitionTableTMLTest)/sizeof(trReportRecordData)));
}



/***********************************************************************
// this one is used for dynamic DTC's as base
***********************************************************************/
const trReportRecordData g_oaDtcDefinitionTable_Default[] =
{
// ITC                                                                                  * DTC         *   report *   variant,                    * severity * warning   * enable  * Clear      * Ageing  * clear on  * clear on  *  change    *   fail  *  pass  * max   * Aging Cycle     * TestFrequency    * DTC Block List     *  Blocking Mode   * Application-ID                                               * Freeze Frame Data                     * Snapshot Data
//                                                                                      * (inc. FTB)  *   TYP    *                               * priority * indicator * Logging * allowed    * allowed * FirstPass * Startup   *  without   *   delta *  delta * age   *                 *                  *                    *  Blocking Mode   * for retrigger                                                *                                       * (max Elements
//                                                                                      *             *          *                               *          *           *         *            *         *           *           *  debounce  *   [ms]  *  [ms]  *       *                 *                  *                    *                  *                                                              *                                       *  or final 0)
//
{0x0000,                                     /*                                        */  0x000000,      BASE,       0xFF,                            1,         false,    true,      true,      false,       false,      false,      false,          0,      0,   40,     AGE_IGN_START,      CONTINUOUSLY,    {0},                   BM_DIAG     ,  DIAGLOG_RETRIGGER_ID_CCA  | 0x00,                                     {XD_MILE,XD_AGE_CTR,XD_ALL},       {SSD_MILE_OCC /*, SSD_OCC_CTR*/}            }
};





