//////////////////////////////////////////////////////////////////////////
// FILE:         vd_diaglog_report_memory_factory.cpp
// PROJECT:      DIAG CORE
// SW-COMPONENT: DiagLog
//----------------------------------------------------------------------
//
// DESCRIPTION: DiagLog Report Record overwrites
//              
//----------------------------------------------------------------------
// COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
// HISTORY:      
// Date      | Author                       | Modification
// 24.09.13  | BSOT Plischke                | Initial version
//
//////////////////////////////////////////////////////////////////////////
// first include diaglog settings
#include <common/framework/vd_diaglog_settings.h>

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_main
   #include <common/framework/vd_diaglog_main.h>  
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_itc_definition_common
   #include <common/framework/vd_diaglog_itc_definition_common.h>  
#endif

#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_memory_
   #include <common/framework/vd_diaglog_report_memory.h>  
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGLOG_INFO
   #include "trcGenProj/Header/vd_diaglog_report_memory_prj.cpp.trc.h"
#endif

/******************************************************************************/
// PROJECT INCLUDES
/******************************************************************************/
#ifndef VD_DIAGLOG_INCLUDEGUARD_vd_diaglog_report_record_factory
   #include <project/framework/vd_diaglog_report_record_factory.h>  
#endif

//lint -e786  Info 786: prio3: String concatenation within initializer => the following FimeNames are together and not seperated ones
//lint -e446 Warning 446: prioX: side effect in initialize => g_iDtcDefinitionTableSize_... never change

/******************************************************************************/
// PROJECT CONFIGURATION
/******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_TRANSACTION_SAFETY
/*static*/ const tMemoryFactory vdl_tclMemoryMaster::g_oMemoryFactory[] =
{
  /* Memory Id    , ReportTyp               , StatusAvailabilityMask  , pointer to Struct                   , Size of Struct                       ,  FileName                               */
  {0x01           , DIAGLOG_REPORT_UDS      , 0x7F                    , &g_oaDtcDefinitionTable[0]          , g_iDtcDefinitionTableSize()          ,  OSAL_C_STRING_DEVICE_FFS"/diaglog.log"},
  {0x08           , DIAGLOG_REPORT_UDS      , 0x7F                    , &g_oaDtcDefinitionTableTMLTest[0]   , g_iDtcDefinitionTableTMLTestSize()   ,  OSAL_C_STRING_DEVICE_FFS"/diaglog_tml_test.log"}
};
#else
/*static*/ const tMemoryFactory vdl_tclMemoryMaster::g_oMemoryFactory[] =
{
  /* Memory Id    , ReportTyp               , StatusAvailabilityMask  , pointer to Struct                   , Size of Struct                       ,  FileName                               */ /* /var/opt/bosch/persistent/diagnosis/ */
  {DIAGLOG_MEMORY_CUSTOMER     , DIAGLOG_REPORT_UDS      , 0x39                    , &g_oaDtcDefinitionTable[0]             , g_iDtcDefinitionTableSize()             ,  "/var/opt/bosch/persistent/diagnosis/diaglog.log"},
  {DIAGLOG_MEMORY_BOSCH        , DIAGLOG_REPORT_UDS      , 0x39                    , &g_oaDtcDefinitionTableIntern[0]       , g_iDtcDefinitionTableInternSize()       ,  "/var/opt/bosch/persistent/diagnosis/diaglog_int.log"},
  {DIAGLOG_MEMORY_REPROGRAMMING, DIAGLOG_REPORT_UDS      , 0x11                    , &g_oaDtcDefinitionTableReProgramming[0], g_iDtcDefinitionTableReProgrammingSize(),  "/var/opt/bosch/persistent/diagnosis/diaglog_prog.log"}
};
#endif
//lint +e786
//lint +e446

/* static*/ int vdl_tclMemoryMaster::g_iMemoryFactoryTableSize()
{
  return (static_cast<int>(sizeof(g_oMemoryFactory)/sizeof(tMemoryFactory)));
}
